/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.client.dataimport.ConversionModel;
import fi.csc.microarray.client.dataimport.ProgressInformator;
import fi.csc.microarray.client.dataimport.RunnableImportProcess;
import fi.csc.microarray.util.MemUtil;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.io.File;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataParsingTest {
    private static final int MB = 0x100000;

    public DataParsingTest() throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
    }

    @Test
    public void testSmallSizedRealData() throws IOException {
        System.out.println("\n");
        System.out.println("Small sized real data (Rows: ~15000, Column: 4, Size: 384kb, Delimiter: Tab, Decimal separator: Dot)");
        System.out.println("Showing all rows and columns");
        System.out.println("===============================");
        long start = System.currentTimeMillis();
        ConversionModel model = new ConversionModel(null);
        model.setInputFile(new File("examples/affy_example.cel"));
        model.chopData(false, new TestInformator(0x800000L));
        System.out.println("Best suitable delimiter was: " + model.getDelim().getName());
        System.out.println("===============================");
        System.out.println("Parsing done. Total time: " + (System.currentTimeMillis() - start));
    }

    class TestInformator
    implements ProgressInformator {
        private long memoryLimit;
        private int max;

        public TestInformator(long memoryLimit) {
            this.memoryLimit = memoryLimit;
        }

        public void destroyInformator() {
        }

        public void initializeInformator() {
        }

        public void setMaximumValue(int max) {
            this.max = max;
        }

        public void setMessage(String message) {
            System.out.println("Job informator: " + message);
        }

        public void setMinimunValue(int min) {
        }

        public void setProcess(RunnableImportProcess process) {
        }

        public void setValue(int state) {
            if (state % 10000 == 0 && state != 0) {
                System.out.println("Line: " + state + "   percents done: " + (int)((float)state / (float)this.max * 100.0f) + "%   memory usage: " + MemUtil.getMemInfo());
            }
            Assert.assertTrue((MemUtil.getUsed() < this.memoryLimit ? 1 : 0) != 0, (String)("Memory limit exceeded. Limit: " + MemUtil.bytesToMegas(this.memoryLimit) + " Mb, used " + MemUtil.bytesToMegas(MemUtil.getUsed())));
        }

        public void stopProcess() {
        }

        public void setIndeterminate(boolean newValue) {
        }
    }
}

