/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray;

import fi.csc.microarray.AdminAPI;
import fi.csc.microarray.ApplicationConstants;
import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.analyser.AnalyserServer;
import fi.csc.microarray.analyser.r.VVSADLTool;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.frontend.Authenticator;
import fi.csc.microarray.frontend.FileServer;
import fi.csc.microarray.frontend.WebstartJettyServer;
import fi.csc.microarray.manager.Manager;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.NodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.module.chipster.ChipsterVVSADLParser;
import fi.csc.microarray.util.CommandLineParser;
import fi.csc.microarray.util.config.ConfigurationLoader;
import fi.csc.microarray.util.rest.FileServerTest;
import java.io.FileInputStream;

public class MicroarrayMain {
    public static void main(String[] args) {
        block31: {
            try {
                boolean needConfig;
                CommandLineParser cmdParser = new CommandLineParser();
                cmdParser.addParameter("client", false, false, null, "start client (default)");
                cmdParser.addParameter("authenticator", false, false, null, "start authenticator");
                cmdParser.addParameter("fileserver", false, false, null, "start fileserver");
                cmdParser.addParameter("analyser", false, false, null, "start analyser");
                cmdParser.addParameter("webstart", false, false, null, "start webstart service");
                cmdParser.addParameter("manager", false, false, null, "start manager service");
                cmdParser.addParameter("tests", false, false, null, "run tests");
                cmdParser.addParameter("rest-test", false, false, null, "run rest test");
                cmdParser.addParameter("nagios-check", false, false, null, "do nagios-compatitible system availability check");
                cmdParser.addParameter("system-status", false, false, null, "query and print system status");
                cmdParser.addParameter("broker-check", false, false, null, "check broker availability");
                cmdParser.addParameter("rcheck", false, true, null, "check R script syntax");
                cmdParser.addParameter("-override", false, true, null, "comma separated list of configuration overrides (e.g. \"-override ModuleA/EntryA=val1,ModuleA/EntryB=val1+val2\")");
                cmdParser.addParameter("-homework", false, false, null, "store work files in home instead of workdir");
                cmdParser.addParameter("-required-analyser-count", false, true, "1", "store work files in home instead of workdir");
                cmdParser.addParameter("-repository-url", false, true, null, "url for the fileserver repository for rest test");
                cmdParser.addParameter("-testfile", false, true, null, "testfile for rest test");
                cmdParser.addParameter("-threads", false, true, "1", "thread count for rest test");
                cmdParser.addParameter("-repeat", false, true, "1", "repeat count for rest test");
                cmdParser.addParameter("-put", false, false, null, "use put for rest test");
                cmdParser.addParameter("-get", false, false, null, "use get count for rest test");
                cmdParser.parse(args);
                if (cmdParser.userAskedHelp()) {
                    System.out.println("Chipster " + ApplicationConstants.NAMI_VERSION);
                    System.out.println("Parameters:");
                    System.out.println(cmdParser.getDescription());
                    System.exit(0);
                }
                boolean bl = needConfig = !cmdParser.hasValue("rcheck");
                if (needConfig) {
                    boolean defaultsUsed;
                    String overrides = cmdParser.getValue("-override");
                    boolean useHomeAsWorkDir = cmdParser.hasValue("-homework");
                    try {
                        defaultsUsed = MicroarrayConfiguration.loadConfiguration(overrides, useHomeAsWorkDir);
                    }
                    catch (ConfigurationLoader.OldConfigurationFormatException e) {
                        if (!(cmdParser.hasValue("authenticator") || cmdParser.hasValue("analyser") || cmdParser.hasValue("fileserver"))) {
                            SwingClientApplication.reportOldConfigurationFormatException(e);
                            return;
                        }
                        throw e;
                    }
                    if (defaultsUsed && !cmdParser.hasValue("nagios-check")) {
                        System.out.println("No configuration found, defaults used and new configuration file created.");
                    }
                }
                if (cmdParser.hasValue("authenticator")) {
                    new Authenticator();
                    break block31;
                }
                if (cmdParser.hasValue("analyser")) {
                    new AnalyserServer();
                    break block31;
                }
                if (cmdParser.hasValue("fileserver")) {
                    new FileServer();
                    break block31;
                }
                if (cmdParser.hasValue("webstart")) {
                    new WebstartJettyServer().start();
                    break block31;
                }
                if (cmdParser.hasValue("manager")) {
                    new Manager();
                    break block31;
                }
                if (cmdParser.hasValue("nagios-check") || cmdParser.hasValue("system-status")) {
                    boolean ok;
                    int requiredAnalyserCount = Integer.parseInt(cmdParser.getValue("-required-analyser-count"));
                    String error = "";
                    String status = "";
                    try {
                        NodeBase nodeSupport = new NodeBase(){

                            public String getName() {
                                return "nagios-check";
                            }
                        };
                        MessagingEndpoint endpoint = new MessagingEndpoint(nodeSupport);
                        AdminAPI api = new AdminAPI(endpoint.createTopic(Topics.Name.ADMIN_TOPIC, MessagingTopic.AccessMode.READ_WRITE), null);
                        api.setRequiredCountFor("analyser", requiredAnalyserCount);
                        boolean fastCheck = cmdParser.hasValue("nagios-check");
                        ok = api.areAllServicesUp(fastCheck);
                        error = api.getErrorStatus();
                        status = api.generateStatusReport();
                        endpoint.close();
                    }
                    catch (Exception e) {
                        ok = false;
                        error = e.getMessage();
                    }
                    if (cmdParser.hasValue("nagios-check")) {
                        if (ok) {
                            System.out.println("CHIPSTER OK");
                            System.exit(0);
                        } else {
                            System.out.println("CHIPSTER FAILED: " + error);
                            System.exit(2);
                        }
                    } else {
                        if (ok) {
                            System.out.println("Chipster OK.");
                        } else {
                            System.out.println("Chipster failed: " + error);
                        }
                        System.out.println(status);
                    }
                    break block31;
                }
                if (cmdParser.hasValue("broker-check")) {
                    String error = "";
                    try {
                        NodeBase nodeSupport = new NodeBase(){

                            public String getName() {
                                return "nagios-check";
                            }
                        };
                        MessagingEndpoint endpoint = new MessagingEndpoint(nodeSupport);
                        endpoint.close();
                    }
                    catch (Exception e) {
                        System.out.println("BROKER NOT AVAILABLE: " + error);
                        System.exit(1);
                    }
                    System.out.println("broker available");
                    System.exit(0);
                    break block31;
                }
                if (cmdParser.hasValue("rcheck")) {
                    boolean fails = false;
                    try {
                        VVSADLTool.ParsedRScript res = new VVSADLTool().parseRScript(new FileInputStream(cmdParser.getValue("rcheck")));
                        new ChipsterVVSADLParser.Validator().validate(cmdParser.getValue("rcheck"), res.VVSADL);
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        fails = true;
                    }
                    System.out.println("parse succeeded: " + !fails);
                    break block31;
                }
                if (cmdParser.hasValue("rest-test")) {
                    String repositoryUrl = cmdParser.getValue("-repository-url");
                    String testFile = cmdParser.getValue("-testfile");
                    int threads = Integer.parseInt(cmdParser.getValue("-threads"));
                    int repeats = Integer.parseInt(cmdParser.getValue("-repeat"));
                    boolean put = cmdParser.hasValue("-put");
                    boolean get = cmdParser.hasValue("-get");
                    new FileServerTest(repositoryUrl, testFile, threads, repeats, put, get);
                } else {
                    SwingClientApplication.start();
                }
            }
            catch (CommandLineParser.CommandLineException e) {
                System.out.println("Illegal parameters");
                System.out.println("  " + e.getMessage());
                System.exit(1);
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.exit(1);
            }
        }
    }
}

