/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class SecureSessionPool {
    private static final long ACTIVE_TIMEOUT_IN_MILLIS = 3600000L;
    private static final long TOTAL_TIMEOUT_IN_MILLIS = 50400000L;
    private Map<UUID, Session> sessions = new HashMap<UUID, Session>();

    public synchronized Session createSession() {
        UUID id = UUID.randomUUID();
        Session session = new Session(id);
        this.sessions.put(id, session);
        return session;
    }

    public synchronized Session getSession(UUID id) {
        Session session = this.sessions.get(id);
        if (session != null && this.isExpired(session)) {
            this.sessions.remove(session);
            return null;
        }
        return session;
    }

    private boolean isExpired(Session session) {
        return System.currentTimeMillis() - session.getLastUseTimestamp() > 3600000L || System.currentTimeMillis() - session.getCreationTimestamp() > 50400000L;
    }

    public synchronized void removeSession(Session session) {
        this.sessions.remove(session.id);
    }

    public int size() {
        return this.sessions.size();
    }

    public static void main(String[] args) {
        for (int i = 0; i < 10; ++i) {
            SecureSessionPool ssp = new SecureSessionPool();
            System.out.println(ssp.createSession().id);
        }
    }

    public class Session {
        private long creationTimestamp;
        private long lastUseTimestamp;
        private UUID id;
        private Map<String, Object> parameters = Collections.synchronizedMap(new HashMap());

        public Session(UUID id) {
            this.id = id;
            this.creationTimestamp = System.currentTimeMillis();
            this.touch();
        }

        public void putParameter(String key, Object parameter) {
            this.parameters.put(key, parameter);
        }

        public Object getParameter(String key) {
            return this.parameters.get(key);
        }

        public void removeParameter(String key) {
            this.parameters.remove(key);
        }

        public UUID getID() {
            return this.id;
        }

        public String toString() {
            return this.parameters.toString();
        }

        public void touch() {
            this.lastUseTimestamp = System.currentTimeMillis();
        }

        private long getLastUseTimestamp() {
            return this.lastUseTimestamp;
        }

        private long getCreationTimestamp() {
            return this.creationTimestamp;
        }
    }
}

