/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.antlr.Tool;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.misc.Utils;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;

public class DOTGenerator {
    public static final boolean STRIP_NONREDUCED_STATES = false;
    protected String arrowhead = "normal";
    protected String rankdir = "LR";
    public static StringTemplateGroup stlib = new StringTemplateGroup("toollib", AngleBracketTemplateLexer.class);
    protected Set markedStates = null;
    protected Grammar grammar;

    public DOTGenerator(Grammar grammar) {
        this.grammar = grammar;
    }

    public String getDOT(State state) {
        StringTemplate stringTemplate = null;
        this.markedStates = new HashSet();
        if (state instanceof DFAState) {
            stringTemplate = stlib.getInstanceOf("org/antlr/tool/templates/dot/dfa");
            stringTemplate.setAttribute("startState", (Object)Utils.integer(state.stateNumber));
            stringTemplate.setAttribute("useBox", (Object)Tool.internalOption_ShowNFConfigsInDFA);
            this.walkCreatingDFADOT(stringTemplate, (DFAState)state);
        } else {
            stringTemplate = stlib.getInstanceOf("org/antlr/tool/templates/dot/nfa");
            stringTemplate.setAttribute("startState", (Object)Utils.integer(state.stateNumber));
            this.walkRuleNFACreatingDOT(stringTemplate, state);
        }
        stringTemplate.setAttribute("rankdir", (Object)this.rankdir);
        return stringTemplate.toString();
    }

    protected void walkCreatingDFADOT(StringTemplate stringTemplate, DFAState dFAState) {
        if (this.markedStates.contains(Utils.integer(dFAState.stateNumber))) {
            return;
        }
        this.markedStates.add(Utils.integer(dFAState.stateNumber));
        StringTemplate stringTemplate2 = dFAState.isAcceptState() ? stlib.getInstanceOf("org/antlr/tool/templates/dot/stopstate") : stlib.getInstanceOf("org/antlr/tool/templates/dot/state");
        stringTemplate2.setAttribute("name", (Object)this.getStateLabel(dFAState));
        stringTemplate.setAttribute("states", (Object)stringTemplate2);
        for (int i = 0; i < dFAState.getNumberOfTransitions(); ++i) {
            Transition transition = dFAState.transition(i);
            stringTemplate2 = stlib.getInstanceOf("org/antlr/tool/templates/dot/edge");
            stringTemplate2.setAttribute("label", (Object)this.getEdgeLabel(transition));
            stringTemplate2.setAttribute("src", (Object)this.getStateLabel(dFAState));
            stringTemplate2.setAttribute("target", (Object)this.getStateLabel(transition.target));
            stringTemplate2.setAttribute("arrowhead", (Object)this.arrowhead);
            stringTemplate.setAttribute("edges", (Object)stringTemplate2);
            this.walkCreatingDFADOT(stringTemplate, (DFAState)transition.target);
        }
    }

    protected void walkRuleNFACreatingDOT(StringTemplate stringTemplate, State state) {
        Object object;
        GrammarAST grammarAST;
        if (this.markedStates.contains(state)) {
            return;
        }
        this.markedStates.add(state);
        StringTemplate stringTemplate2 = state.isAcceptState() ? stlib.getInstanceOf("org/antlr/tool/templates/dot/stopstate") : stlib.getInstanceOf("org/antlr/tool/templates/dot/state");
        stringTemplate2.setAttribute("name", (Object)this.getStateLabel(state));
        stringTemplate.setAttribute("states", (Object)stringTemplate2);
        if (state.isAcceptState()) {
            return;
        }
        if (((NFAState)state).isDecisionState() && (grammarAST = ((NFAState)state).getAssociatedASTNode()) != null && grammarAST.getType() != 19) {
            StringTemplate stringTemplate3 = stlib.getInstanceOf("org/antlr/tool/templates/dot/decision-rank");
            object = (NFAState)state;
            while (object != null) {
                stringTemplate3.setAttribute("states", (Object)this.getStateLabel((State)object));
                if (((NFAState)object).transition(1) != null) {
                    object = (NFAState)((NFAState)object).transition((int)1).target;
                    continue;
                }
                object = null;
            }
            stringTemplate.setAttribute("decisionRanks", (Object)stringTemplate3);
        }
        grammarAST = null;
        for (int i = 0; i < state.getNumberOfTransitions(); ++i) {
            object = state.transition(i);
            if (object instanceof RuleClosureTransition) {
                RuleClosureTransition ruleClosureTransition = (RuleClosureTransition)object;
                grammarAST = stlib.getInstanceOf("org/antlr/tool/templates/dot/edge");
                grammarAST.setAttribute("label", "<" + this.grammar.getRuleName(ruleClosureTransition.getRuleIndex()) + ">");
                grammarAST.setAttribute("src", this.getStateLabel(state));
                grammarAST.setAttribute("target", this.getStateLabel(ruleClosureTransition.getFollowState()));
                grammarAST.setAttribute("arrowhead", this.arrowhead);
                stringTemplate.setAttribute("edges", (Object)grammarAST);
                this.walkRuleNFACreatingDOT(stringTemplate, ruleClosureTransition.getFollowState());
                continue;
            }
            grammarAST = ((Transition)object).isEpsilon() ? stlib.getInstanceOf("org/antlr/tool/templates/dot/epsilon-edge") : stlib.getInstanceOf("org/antlr/tool/templates/dot/edge");
            grammarAST.setAttribute("label", this.getEdgeLabel((Transition)object));
            grammarAST.setAttribute("src", this.getStateLabel(state));
            grammarAST.setAttribute("target", this.getStateLabel(((Transition)object).target));
            grammarAST.setAttribute("arrowhead", this.arrowhead);
            stringTemplate.setAttribute("edges", (Object)grammarAST);
            this.walkRuleNFACreatingDOT(stringTemplate, ((Transition)object).target);
        }
    }

    protected String getEdgeLabel(Transition transition) {
        SemanticContext semanticContext;
        String string = transition.label.toString(this.grammar);
        string = Utils.replace(string, "\\", "\\\\");
        if ((string = Utils.replace(string, "\"", "\\\"")).equals("<EPSILON>")) {
            string = "e";
        }
        State state = transition.target;
        if (!transition.isSemanticPredicate() && state instanceof DFAState && (semanticContext = ((DFAState)state).getGatedPredicatesInNFAConfigurations()) != null) {
            String string2 = "";
            string2 = "&&{" + semanticContext.genExpr(this.grammar.generator, this.grammar.generator.getTemplates(), null).toString() + "}?";
            string = string + string2;
        }
        return string;
    }

    protected String getStateLabel(State state) {
        Object object;
        if (state == null) {
            return "null";
        }
        String string = String.valueOf(state.stateNumber);
        if (state instanceof DFAState) {
            object = new StringBuffer(250);
            ((StringBuffer)object).append('s');
            ((StringBuffer)object).append(state.stateNumber);
            if (Tool.internalOption_ShowNFConfigsInDFA) {
                ((StringBuffer)object).append("\\n");
                Set set = ((DFAState)state).getAltSet();
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(set);
                Collections.sort(arrayList);
                Set set2 = ((DFAState)state).getNFAConfigurations();
                for (int i = 0; i < arrayList.size(); ++i) {
                    Integer n = (Integer)arrayList.get(i);
                    int n2 = n;
                    if (i > 0) {
                        ((StringBuffer)object).append("\\n");
                    }
                    ((StringBuffer)object).append("alt");
                    ((StringBuffer)object).append(n2);
                    ((StringBuffer)object).append(':');
                    ArrayList<NFAConfiguration> arrayList2 = new ArrayList<NFAConfiguration>();
                    Iterator iterator = set2.iterator();
                    while (iterator.hasNext()) {
                        NFAConfiguration nFAConfiguration = (NFAConfiguration)iterator.next();
                        if (nFAConfiguration.alt != n2) continue;
                        arrayList2.add(nFAConfiguration);
                    }
                    int n3 = 0;
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        NFAConfiguration nFAConfiguration = (NFAConfiguration)arrayList2.get(j);
                        ++n3;
                        ((StringBuffer)object).append(nFAConfiguration.toString(false));
                        if (j + 1 < arrayList2.size()) {
                            ((StringBuffer)object).append(", ");
                        }
                        if (n3 % 5 != 0 || arrayList2.size() - j <= 3) continue;
                        ((StringBuffer)object).append("\\n");
                    }
                }
            }
            string = ((StringBuffer)object).toString();
        }
        if (state instanceof NFAState && ((NFAState)state).isDecisionState()) {
            string = string + ",d=" + ((NFAState)state).getDecisionNumber();
            if (((NFAState)state).endOfBlockStateNumber != -1) {
                string = string + ",eob=" + ((NFAState)state).endOfBlockStateNumber;
            }
        } else if (state instanceof NFAState && ((NFAState)state).endOfBlockStateNumber != -1) {
            object = (NFAState)state;
            string = string + ",eob=" + ((NFAState)object).endOfBlockStateNumber;
        } else if (state instanceof DFAState && ((DFAState)state).isAcceptState()) {
            string = string + "=>" + ((DFAState)state).getUniquelyPredictedAlt();
        }
        return '\"' + string + '\"';
    }

    public String getArrowheadType() {
        return this.arrowhead;
    }

    public void setArrowheadType(String string) {
        this.arrowhead = string;
    }

    public String getRankdir() {
        return this.rankdir;
    }

    public void setRankdir(String string) {
        this.rankdir = string;
    }
}

