/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.kaha.BytesMarshaller;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StringMarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class Loader
extends Thread {
    private static final Log LOG = LogFactory.getLog(Loader.class);
    private String name;
    private Store store;
    private int count;
    private CountDownLatch start;
    private CountDownLatch stop;

    public Loader(String name, Store store, int count, CountDownLatch start, CountDownLatch stop) {
        this.name = name;
        this.store = store;
        this.count = count;
        this.start = start;
        this.stop = stop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.start.countDown();
            this.start.await();
            StringMarshaller keyMarshaller = new StringMarshaller();
            BytesMarshaller valueMarshaller = new BytesMarshaller();
            MapContainer container = this.store.getMapContainer(this.name, this.store.getDefaultContainerName(), true);
            container.setKeyMarshaller(keyMarshaller);
            container.setValueMarshaller(valueMarshaller);
            container.load();
            byte[] value = this.getData(1024);
            long startTime = System.currentTimeMillis();
            long startLoad = System.currentTimeMillis();
            for (int i = 0; i < this.count; ++i) {
                String key = "key:" + i;
                container.put(key, value);
            }
            long finishLoad = System.currentTimeMillis();
            long totalLoadTime = finishLoad - startLoad;
            LOG.info("name " + this.name + " load time = " + totalLoadTime + "(ms)");
            Set keys = container.keySet();
            long startExtract = System.currentTimeMillis();
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                byte[] data = (byte[])container.get(i.next());
            }
            long finishExtract = System.currentTimeMillis();
            long totalExtractTime = finishExtract - startExtract;
            LOG.info("name " + this.name + " extract time = " + totalExtractTime + "(ms)");
            long startRemove = System.currentTimeMillis();
            Iterator i2 = keys.iterator();
            while (i2.hasNext()) {
                container.remove(i2.next());
            }
            long finishRemove = System.currentTimeMillis();
            long totalRemoveTime = finishRemove - startRemove;
            LOG.info("name " + this.name + " remove time = " + totalRemoveTime + "(ms)");
            startLoad = System.currentTimeMillis();
            value = this.getData(2048);
            for (int i3 = 0; i3 < this.count; ++i3) {
                String key = "key:" + i3;
                container.put(key, value);
            }
            finishLoad = System.currentTimeMillis();
            totalLoadTime = finishLoad - startLoad;
            LOG.info("name " + this.name + " 2nd load time = " + totalLoadTime + "(ms)");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.stop.countDown();
        }
    }

    byte[] getData(int size) {
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = 97;
        }
        return result;
    }
}

