/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.activemq.ActiveMQDispatcher;
import org.apache.activemq.ActiveMQMessageTransformation;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.MessageAvailableConsumer;
import org.apache.activemq.MessageAvailableListener;
import org.apache.activemq.MessageDispatchChannel;
import org.apache.activemq.MessageTransformer;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTempDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.management.JMSConsumerStatsImpl;
import org.apache.activemq.management.StatsCapable;
import org.apache.activemq.management.StatsImpl;
import org.apache.activemq.selector.SelectorParser;
import org.apache.activemq.thread.Scheduler;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.util.Callback;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQMessageConsumer
implements MessageAvailableConsumer,
StatsCapable,
ActiveMQDispatcher {
    private static final Log LOG = LogFactory.getLog(ActiveMQMessageConsumer.class);
    protected final ActiveMQSession session;
    protected final ConsumerInfo info;
    private final MessageDispatchChannel unconsumedMessages = new MessageDispatchChannel();
    private final LinkedList<MessageDispatch> deliveredMessages = new LinkedList();
    private int deliveredCounter;
    private int additionalWindowSize;
    private long redeliveryDelay;
    private int ackCounter;
    private int dispatchedCount;
    private final AtomicReference<MessageListener> messageListener = new AtomicReference();
    private JMSConsumerStatsImpl stats;
    private final String selector;
    private boolean synchronizationRegistered;
    private AtomicBoolean started = new AtomicBoolean(false);
    private MessageAvailableListener availableListener;
    private RedeliveryPolicy redeliveryPolicy;
    private boolean optimizeAcknowledge;
    private AtomicBoolean deliveryingAcknowledgements = new AtomicBoolean();
    private ExecutorService executorService;
    private MessageTransformer transformer;
    private boolean clearDispatchList;

    public ActiveMQMessageConsumer(ActiveMQSession session, ConsumerId consumerId, ActiveMQDestination dest, String name, String selector, int prefetch, int maximumPendingMessageCount, boolean noLocal, boolean browser, boolean dispatchAsync, MessageListener messageListener) throws JMSException {
        if (dest == null) {
            throw new InvalidDestinationException("Don't understand null destinations");
        }
        if (dest.getPhysicalName() == null) {
            throw new InvalidDestinationException("The destination object was not given a physical name.");
        }
        if (dest.isTemporary()) {
            String physicalName = dest.getPhysicalName();
            if (physicalName == null) {
                throw new IllegalArgumentException("Physical name of Destination should be valid: " + dest);
            }
            String connectionID = session.connection.getConnectionInfo().getConnectionId().getValue();
            if (physicalName.indexOf(connectionID) < 0) {
                throw new InvalidDestinationException("Cannot use a Temporary destination from another Connection");
            }
            if (session.connection.isDeleted(dest)) {
                throw new InvalidDestinationException("Cannot use a Temporary destination that has been deleted");
            }
            if (prefetch < 0) {
                throw new JMSException("Cannot have a prefetch size less than zero");
            }
        }
        this.session = session;
        this.redeliveryPolicy = session.connection.getRedeliveryPolicy();
        this.setTransformer(session.getTransformer());
        this.info = new ConsumerInfo(consumerId);
        this.info.setExclusive(this.session.connection.isExclusiveConsumer());
        this.info.setSubscriptionName(name);
        this.info.setPrefetchSize(prefetch);
        this.info.setCurrentPrefetchSize(prefetch);
        this.info.setMaximumPendingMessageLimit(maximumPendingMessageCount);
        this.info.setNoLocal(noLocal);
        this.info.setDispatchAsync(dispatchAsync);
        this.info.setRetroactive(this.session.connection.isUseRetroactiveConsumer());
        this.info.setSelector(null);
        if (dest.getOptions() != null) {
            HashMap<String, String> options = new HashMap<String, String>(dest.getOptions());
            IntrospectionSupport.setProperties(this.info, options, "consumer.");
        }
        this.info.setDestination(dest);
        this.info.setBrowser(browser);
        if (selector != null && selector.trim().length() != 0) {
            new SelectorParser().parse(selector);
            this.info.setSelector(selector);
            this.selector = selector;
        } else if (this.info.getSelector() != null) {
            new SelectorParser().parse(this.info.getSelector());
            this.selector = this.info.getSelector();
        } else {
            this.selector = null;
        }
        this.stats = new JMSConsumerStatsImpl(session.getSessionStats(), dest);
        this.optimizeAcknowledge = session.connection.isOptimizeAcknowledge() && session.isAutoAcknowledge() && !this.info.isBrowser();
        this.info.setOptimizedAcknowledge(this.optimizeAcknowledge);
        if (messageListener != null) {
            this.setMessageListener(messageListener);
        }
        try {
            this.session.addConsumer(this);
            this.session.syncSendPacket(this.info);
        }
        catch (JMSException e) {
            this.session.removeConsumer(this);
            throw e;
        }
        if (session.connection.isStarted()) {
            this.start();
        }
    }

    public StatsImpl getStats() {
        return this.stats;
    }

    public JMSConsumerStatsImpl getConsumerStats() {
        return this.stats;
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public MessageTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(MessageTransformer transformer) {
        this.transformer = transformer;
    }

    protected ConsumerId getConsumerId() {
        return this.info.getConsumerId();
    }

    protected String getConsumerName() {
        return this.info.getSubscriptionName();
    }

    protected boolean isNoLocal() {
        return this.info.isNoLocal();
    }

    protected boolean isBrowser() {
        return this.info.isBrowser();
    }

    protected ActiveMQDestination getDestination() {
        return this.info.getDestination();
    }

    public int getPrefetchNumber() {
        return this.info.getPrefetchSize();
    }

    public boolean isDurableSubscriber() {
        return this.info.getSubscriptionName() != null && this.info.getDestination().isTopic();
    }

    public String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.selector;
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.messageListener.get();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
        if (this.info.getPrefetchSize() == 0) {
            throw new JMSException("Illegal prefetch size of zero. This setting is not supported for asynchronous consumers please set a value of at least 1");
        }
        if (listener != null) {
            boolean wasRunning = this.session.isRunning();
            if (wasRunning) {
                this.session.stop();
            }
            this.messageListener.set(listener);
            this.session.redispatch(this, this.unconsumedMessages);
            if (wasRunning) {
                this.session.start();
            }
        } else {
            this.messageListener.set(null);
        }
    }

    public MessageAvailableListener getAvailableListener() {
        return this.availableListener;
    }

    public void setAvailableListener(MessageAvailableListener availableListener) {
        this.availableListener = availableListener;
    }

    private MessageDispatch dequeue(long timeout) throws JMSException {
        try {
            MessageDispatch md;
            long deadline = 0L;
            if (timeout > 0L) {
                deadline = System.currentTimeMillis() + timeout;
            }
            while (true) {
                if ((md = this.unconsumedMessages.dequeue(timeout)) == null) {
                    if (timeout > 0L && !this.unconsumedMessages.isClosed()) {
                        timeout = Math.max(deadline - System.currentTimeMillis(), 0L);
                        continue;
                    }
                    return null;
                }
                if (md.getMessage() == null) {
                    return null;
                }
                if (!md.getMessage().isExpired()) break;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.getConsumerId() + " received expired message: " + md);
                }
                this.beforeMessageIsConsumed(md);
                this.afterMessageIsConsumed(md, true);
                if (timeout <= 0L) continue;
                timeout = Math.max(deadline - System.currentTimeMillis(), 0L);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getConsumerId() + " received message: " + md);
            }
            return md;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JMSExceptionSupport.create(e);
        }
    }

    public Message receive() throws JMSException {
        this.checkClosed();
        this.checkMessageListener();
        this.sendPullCommand(0L);
        MessageDispatch md = this.dequeue(-1L);
        if (md == null) {
            return null;
        }
        this.beforeMessageIsConsumed(md);
        this.afterMessageIsConsumed(md, false);
        return this.createActiveMQMessage(md);
    }

    private ActiveMQMessage createActiveMQMessage(MessageDispatch md) throws JMSException {
        Message transformedMessage;
        ActiveMQMessage m = (ActiveMQMessage)md.getMessage().copy();
        if (this.transformer != null && (transformedMessage = this.transformer.consumerTransform(this.session, this, m)) != null) {
            m = ActiveMQMessageTransformation.transformMessage(transformedMessage, this.session.connection);
        }
        if (this.session.isClientAcknowledge()) {
            m.setAcknowledgeCallback(new Callback(){

                public void execute() throws Exception {
                    ActiveMQMessageConsumer.this.session.checkClosed();
                    ActiveMQMessageConsumer.this.session.acknowledge();
                }
            });
        }
        return m;
    }

    public Message receive(long timeout) throws JMSException {
        this.checkClosed();
        this.checkMessageListener();
        if (timeout == 0L) {
            return this.receive();
        }
        this.sendPullCommand(timeout);
        if (timeout > 0L) {
            MessageDispatch md = this.info.getPrefetchSize() == 0 ? this.dequeue(-1L) : this.dequeue(timeout);
            if (md == null) {
                return null;
            }
            this.beforeMessageIsConsumed(md);
            this.afterMessageIsConsumed(md, false);
            return this.createActiveMQMessage(md);
        }
        return null;
    }

    public Message receiveNoWait() throws JMSException {
        this.checkClosed();
        this.checkMessageListener();
        this.sendPullCommand(-1L);
        MessageDispatch md = this.info.getPrefetchSize() == 0 ? this.dequeue(-1L) : this.dequeue(0L);
        if (md == null) {
            return null;
        }
        this.beforeMessageIsConsumed(md);
        this.afterMessageIsConsumed(md, false);
        return this.createActiveMQMessage(md);
    }

    public void close() throws JMSException {
        if (!this.unconsumedMessages.isClosed()) {
            this.dispose();
            this.session.asyncSendPacket(this.info.createRemoveCommand());
        }
    }

    void clearMessagesInProgress() {
        this.clearDispatchList = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliverAcks() {
        MessageAck ack = null;
        if (this.deliveryingAcknowledgements.compareAndSet(false, true)) {
            if (this.optimizeAcknowledge) {
                LinkedList<MessageDispatch> linkedList = this.deliveredMessages;
                synchronized (linkedList) {
                    if (!this.deliveredMessages.isEmpty()) {
                        MessageDispatch md = this.deliveredMessages.getFirst();
                        ack = new MessageAck(md, 2, this.deliveredMessages.size());
                        this.deliveredMessages.clear();
                        this.ackCounter = 0;
                    }
                }
            }
            if (ack != null) {
                final MessageAck ackToSend = ack;
                if (this.executorService == null) {
                    this.executorService = Executors.newSingleThreadExecutor();
                }
                this.executorService.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            ActiveMQMessageConsumer.this.session.asyncSendPacket(ackToSend);
                        }
                        catch (JMSException e) {
                            LOG.error(ActiveMQMessageConsumer.this.getConsumerId() + " failed to delivered acknowledgements", e);
                        }
                        finally {
                            ActiveMQMessageConsumer.this.deliveryingAcknowledgements.set(false);
                        }
                    }
                });
            } else {
                this.deliveryingAcknowledgements.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws JMSException {
        if (!this.unconsumedMessages.isClosed()) {
            this.deliverAcks();
            if (this.executorService != null) {
                this.executorService.shutdown();
                try {
                    this.executorService.awaitTermination(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.session.isTransacted() || this.session.isDupsOkAcknowledge()) {
                this.acknowledge();
            }
            if (this.session.isClientAcknowledge() && !this.info.isBrowser()) {
                for (MessageDispatch old : this.deliveredMessages) {
                    this.session.connection.rollbackDuplicate(this, old.getMessage());
                }
            }
            LinkedList<MessageDispatch> i$ = this.deliveredMessages;
            synchronized (i$) {
                this.deliveredMessages.clear();
            }
            List<MessageDispatch> list = this.unconsumedMessages.removeAll();
            if (!this.info.isBrowser()) {
                for (MessageDispatch old : list) {
                    this.session.connection.rollbackDuplicate(this, old.getMessage());
                }
            }
            this.unconsumedMessages.close();
            this.session.removeConsumer(this);
        }
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.unconsumedMessages.isClosed()) {
            throw new IllegalStateException("The Consumer is closed");
        }
    }

    protected void sendPullCommand(long timeout) throws JMSException {
        if (this.info.getPrefetchSize() == 0 && this.unconsumedMessages.isEmpty()) {
            MessagePull messagePull = new MessagePull();
            messagePull.configure(this.info);
            messagePull.setTimeout(timeout);
            this.session.asyncSendPacket(messagePull);
        }
    }

    protected void checkMessageListener() throws JMSException {
        this.session.checkMessageListener();
    }

    protected void setOptimizeAcknowledge(boolean value) {
        if (this.optimizeAcknowledge && !value) {
            this.deliverAcks();
        }
        this.optimizeAcknowledge = value;
    }

    protected void setPrefetchSize(int prefetch) {
        this.deliverAcks();
        this.info.setCurrentPrefetchSize(prefetch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeMessageIsConsumed(MessageDispatch md) throws JMSException {
        md.setDeliverySequenceId(this.session.getNextDeliveryId());
        if (!this.session.isDupsOkAcknowledge()) {
            LinkedList<MessageDispatch> linkedList = this.deliveredMessages;
            synchronized (linkedList) {
                this.deliveredMessages.addFirst(md);
            }
            if (this.session.isTransacted()) {
                this.ackLater(md, (byte)0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterMessageIsConsumed(MessageDispatch md, boolean messageExpired) throws JMSException {
        if (this.unconsumedMessages.isClosed()) {
            return;
        }
        if (messageExpired) {
            this.ackLater(md, (byte)0);
        } else {
            this.stats.onMessage();
            if (!this.session.isTransacted()) {
                if (this.session.isAutoAcknowledge()) {
                    LinkedList<MessageDispatch> linkedList = this.deliveredMessages;
                    synchronized (linkedList) {
                        if (!this.deliveredMessages.isEmpty()) {
                            if (this.optimizeAcknowledge) {
                                if (this.deliveryingAcknowledgements.compareAndSet(false, true)) {
                                    ++this.ackCounter;
                                    if ((double)this.ackCounter >= (double)this.info.getCurrentPrefetchSize() * 0.65) {
                                        MessageAck ack = new MessageAck(md, 2, this.deliveredMessages.size());
                                        this.session.asyncSendPacket(ack);
                                        this.ackCounter = 0;
                                        this.deliveredMessages.clear();
                                    }
                                    this.deliveryingAcknowledgements.set(false);
                                }
                            } else {
                                MessageAck ack = new MessageAck(md, 2, this.deliveredMessages.size());
                                this.session.asyncSendPacket(ack);
                                this.deliveredMessages.clear();
                            }
                        }
                    }
                } else if (this.session.isDupsOkAcknowledge()) {
                    this.ackLater(md, (byte)2);
                } else if (this.session.isClientAcknowledge()) {
                    this.ackLater(md, (byte)0);
                } else {
                    throw new IllegalStateException("Invalid session state.");
                }
            }
        }
    }

    private void ackLater(MessageDispatch md, byte ackType) throws JMSException {
        if (this.session.isTransacted()) {
            this.session.doStartTransaction();
            if (!this.synchronizationRegistered) {
                this.synchronizationRegistered = true;
                this.session.getTransactionContext().addSynchronization(new Synchronization(){

                    public void beforeEnd() throws Exception {
                        ActiveMQMessageConsumer.this.acknowledge();
                        ActiveMQMessageConsumer.this.synchronizationRegistered = false;
                    }

                    public void afterCommit() throws Exception {
                        ActiveMQMessageConsumer.this.commit();
                        ActiveMQMessageConsumer.this.synchronizationRegistered = false;
                    }

                    public void afterRollback() throws Exception {
                        ActiveMQMessageConsumer.this.rollback();
                        ActiveMQMessageConsumer.this.synchronizationRegistered = false;
                    }
                });
            }
        }
        ++this.deliveredCounter;
        if (0.5 * (double)this.info.getPrefetchSize() <= (double)(this.deliveredCounter - this.additionalWindowSize)) {
            MessageAck ack = new MessageAck(md, ackType, this.deliveredCounter);
            ack.setTransactionId(this.session.getTransactionContext().getTransactionId());
            this.session.asyncSendPacket(ack);
            this.additionalWindowSize = this.deliveredCounter;
            if (ackType == 2) {
                this.deliveredCounter = 0;
                this.additionalWindowSize = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge() throws JMSException {
        LinkedList<MessageDispatch> linkedList = this.deliveredMessages;
        synchronized (linkedList) {
            if (this.deliveredMessages.isEmpty()) {
                return;
            }
            MessageDispatch lastMd = this.deliveredMessages.get(0);
            MessageAck ack = new MessageAck(lastMd, 2, this.deliveredMessages.size());
            if (this.session.isTransacted()) {
                this.session.doStartTransaction();
                ack.setTransactionId(this.session.getTransactionContext().getTransactionId());
            }
            this.session.asyncSendPacket(ack);
            this.deliveredCounter -= this.deliveredMessages.size();
            this.additionalWindowSize = Math.max(0, this.additionalWindowSize - this.deliveredMessages.size());
            if (!this.session.isTransacted()) {
                this.deliveredMessages.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws JMSException {
        LinkedList<MessageDispatch> linkedList = this.deliveredMessages;
        synchronized (linkedList) {
            this.deliveredMessages.clear();
        }
        this.redeliveryDelay = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        Object object = this.unconsumedMessages.getMutex();
        synchronized (object) {
            LinkedList<MessageDispatch> linkedList;
            if (this.optimizeAcknowledge && !this.info.isBrowser()) {
                linkedList = this.deliveredMessages;
                synchronized (linkedList) {
                    for (int i = 0; i < this.deliveredMessages.size() && i < this.ackCounter; ++i) {
                        MessageDispatch md = this.deliveredMessages.removeLast();
                        this.session.connection.rollbackDuplicate(this, md.getMessage());
                    }
                }
            }
            linkedList = this.deliveredMessages;
            synchronized (linkedList) {
                MessageAck ack;
                if (this.deliveredMessages.isEmpty()) {
                    return;
                }
                MessageDispatch lastMd = this.deliveredMessages.getFirst();
                if (lastMd.getMessage().getRedeliveryCounter() > 0) {
                    this.redeliveryDelay = this.redeliveryPolicy.getRedeliveryDelay(this.redeliveryDelay);
                }
                for (MessageDispatch md : this.deliveredMessages) {
                    md.getMessage().onMessageRolledBack();
                }
                if (this.redeliveryPolicy.getMaximumRedeliveries() != -1 && lastMd.getMessage().getRedeliveryCounter() > this.redeliveryPolicy.getMaximumRedeliveries()) {
                    ack = new MessageAck(lastMd, 1, this.deliveredMessages.size());
                    this.session.asyncSendPacket(ack);
                    this.session.connection.rollbackDuplicate(this, lastMd.getMessage());
                    this.additionalWindowSize = Math.max(0, this.additionalWindowSize - this.deliveredMessages.size());
                    this.redeliveryDelay = 0L;
                } else {
                    ack = new MessageAck(lastMd, 3, this.deliveredMessages.size());
                    this.session.asyncSendPacket(ack);
                    this.unconsumedMessages.stop();
                    for (MessageDispatch md : this.deliveredMessages) {
                        this.unconsumedMessages.enqueueFirst(md);
                    }
                    if (this.redeliveryDelay > 0L) {
                        Scheduler.executeAfterDelay(new Runnable(){

                            public void run() {
                                try {
                                    if (ActiveMQMessageConsumer.this.started.get()) {
                                        ActiveMQMessageConsumer.this.start();
                                    }
                                }
                                catch (JMSException e) {
                                    ActiveMQMessageConsumer.this.session.connection.onAsyncException(e);
                                }
                            }
                        }, this.redeliveryDelay);
                    } else {
                        this.start();
                    }
                }
                this.deliveredCounter -= this.deliveredMessages.size();
                this.deliveredMessages.clear();
            }
        }
        if (this.messageListener.get() != null) {
            this.session.redispatch(this, this.unconsumedMessages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(MessageDispatch md) {
        MessageListener listener = this.messageListener.get();
        try {
            Object object = this.unconsumedMessages.getMutex();
            synchronized (object) {
                if (this.clearDispatchList) {
                    this.clearDispatchList = false;
                    List<MessageDispatch> list = this.unconsumedMessages.removeAll();
                    if (!this.info.isBrowser()) {
                        for (MessageDispatch old : list) {
                            this.session.connection.rollbackDuplicate(this, old.getMessage());
                        }
                    }
                }
                if (!this.unconsumedMessages.isClosed()) {
                    if (this.info.isBrowser() || !this.session.connection.isDuplicate(this, md.getMessage())) {
                        if (listener != null && this.unconsumedMessages.isRunning()) {
                            ActiveMQMessage message = this.createActiveMQMessage(md);
                            this.beforeMessageIsConsumed(md);
                            try {
                                boolean expired = message.isExpired();
                                if (!expired) {
                                    listener.onMessage(message);
                                }
                                this.afterMessageIsConsumed(md, expired);
                            }
                            catch (RuntimeException e) {
                                if (!this.session.isDupsOkAcknowledge() && !this.session.isAutoAcknowledge()) {
                                    this.afterMessageIsConsumed(md, false);
                                }
                                LOG.error(this.getConsumerId() + " Exception while processing message: " + e, e);
                            }
                        } else {
                            this.unconsumedMessages.enqueue(md);
                            if (this.availableListener != null) {
                                this.availableListener.onMessageAvailable(this);
                            }
                        }
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(this.getConsumerId() + " Ignoring Duplicate: " + md.getMessage());
                        }
                        this.ackLater(md, (byte)2);
                    }
                }
            }
            if (++this.dispatchedCount % 1000 == 0) {
                this.dispatchedCount = 0;
                Thread.yield();
            }
        }
        catch (Exception e) {
            this.session.connection.onAsyncException(e);
        }
    }

    public int getMessageSize() {
        return this.unconsumedMessages.size();
    }

    public void start() throws JMSException {
        if (this.unconsumedMessages.isClosed()) {
            return;
        }
        this.started.set(true);
        this.unconsumedMessages.start();
        this.session.executor.wakeup();
    }

    public void stop() {
        this.started.set(false);
        this.unconsumedMessages.stop();
    }

    public String toString() {
        return "ActiveMQMessageConsumer { value=" + this.info.getConsumerId() + ", started=" + this.started.get() + " }";
    }

    public boolean iterate() {
        MessageDispatch md;
        MessageListener listener = this.messageListener.get();
        if (listener != null && (md = this.unconsumedMessages.dequeueNoWait()) != null) {
            try {
                ActiveMQMessage message = this.createActiveMQMessage(md);
                this.beforeMessageIsConsumed(md);
                listener.onMessage(message);
                this.afterMessageIsConsumed(md, false);
            }
            catch (JMSException e) {
                this.session.connection.onAsyncException(e);
            }
            return true;
        }
        return false;
    }

    public boolean isInUse(ActiveMQTempDestination destination) {
        return this.info.getDestination().equals(destination);
    }
}

