/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.script;

import java.io.File;
import java.util.List;
import org.fest.swing.script.ScriptApprover;
import org.fest.util.Arrays;
import org.fest.util.Collections;

public final class FileNameMatchScriptApprover
implements ScriptApprover {
    private final List<String> fileNamesToMatch;

    public FileNameMatchScriptApprover(String ... fileNamesToMatch) {
        if (Arrays.isEmpty((Object[])fileNamesToMatch)) {
            throw new IllegalArgumentException("There should be at least one file name to match");
        }
        this.fileNamesToMatch = Collections.list((Object[])fileNamesToMatch);
    }

    public boolean approve(File toApprove) {
        if (toApprove == null) {
            return false;
        }
        return this.fileNamesToMatch.contains(toApprove.getName());
    }
}

