/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import abbot.tester.ComponentTester;
import java.awt.Component;
import org.fest.assertions.Assertions;
import org.fest.swing.RobotFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComponentFixture<T extends Component> {
    public final RobotFixture robot;
    public final T target;

    public ComponentFixture(RobotFixture robot, Class<? extends T> type) {
        this(robot, robot.finder().findByType(type));
    }

    public ComponentFixture(RobotFixture robot, String name, Class<? extends T> type) {
        this(robot, robot.finder().findByName(name, type));
    }

    public ComponentFixture(RobotFixture robot, T target) {
        this.robot = robot;
        this.target = target;
    }

    public final <C extends T> C targetCastedTo(Class<C> type) {
        Assertions.assertThat(this.target).isInstanceOf(type);
        return (C)((Component)type.cast(this.target));
    }

    public ComponentFixture<T> click() {
        this.focus();
        this.tester().actionClick(this.target);
        return this;
    }

    public ComponentFixture<T> focus() {
        this.robot.focus((Component)this.target);
        return this;
    }

    protected final <C extends ComponentTester> C testerCastedTo(Class<C> type) {
        ComponentTester tester = this.tester();
        Assertions.assertThat((Object)tester).isInstanceOf(type);
        return (C)((ComponentTester)type.cast(tester));
    }

    protected final void doPressKeys(int ... keyCodes) {
        this.focus();
        ComponentTester tester = this.tester();
        for (int keyCode : keyCodes) {
            tester.actionKeyPress(keyCode);
        }
    }

    public ComponentFixture<T> requireVisible() {
        Assertions.assertThat((boolean)((Component)this.target).isVisible()).isTrue();
        return this;
    }

    public ComponentFixture<T> requireNotVisible() {
        Assertions.assertThat((boolean)((Component)this.target).isVisible()).isFalse();
        return this;
    }

    public ComponentFixture<T> requireEnabled() {
        Assertions.assertThat((boolean)((Component)this.target).isEnabled()).isTrue();
        return this;
    }

    public ComponentFixture<T> requireDisabled() {
        Assertions.assertThat((boolean)((Component)this.target).isEnabled()).isFalse();
        return this;
    }

    protected final ComponentTester tester() {
        return ComponentTester.getTester(this.target);
    }
}

