/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing;

import org.fest.swing.ScreenLockException;
import org.fest.util.Strings;

public final class ScreenLock {
    private boolean locked;
    private Object owner;

    public synchronized void acquire(Object owner) {
        while (this.locked) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                break;
            }
            this.acquire(owner);
            this.notifyAll();
        }
        this.locked = true;
        this.owner = owner;
    }

    public synchronized void release(Object owner) {
        if (!this.locked) {
            throw new ScreenLockException("No lock to release");
        }
        if (this.owner != owner) {
            throw new ScreenLockException(Strings.concat((Object[])new Object[]{owner, " is not the lock owner"}));
        }
        this.locked = false;
        this.owner = null;
    }

    public static ScreenLock instance() {
        return ScreenLockHolder.instance;
    }

    private ScreenLock() {
    }

    private static class ScreenLockHolder {
        static ScreenLock instance = new ScreenLock();

        private ScreenLockHolder() {
        }
    }
}

