/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.apache.activemq.usage.SystemUsage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class AMQDeadlockTestW4Brokers
extends TestCase {
    private static final transient Log LOG = LogFactory.getLog(AMQDeadlockTestW4Brokers.class);
    private static final String BROKER_URL1 = "tcp://localhost:61616";
    private static final String BROKER_URL2 = "tcp://localhost:61617";
    private static final String BROKER_URL3 = "tcp://localhost:61618";
    private static final String BROKER_URL4 = "tcp://localhost:61619";
    private static final String URL1 = "tcp://localhost:61616?wireFormat.cacheEnabled=false&wireFormat.tightEncodingEnabled=false&wireFormat.maxInactivityDuration=30000&wireFormat.tcpNoDelayEnabled=false";
    private static final String URL2 = "tcp://localhost:61617?wireFormat.cacheEnabled=false&wireFormat.tightEncodingEnabled=false&wireFormat.maxInactivityDuration=30000&wireFormat.tcpNoDelayEnabled=false";
    private static final String URL3 = "tcp://localhost:61618?wireFormat.cacheEnabled=false&wireFormat.tightEncodingEnabled=false&wireFormat.maxInactivityDuration=30000&wireFormat.tcpNoDelayEnabled=false";
    private static final String URL4 = "tcp://localhost:61619?wireFormat.cacheEnabled=false&wireFormat.tightEncodingEnabled=false&wireFormat.maxInactivityDuration=30000&wireFormat.tcpNoDelayEnabled=false";
    private static final String QUEUE1_NAME = "test.queue.1";
    private static final int MAX_CONSUMERS = 5;
    private static final int NUM_MESSAGE_TO_SEND = 10000;
    private static final CountDownLatch LATCH = new CountDownLatch(50000);

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test4BrokerWithOutLingo() throws Exception {
        BrokerService brokerService1 = null;
        BrokerService brokerService2 = null;
        BrokerService brokerService3 = null;
        BrokerService brokerService4 = null;
        ActiveMQConnectionFactory acf1 = null;
        ActiveMQConnectionFactory acf2 = null;
        PooledConnectionFactory pcf1 = null;
        PooledConnectionFactory pcf2 = null;
        ActiveMQConnectionFactory acf3 = null;
        ActiveMQConnectionFactory acf4 = null;
        PooledConnectionFactory pcf3 = null;
        PooledConnectionFactory pcf4 = null;
        DefaultMessageListenerContainer container1 = null;
        try {
            brokerService1 = this.createBrokerService("broker1", BROKER_URL1, BROKER_URL2, BROKER_URL3, BROKER_URL4, 0);
            brokerService1.start();
            brokerService2 = this.createBrokerService("broker2", BROKER_URL2, BROKER_URL1, BROKER_URL3, BROKER_URL4, 0);
            brokerService2.start();
            brokerService3 = this.createBrokerService("broker3", BROKER_URL3, BROKER_URL2, BROKER_URL1, BROKER_URL4, 0);
            brokerService3.start();
            brokerService4 = this.createBrokerService("broker4", BROKER_URL4, BROKER_URL1, BROKER_URL3, BROKER_URL2, 0);
            brokerService4.start();
            String failover1 = "failover:(tcp://localhost:61616?wireFormat.cacheEnabled=false&wireFormat.tightEncodingEnabled=false&wireFormat.maxInactivityDuration=30000&wireFormat.tcpNoDelayEnabled=false)?initialReconnectDelay=10&maxReconnectDelay=30000&useExponentialBackOff=true&backOffMultiplier=2&maxReconnectAttempts=0&randomize=false";
            String failover2 = "failover:(tcp://localhost:61617?wireFormat.cacheEnabled=false&wireFormat.tightEncodingEnabled=false&wireFormat.maxInactivityDuration=30000&wireFormat.tcpNoDelayEnabled=false)?initialReconnectDelay=10&maxReconnectDelay=30000&useExponentialBackOff=true&backOffMultiplier=2&maxReconnectAttempts=0&randomize=false";
            String failover3 = "failover:(tcp://localhost:61618?wireFormat.cacheEnabled=false&wireFormat.tightEncodingEnabled=false&wireFormat.maxInactivityDuration=30000&wireFormat.tcpNoDelayEnabled=false)?initialReconnectDelay=10&maxReconnectDelay=30000&useExponentialBackOff=true&backOffMultiplier=2&maxReconnectAttempts=0&randomize=false";
            String failover4 = "failover:(tcp://localhost:61619?wireFormat.cacheEnabled=false&wireFormat.tightEncodingEnabled=false&wireFormat.maxInactivityDuration=30000&wireFormat.tcpNoDelayEnabled=false)?initialReconnectDelay=10&maxReconnectDelay=30000&useExponentialBackOff=true&backOffMultiplier=2&maxReconnectAttempts=0&randomize=false";
            acf1 = this.createConnectionFactory("failover:(tcp://localhost:61616?wireFormat.cacheEnabled=false&wireFormat.tightEncodingEnabled=false&wireFormat.maxInactivityDuration=30000&wireFormat.tcpNoDelayEnabled=false)?initialReconnectDelay=10&maxReconnectDelay=30000&useExponentialBackOff=true&backOffMultiplier=2&maxReconnectAttempts=0&randomize=false");
            acf2 = this.createConnectionFactory("failover:(tcp://localhost:61617?wireFormat.cacheEnabled=false&wireFormat.tightEncodingEnabled=false&wireFormat.maxInactivityDuration=30000&wireFormat.tcpNoDelayEnabled=false)?initialReconnectDelay=10&maxReconnectDelay=30000&useExponentialBackOff=true&backOffMultiplier=2&maxReconnectAttempts=0&randomize=false");
            acf3 = this.createConnectionFactory("failover:(tcp://localhost:61618?wireFormat.cacheEnabled=false&wireFormat.tightEncodingEnabled=false&wireFormat.maxInactivityDuration=30000&wireFormat.tcpNoDelayEnabled=false)?initialReconnectDelay=10&maxReconnectDelay=30000&useExponentialBackOff=true&backOffMultiplier=2&maxReconnectAttempts=0&randomize=false");
            acf4 = this.createConnectionFactory("failover:(tcp://localhost:61619?wireFormat.cacheEnabled=false&wireFormat.tightEncodingEnabled=false&wireFormat.maxInactivityDuration=30000&wireFormat.tcpNoDelayEnabled=false)?initialReconnectDelay=10&maxReconnectDelay=30000&useExponentialBackOff=true&backOffMultiplier=2&maxReconnectAttempts=0&randomize=false");
            pcf1 = new PooledConnectionFactory(acf1);
            pcf2 = new PooledConnectionFactory(acf2);
            pcf3 = new PooledConnectionFactory(acf3);
            pcf4 = new PooledConnectionFactory(acf4);
            container1 = this.createDefaultMessageListenerContainer((ConnectionFactory)acf2, new TestMessageListener1(0L), QUEUE1_NAME);
            container1.afterPropertiesSet();
            PooledProducerTask[] task = new PooledProducerTask[]{new PooledProducerTask(pcf1, QUEUE1_NAME, "producer1"), new PooledProducerTask(pcf2, QUEUE1_NAME, "producer2"), new PooledProducerTask(pcf3, QUEUE1_NAME, "producer3"), new PooledProducerTask(pcf4, QUEUE1_NAME, "producer4")};
            ExecutorService executor = Executors.newCachedThreadPool();
            for (int i = 0; i < 4; ++i) {
                executor.submit(task[i]);
            }
            LATCH.await(15L, TimeUnit.SECONDS);
            AMQDeadlockTestW4Brokers.assertTrue((LATCH.getCount() == 50000L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            container1.stop();
            container1.destroy();
            container1 = null;
            brokerService1.stop();
            brokerService1 = null;
            brokerService2.stop();
            brokerService2 = null;
            brokerService3.stop();
            brokerService3 = null;
            brokerService4.stop();
            brokerService4 = null;
        }
    }

    private BrokerService createBrokerService(String brokerName, String uri1, String uri2, String uri3, String uri4, int queueLimit) throws Exception {
        BrokerService brokerService = new BrokerService();
        brokerService.setBrokerName(brokerName);
        brokerService.setPersistent(false);
        brokerService.setUseJmx(true);
        SystemUsage memoryManager = new SystemUsage();
        memoryManager.getMemoryUsage().setLimit(100000000L);
        brokerService.setSystemUsage(memoryManager);
        ArrayList<PolicyEntry> policyEntries = new ArrayList<PolicyEntry>();
        PolicyEntry entry = new PolicyEntry();
        entry.setQueue(">");
        entry.setMemoryLimit((long)queueLimit);
        policyEntries.add(entry);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setPolicyEntries(policyEntries);
        brokerService.setDestinationPolicy(policyMap);
        TransportConnector tConnector = new TransportConnector();
        tConnector.setUri(new URI(uri1));
        tConnector.setName(brokerName + ".transportConnector");
        brokerService.addConnector(tConnector);
        if (uri2 != null) {
            DiscoveryNetworkConnector nc = new DiscoveryNetworkConnector(new URI("static:" + uri2 + "," + uri3 + "," + uri4));
            nc.setBridgeTempDestinations(true);
            nc.setBrokerName(brokerName);
            nc.setPrefetchSize(1000);
            nc.setNetworkTTL(1);
            brokerService.addNetworkConnector((NetworkConnector)nc);
        }
        return brokerService;
    }

    public DefaultMessageListenerContainer createDefaultMessageListenerContainer(ConnectionFactory acf, MessageListener listener, String queue) {
        DefaultMessageListenerContainer container = new DefaultMessageListenerContainer();
        container.setConnectionFactory(acf);
        container.setDestinationName(queue);
        container.setMessageListener((Object)listener);
        container.setSessionTransacted(false);
        container.setSessionAcknowledgeMode(1);
        container.setConcurrentConsumers(5);
        return container;
    }

    public ActiveMQConnectionFactory createConnectionFactory(String url) {
        ActiveMQConnectionFactory acf = new ActiveMQConnectionFactory(url);
        acf.setCopyMessageOnSend(false);
        acf.setUseAsyncSend(false);
        acf.setDispatchAsync(true);
        acf.setUseCompression(false);
        acf.setOptimizeAcknowledge(false);
        acf.setOptimizedMessageDispatch(true);
        acf.setUseAsyncSend(false);
        return acf;
    }

    private class PooledProducerTask
    implements Runnable {
        private final String queueName;
        private final PooledConnectionFactory pcf;
        private final String producerName;

        public PooledProducerTask(PooledConnectionFactory pcf, String queueName, String producerName) {
            this.pcf = pcf;
            this.queueName = queueName;
            this.producerName = producerName;
        }

        public void run() {
            try {
                JmsTemplate jmsTemplate = new JmsTemplate((ConnectionFactory)this.pcf);
                jmsTemplate.setDeliveryMode(1);
                jmsTemplate.setExplicitQosEnabled(true);
                jmsTemplate.setMessageIdEnabled(false);
                jmsTemplate.setMessageTimestampEnabled(false);
                jmsTemplate.afterPropertiesSet();
                final byte[] bytes = new byte[2048];
                Random r = new Random();
                r.nextBytes(bytes);
                int i = 0;
                while (i < 10000) {
                    final int count = i++;
                    jmsTemplate.send(this.queueName, new MessageCreator(){

                        public Message createMessage(Session session) throws JMSException {
                            BytesMessage message = session.createBytesMessage();
                            message.writeBytes(bytes);
                            message.setIntProperty("count", count);
                            message.setStringProperty("producerName", PooledProducerTask.this.producerName);
                            return message;
                        }
                    });
                }
            }
            catch (Throwable e) {
                LOG.error((Object)"Producer 1 is exiting", e);
            }
        }
    }

    private static class TestMessageListener1
    implements MessageListener {
        final AtomicInteger count = new AtomicInteger(0);
        private final long waitTime;

        public TestMessageListener1(long waitTime) {
            this.waitTime = waitTime;
        }

        public void onMessage(Message msg) {
            try {
                int value = this.count.incrementAndGet();
                if (value % 1000 == 0) {
                    LOG.info((Object)("Consumed message: " + value));
                }
                Thread.sleep(this.waitTime);
                LATCH.countDown();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

