/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.thread;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TaskRunnerTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TaskRunnerTest.class);

    public void testWakeupPooled() throws InterruptedException, BrokenBarrierException {
        System.setProperty("org.apache.activemq.UseDedicatedTaskRunner", "false");
        this.doTestWakeup();
    }

    public void testWakeupDedicated() throws InterruptedException, BrokenBarrierException {
        System.setProperty("org.apache.activemq.UseDedicatedTaskRunner", "true");
        this.doTestWakeup();
    }

    public void doTestWakeup() throws InterruptedException, BrokenBarrierException {
        int enqueueCount = 100000;
        final AtomicInteger iterations = new AtomicInteger(0);
        final AtomicInteger counter = new AtomicInteger(0);
        final AtomicInteger queue = new AtomicInteger(0);
        final CountDownLatch doneCountDownLatch = new CountDownLatch(1);
        TaskRunnerFactory factory = new TaskRunnerFactory();
        final TaskRunner runner = factory.createTaskRunner(new Task(){

            public boolean iterate() {
                if (queue.get() == 0) {
                    return false;
                }
                while (queue.get() > 0) {
                    queue.decrementAndGet();
                    counter.incrementAndGet();
                }
                iterations.incrementAndGet();
                if (counter.get() == 100000) {
                    doneCountDownLatch.countDown();
                }
                return true;
            }
        }, "Thread Name");
        long start = System.currentTimeMillis();
        int workerCount = 5;
        final CyclicBarrier barrier = new CyclicBarrier(6);
        for (int i = 0; i < 5; ++i) {
            new Thread(){

                public void run() {
                    try {
                        barrier.await();
                        for (int i = 0; i < 20000; ++i) {
                            queue.incrementAndGet();
                            runner.wakeup();
                            2.yield();
                        }
                    }
                    catch (BrokenBarrierException e) {
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }.start();
        }
        barrier.await();
        boolean b = doneCountDownLatch.await(30L, TimeUnit.SECONDS);
        long end = System.currentTimeMillis();
        LOG.info((Object)("Iterations: " + iterations.get()));
        LOG.info((Object)("counter: " + counter.get()));
        LOG.info((Object)("Dequeues/s: " + 1.0E8 / (double)(end - start)));
        LOG.info((Object)("duration: " + (double)(end - start) / 1000.0));
        TaskRunnerTest.assertTrue((boolean)b);
        runner.shutdown();
    }

    public static void main(String[] args) {
        TestRunner.run(TaskRunnerTest.class);
    }
}

