/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;

public class SecurityTestSupport
extends JmsTestSupport {
    public ActiveMQDestination destination;

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        broker.setPopulateJMSXUserID(true);
        return broker;
    }

    public void testUserReceiveFails() throws JMSException {
        this.doReceive(true);
    }

    public void testInvalidAuthentication() throws JMSException {
        Connection c;
        try {
            c = this.factory.createConnection();
            this.connections.add(c);
            c.start();
            SecurityTestSupport.fail((String)"Expected exception.");
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            c = this.factory.createConnection("user", "krap");
            this.connections.add(c);
            c.start();
            SecurityTestSupport.fail((String)"Expected exception.");
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            c = this.factory.createConnection("userkrap", null);
            this.connections.add(c);
            c.start();
            SecurityTestSupport.fail((String)"Expected exception.");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void testUserReceiveSucceeds() throws JMSException {
        Message m = this.doReceive(false);
        SecurityTestSupport.assertEquals((String)"system", (String)((ActiveMQMessage)m).getUserID());
        SecurityTestSupport.assertEquals((String)"system", (String)m.getStringProperty("JMSXUserID"));
    }

    public void testGuestReceiveSucceeds() throws JMSException {
        this.doReceive(false);
    }

    public void testGuestReceiveFails() throws JMSException {
        this.doReceive(true);
    }

    public void testUserSendSucceeds() throws JMSException {
        Message m = this.doSend(false);
        SecurityTestSupport.assertEquals((String)"user", (String)((ActiveMQMessage)m).getUserID());
        SecurityTestSupport.assertEquals((String)"user", (String)m.getStringProperty("JMSXUserID"));
    }

    public void testUserSendFails() throws JMSException {
        this.doSend(true);
    }

    public void testGuestSendFails() throws JMSException {
        this.doSend(true);
    }

    public void testGuestSendSucceeds() throws JMSException {
        this.doSend(false);
    }

    public Message doSend(boolean fail) throws JMSException {
        MessageConsumer consumer;
        block4: {
            Connection adminConnection = this.factory.createConnection("system", "manager");
            this.connections.add(adminConnection);
            adminConnection.start();
            Session adminSession = adminConnection.createSession(false, 1);
            consumer = adminSession.createConsumer((Destination)this.destination);
            Session session = this.connection.createSession(false, 1);
            try {
                this.sendMessages(session, (Destination)this.destination, 1);
            }
            catch (JMSException e) {
                if (fail && e.getCause() instanceof SecurityException) break block4;
                throw e;
            }
        }
        Message m = consumer.receive(1000L);
        if (fail) {
            SecurityTestSupport.assertNull((Object)m);
        } else {
            SecurityTestSupport.assertNotNull((Object)m);
            SecurityTestSupport.assertEquals((String)"0", (String)((TextMessage)m).getText());
            SecurityTestSupport.assertNull((Object)consumer.receiveNoWait());
        }
        return m;
    }

    public Message doReceive(boolean fail) throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        MessageConsumer consumer = null;
        try {
            consumer = session.createConsumer((Destination)this.destination);
            if (fail) {
                SecurityTestSupport.fail((String)"Expected failure due to security constraint.");
            }
        }
        catch (JMSException e) {
            if (fail && e.getCause() instanceof SecurityException) {
                return null;
            }
            throw e;
        }
        Connection adminConnection = this.factory.createConnection("system", "manager");
        this.connections.add(adminConnection);
        Session adminSession = adminConnection.createSession(false, 1);
        this.sendMessages(adminSession, (Destination)this.destination, 1);
        Message m = consumer.receive(1000L);
        SecurityTestSupport.assertNotNull((Object)m);
        SecurityTestSupport.assertEquals((String)"0", (String)((TextMessage)m).getText());
        SecurityTestSupport.assertNull((Object)consumer.receiveNoWait());
        return m;
    }

    public void initCombosForTestUserReceiveFails() {
        this.addCombinationValues("userName", new Object[]{"user"});
        this.addCombinationValues("password", new Object[]{"password"});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("TEST"), new ActiveMQTopic("TEST"), new ActiveMQQueue("GUEST.BAR"), new ActiveMQTopic("GUEST.BAR")});
    }

    public void initCombosForTestInvalidAuthentication() {
        this.addCombinationValues("userName", new Object[]{"user"});
        this.addCombinationValues("password", new Object[]{"password"});
    }

    public void initCombosForTestUserReceiveSucceeds() {
        this.addCombinationValues("userName", new Object[]{"user"});
        this.addCombinationValues("password", new Object[]{"password"});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("USERS.FOO"), new ActiveMQTopic("USERS.FOO")});
    }

    public void initCombosForTestGuestReceiveSucceeds() {
        this.addCombinationValues("userName", new Object[]{"guest"});
        this.addCombinationValues("password", new Object[]{"password"});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("GUEST.BAR"), new ActiveMQTopic("GUEST.BAR")});
    }

    public void initCombosForTestGuestReceiveFails() {
        this.addCombinationValues("userName", new Object[]{"guest"});
        this.addCombinationValues("password", new Object[]{"password"});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("TEST"), new ActiveMQTopic("TEST"), new ActiveMQQueue("USERS.FOO"), new ActiveMQTopic("USERS.FOO")});
    }

    public void initCombosForTestUserSendSucceeds() {
        this.addCombinationValues("userName", new Object[]{"user"});
        this.addCombinationValues("password", new Object[]{"password"});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("USERS.FOO"), new ActiveMQQueue("GUEST.BAR"), new ActiveMQTopic("USERS.FOO"), new ActiveMQTopic("GUEST.BAR")});
    }

    public void initCombosForTestUserSendFails() {
        this.addCombinationValues("userName", new Object[]{"user"});
        this.addCombinationValues("password", new Object[]{"password"});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("TEST"), new ActiveMQTopic("TEST")});
    }

    public void initCombosForTestGuestSendFails() {
        this.addCombinationValues("userName", new Object[]{"guest"});
        this.addCombinationValues("password", new Object[]{"password"});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("TEST"), new ActiveMQTopic("TEST"), new ActiveMQQueue("USERS.FOO"), new ActiveMQTopic("USERS.FOO")});
    }

    public void initCombosForTestGuestSendSucceeds() {
        this.addCombinationValues("userName", new Object[]{"guest"});
        this.addCombinationValues("password", new Object[]{"password"});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("GUEST.BAR"), new ActiveMQTopic("GUEST.BAR")});
    }
}

