/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.config;

import java.io.File;
import java.util.List;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.FixedSizedSubscriptionRecoveryPolicy;
import org.apache.activemq.broker.region.policy.LastImageSubscriptionRecoveryPolicy;
import org.apache.activemq.broker.region.policy.NoSubscriptionRecoveryPolicy;
import org.apache.activemq.broker.region.policy.RoundRobinDispatchPolicy;
import org.apache.activemq.broker.region.policy.SimpleDispatchPolicy;
import org.apache.activemq.broker.region.policy.StrictOrderDispatchPolicy;
import org.apache.activemq.broker.region.policy.SubscriptionRecoveryPolicy;
import org.apache.activemq.broker.region.policy.TimedSubscriptionRecoveryPolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.journal.JournalPersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.activemq.transport.tcp.TcpTransportServer;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.wireformat.ObjectStreamWireFormat;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class ConfigTest
extends TestCase {
    protected static final String JOURNAL_ROOT = "target/test-data/";
    protected static final String DERBY_ROOT = "target/test-data/";
    protected static final String CONF_ROOT = "src/test/resources/org/apache/activemq/config/sample-conf/";
    private static final Log LOG = LogFactory.getLog(ConfigTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJournaledJDBCConfig() throws Exception {
        File journalFile = new File("target/test-data/testJournaledJDBCConfig/journal");
        ConfigTest.recursiveDelete(journalFile);
        File derbyFile = new File("target/test-data/testJournaledJDBCConfig/derbydb");
        ConfigTest.recursiveDelete(derbyFile);
        BrokerService broker = this.createBroker((Resource)new FileSystemResource("src/test/resources/org/apache/activemq/config/sample-conf/journaledjdbc-example.xml"));
        try {
            ConfigTest.assertEquals((String)"Broker Config Error (brokerName)", (String)"brokerJournaledJDBCConfigTest", (String)broker.getBrokerName());
            PersistenceAdapter adapter = broker.getPersistenceAdapter();
            ConfigTest.assertTrue((String)"Should have created a journal persistence adapter", (boolean)(adapter instanceof JournalPersistenceAdapter));
            ConfigTest.assertTrue((String)("Should have created a derby directory at " + derbyFile.getAbsolutePath()), (boolean)derbyFile.exists());
            ConfigTest.assertTrue((String)("Should have created a journal directory at " + journalFile.getAbsolutePath()), (boolean)journalFile.exists());
            broker.getPersistenceAdapter();
            LOG.info((Object)"Success");
        }
        finally {
            if (broker != null) {
                broker.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJdbcConfig() throws Exception {
        File derbyFile = new File("target/test-data/testJDBCConfig/derbydb");
        ConfigTest.recursiveDelete(derbyFile);
        BrokerService broker = this.createBroker((Resource)new FileSystemResource("src/test/resources/org/apache/activemq/config/sample-conf/jdbc-example.xml"));
        try {
            ConfigTest.assertEquals((String)"Broker Config Error (brokerName)", (String)"brokerJdbcConfigTest", (String)broker.getBrokerName());
            PersistenceAdapter adapter = broker.getPersistenceAdapter();
            ConfigTest.assertTrue((String)"Should have created a jdbc persistence adapter", (boolean)(adapter instanceof JDBCPersistenceAdapter));
            ConfigTest.assertEquals((String)"JDBC Adapter Config Error (cleanupPeriod)", (int)60000, (int)((JDBCPersistenceAdapter)adapter).getCleanupPeriod());
            ConfigTest.assertTrue((String)"Should have created an EmbeddedDataSource", (boolean)(((JDBCPersistenceAdapter)adapter).getDataSource() instanceof EmbeddedDataSource));
            ConfigTest.assertTrue((String)"Should have created a DefaultWireFormat", (boolean)(((JDBCPersistenceAdapter)adapter).getWireFormat() instanceof ObjectStreamWireFormat));
            LOG.info((Object)"Success");
        }
        finally {
            if (broker != null) {
                broker.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBrokerConfig() throws Exception {
        File journalFile = new File("target/test-data/");
        ConfigTest.recursiveDelete(journalFile);
        BrokerService broker = this.createBroker("org/apache/activemq/config/example.xml");
        LOG.info((Object)"Success");
        try {
            ConfigTest.assertEquals((String)"Broker Config Error (brokerName)", (String)"brokerConfigTest", (String)broker.getBrokerName());
            ConfigTest.assertEquals((String)"Broker Config Error (populateJMSXUserID)", (boolean)false, (boolean)broker.isPopulateJMSXUserID());
            ConfigTest.assertEquals((String)"Broker Config Error (useLoggingForShutdownErrors)", (boolean)true, (boolean)broker.isUseLoggingForShutdownErrors());
            ConfigTest.assertEquals((String)"Broker Config Error (useJmx)", (boolean)true, (boolean)broker.isUseJmx());
            ConfigTest.assertEquals((String)"Broker Config Error (persistent)", (boolean)false, (boolean)broker.isPersistent());
            ConfigTest.assertEquals((String)"Broker Config Error (useShutdownHook)", (boolean)false, (boolean)broker.isUseShutdownHook());
            ConfigTest.assertEquals((String)"Broker Config Error (deleteAllMessagesOnStartup)", (boolean)true, (boolean)broker.isDeleteAllMessagesOnStartup());
            LOG.info((Object)"Success");
            ConfigTest.assertEquals((String)"Should have a specific VM Connector", (String)"vm://javacoola", (String)broker.getVmConnectorURI().toString());
            LOG.info((Object)"Success");
            List connectors = broker.getTransportConnectors();
            ConfigTest.assertTrue((String)"Should have created at least 3 connectors", (connectors.size() >= 3 ? 1 : 0) != 0);
            ConfigTest.assertTrue((String)"1st connector should be TcpTransportServer", (boolean)(((TransportConnector)connectors.get(0)).getServer() instanceof TcpTransportServer));
            ConfigTest.assertTrue((String)"2nd connector should be TcpTransportServer", (boolean)(((TransportConnector)connectors.get(1)).getServer() instanceof TcpTransportServer));
            ConfigTest.assertTrue((String)"3rd connector should be TcpTransportServer", (boolean)(((TransportConnector)connectors.get(2)).getServer() instanceof TcpTransportServer));
            List networkConnectors = broker.getNetworkConnectors();
            ConfigTest.assertEquals((String)"Should have a single network connector", (int)1, (int)networkConnectors.size());
            LOG.info((Object)"Success");
            ActiveMQTopic dest = new ActiveMQTopic("Topic.SimpleDispatch");
            ConfigTest.assertTrue((String)("Should have a simple dispatch policy for " + dest.getTopicName()), (boolean)(broker.getDestinationPolicy().getEntryFor((ActiveMQDestination)dest).getDispatchPolicy() instanceof SimpleDispatchPolicy));
            dest = new ActiveMQTopic("Topic.RoundRobinDispatch");
            ConfigTest.assertTrue((String)("Should have a round robin dispatch policy for " + dest.getTopicName()), (boolean)(broker.getDestinationPolicy().getEntryFor((ActiveMQDestination)dest).getDispatchPolicy() instanceof RoundRobinDispatchPolicy));
            dest = new ActiveMQTopic("Topic.StrictOrderDispatch");
            ConfigTest.assertTrue((String)("Should have a strict order dispatch policy for " + dest.getTopicName()), (boolean)(broker.getDestinationPolicy().getEntryFor((ActiveMQDestination)dest).getDispatchPolicy() instanceof StrictOrderDispatchPolicy));
            LOG.info((Object)"Success");
            dest = new ActiveMQTopic("Topic.FixedSizedSubs");
            SubscriptionRecoveryPolicy subsPolicy = broker.getDestinationPolicy().getEntryFor((ActiveMQDestination)dest).getSubscriptionRecoveryPolicy();
            ConfigTest.assertTrue((String)("Should have a fixed sized subscription recovery policy for " + dest.getTopicName()), (boolean)(subsPolicy instanceof FixedSizedSubscriptionRecoveryPolicy));
            ConfigTest.assertEquals((String)"FixedSizedSubsPolicy Config Error (maximumSize)", (int)2000000, (int)((FixedSizedSubscriptionRecoveryPolicy)subsPolicy).getMaximumSize());
            ConfigTest.assertEquals((String)"FixedSizedSubsPolicy Config Error (useSharedBuffer)", (boolean)false, (boolean)((FixedSizedSubscriptionRecoveryPolicy)subsPolicy).isUseSharedBuffer());
            dest = new ActiveMQTopic("Topic.LastImageSubs");
            subsPolicy = broker.getDestinationPolicy().getEntryFor((ActiveMQDestination)dest).getSubscriptionRecoveryPolicy();
            ConfigTest.assertTrue((String)("Should have a last image subscription recovery policy for " + dest.getTopicName()), (boolean)(subsPolicy instanceof LastImageSubscriptionRecoveryPolicy));
            dest = new ActiveMQTopic("Topic.NoSubs");
            subsPolicy = broker.getDestinationPolicy().getEntryFor((ActiveMQDestination)dest).getSubscriptionRecoveryPolicy();
            ConfigTest.assertTrue((String)("Should have no subscription recovery policy for " + dest.getTopicName()), (boolean)(subsPolicy instanceof NoSubscriptionRecoveryPolicy));
            dest = new ActiveMQTopic("Topic.TimedSubs");
            subsPolicy = broker.getDestinationPolicy().getEntryFor((ActiveMQDestination)dest).getSubscriptionRecoveryPolicy();
            ConfigTest.assertTrue((String)("Should have a timed subscription recovery policy for " + dest.getTopicName()), (boolean)(subsPolicy instanceof TimedSubscriptionRecoveryPolicy));
            ConfigTest.assertEquals((String)"TimedSubsPolicy Config Error (recoverDuration)", (long)25000L, (long)((TimedSubscriptionRecoveryPolicy)subsPolicy).getRecoverDuration());
            LOG.info((Object)"Success");
            SystemUsage systemUsage = broker.getSystemUsage();
            ConfigTest.assertTrue((String)"Should have a SystemUsage", (systemUsage != null ? 1 : 0) != 0);
            ConfigTest.assertEquals((String)"SystemUsage Config Error (MemoryUsage.limit)", (long)0xA00000L, (long)systemUsage.getMemoryUsage().getLimit());
            ConfigTest.assertEquals((String)"SystemUsage Config Error (MemoryUsage.percentUsageMinDelta)", (int)20, (int)systemUsage.getMemoryUsage().getPercentUsageMinDelta());
            ConfigTest.assertEquals((String)"SystemUsage Config Error (TempUsage.limit)", (long)0x6400000L, (long)systemUsage.getTempUsage().getLimit());
            ConfigTest.assertEquals((String)"SystemUsage Config Error (StoreUsage.limit)", (long)0x40000000L, (long)systemUsage.getStoreUsage().getLimit());
            ConfigTest.assertEquals((String)"SystemUsage Config Error (StoreUsage.name)", (String)"foo", (String)systemUsage.getStoreUsage().getName());
            LOG.info((Object)"Success");
        }
        finally {
            if (broker != null) {
                broker.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJournalConfig() throws Exception {
        File journalFile = new File("target/test-data/testJournalConfig/journal");
        ConfigTest.recursiveDelete(journalFile);
        BrokerService broker = this.createBroker((Resource)new FileSystemResource("src/test/resources/org/apache/activemq/config/sample-conf/journal-example.xml"));
        try {
            ConfigTest.assertEquals((String)"Broker Config Error (brokerName)", (String)"brokerJournalConfigTest", (String)broker.getBrokerName());
            PersistenceAdapter adapter = broker.getPersistenceAdapter();
            ConfigTest.assertTrue((String)"Should have created a journal persistence adapter", (boolean)(adapter instanceof JournalPersistenceAdapter));
            ConfigTest.assertTrue((String)("Should have created a journal directory at " + journalFile.getAbsolutePath()), (boolean)journalFile.exists());
            LOG.info((Object)"Success");
        }
        finally {
            if (broker != null) {
                broker.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMemoryConfig() throws Exception {
        File journalFile = new File("target/test-data/testMemoryConfig");
        ConfigTest.recursiveDelete(journalFile);
        File derbyFile = new File("target/test-data/testMemoryConfig");
        ConfigTest.recursiveDelete(derbyFile);
        BrokerService broker = this.createBroker((Resource)new FileSystemResource("src/test/resources/org/apache/activemq/config/sample-conf/memory-example.xml"));
        try {
            ConfigTest.assertEquals((String)"Broker Config Error (brokerName)", (String)"brokerMemoryConfigTest", (String)broker.getBrokerName());
            PersistenceAdapter adapter = broker.getPersistenceAdapter();
            ConfigTest.assertTrue((String)"Should have created a memory persistence adapter", (boolean)(adapter instanceof MemoryPersistenceAdapter));
            ConfigTest.assertTrue((String)("Should have not created a derby directory at " + derbyFile.getAbsolutePath()), (!derbyFile.exists() ? 1 : 0) != 0);
            ConfigTest.assertTrue((String)("Should have not created a journal directory at " + journalFile.getAbsolutePath()), (!journalFile.exists() ? 1 : 0) != 0);
            LOG.info((Object)"Success");
        }
        finally {
            if (broker != null) {
                broker.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXmlConfigHelper() throws Exception {
        BrokerService broker = this.createBroker((Resource)new FileSystemResource("src/test/resources/org/apache/activemq/config/sample-conf/memory-example.xml"));
        try {
            ConfigTest.assertEquals((String)"Broker Config Error (brokerName)", (String)"brokerMemoryConfigTest", (String)broker.getBrokerName());
        }
        finally {
            if (broker != null) {
                broker.stop();
            }
        }
        broker = this.createBroker("org/apache/activemq/config/config.xml");
        try {
            ConfigTest.assertEquals((String)"Broker Config Error (brokerName)", (String)"brokerXmlConfigHelper", (String)broker.getBrokerName());
        }
        finally {
            if (broker != null) {
                broker.stop();
            }
        }
    }

    protected static void recursiveDelete(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                ConfigTest.recursiveDelete(files[i]);
            }
        }
        file.delete();
    }

    protected BrokerService createBroker(String resource) throws Exception {
        return this.createBroker((Resource)new ClassPathResource(resource));
    }

    protected BrokerService createBroker(Resource resource) throws Exception {
        BrokerFactoryBean factory = new BrokerFactoryBean(resource);
        factory.afterPropertiesSet();
        BrokerService broker = factory.getBroker();
        ConfigTest.assertTrue((String)"Should have a broker!", (broker != null ? 1 : 0) != 0);
        return broker;
    }

    static {
        System.setProperty("javax.net.ssl.trustStore", "src/test/resources/client.keystore");
        System.setProperty("javax.net.ssl.trustStorePassword", "password");
        System.setProperty("javax.net.ssl.trustStoreType", "jks");
        System.setProperty("javax.net.ssl.keyStore", "src/test/resources/server.keystore");
        System.setProperty("javax.net.ssl.keyStorePassword", "password");
        System.setProperty("javax.net.ssl.keyStoreType", "jks");
    }
}

