/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel;

import java.util.Hashtable;
import javax.naming.Context;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.jndi.JndiContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CamelEmbeddedBrokerTestSupport
extends EmbeddedBrokerTestSupport {
    protected CamelContext camelContext;
    protected CamelTemplate<Exchange> template;

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:61616";
        super.setUp();
        this.camelContext = this.createCamelContext();
        this.addCamelRoutes(this.camelContext);
        this.assertValidContext(this.camelContext);
        this.camelContext.start();
        this.template = new CamelTemplate(this.camelContext);
        this.template.start();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.template != null) {
            this.template.stop();
        }
        if (this.camelContext != null) {
            this.camelContext.stop();
        }
    }

    protected CamelContext createCamelContext() throws Exception {
        return new DefaultCamelContext(this.createJndiContext());
    }

    protected Context createJndiContext() throws Exception {
        return new JndiContext(new Hashtable());
    }

    protected void addCamelRoutes(CamelContext camelContext) throws Exception {
    }

    protected Endpoint resolveMandatoryEndpoint(String uri) {
        return this.resolveMandatoryEndpoint(this.camelContext, uri);
    }

    protected <T extends Endpoint> T resolveMandatoryEndpoint(String uri, Class<T> endpointType) {
        return this.resolveMandatoryEndpoint(this.camelContext, uri, endpointType);
    }

    protected Endpoint resolveMandatoryEndpoint(CamelContext context, String uri) {
        Endpoint endpoint = context.getEndpoint(uri);
        CamelEmbeddedBrokerTestSupport.assertNotNull((String)("No endpoint found for URI: " + uri), (Object)endpoint);
        return endpoint;
    }

    protected <T extends Endpoint> T resolveMandatoryEndpoint(CamelContext context, String uri, Class<T> endpointType) {
        Endpoint endpoint = context.getEndpoint(uri, endpointType);
        CamelEmbeddedBrokerTestSupport.assertNotNull((String)("No endpoint found for URI: " + uri), (Object)endpoint);
        return (T)endpoint;
    }

    protected MockEndpoint getMockEndpoint(String uri) {
        return this.resolveMandatoryEndpoint(uri, MockEndpoint.class);
    }

    protected void assertMockEndpointsSatisifed() throws InterruptedException {
        MockEndpoint.assertIsSatisfied((CamelContext)this.camelContext);
    }

    protected void assertValidContext(CamelContext context) {
        CamelEmbeddedBrokerTestSupport.assertNotNull((String)"No context found!", (Object)context);
    }
}

