/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;

public class MessageSender {
    private MessageProducer producer;
    private Session session;

    public MessageSender(String queueName, Connection connection, boolean useTransactedSession) throws Exception {
        this.session = useTransactedSession ? connection.createSession(true, 0) : connection.createSession(false, 1);
        this.producer = this.session.createProducer((Destination)this.session.createQueue(queueName));
    }

    public void send(String payload) throws Exception {
        ObjectMessage message = this.session.createObjectMessage();
        message.setObject((Serializable)((Object)payload));
        this.producer.send((Message)message);
        if (this.session.getTransacted()) {
            this.session.commit();
        }
    }
}

