/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.advisory;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.advisory.ProducerEvent;
import org.apache.activemq.advisory.ProducerEventSource;
import org.apache.activemq.advisory.ProducerListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProducerListenerTest
extends EmbeddedBrokerTestSupport
implements ProducerListener {
    private static final Log LOG = LogFactory.getLog(ProducerListenerTest.class);
    protected Session consumerSession1;
    protected Session consumerSession2;
    protected int consumerCounter;
    protected ProducerEventSource producerEventSource;
    protected BlockingQueue<ProducerEvent> eventQueue = new ArrayBlockingQueue<ProducerEvent>(1000);
    private Connection connection;

    public void testProducerEvents() throws Exception {
        this.producerEventSource.start();
        this.consumerSession1 = this.createProducer();
        this.assertConsumerEvent(1, true);
        this.consumerSession2 = this.createProducer();
        this.assertConsumerEvent(2, true);
        this.consumerSession1.close();
        this.consumerSession1 = null;
        this.assertConsumerEvent(1, false);
        this.consumerSession2.close();
        this.consumerSession2 = null;
        this.assertConsumerEvent(0, false);
    }

    public void testListenWhileAlreadyConsumersActive() throws Exception {
        this.consumerSession1 = this.createProducer();
        this.consumerSession2 = this.createProducer();
        this.producerEventSource.start();
        this.assertConsumerEvent(2, true);
        this.assertConsumerEvent(2, true);
        this.consumerSession1.close();
        this.consumerSession1 = null;
        this.assertConsumerEvent(1, false);
        this.consumerSession2.close();
        this.consumerSession2 = null;
        this.assertConsumerEvent(0, false);
    }

    public void onProducerEvent(ProducerEvent event) {
        this.eventQueue.add(event);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.connection = this.createConnection();
        this.connection.start();
        this.producerEventSource = new ProducerEventSource(this.connection, this.destination);
        this.producerEventSource.setProducerListener((ProducerListener)this);
    }

    protected void tearDown() throws Exception {
        if (this.producerEventSource != null) {
            this.producerEventSource.stop();
        }
        if (this.consumerSession2 != null) {
            this.consumerSession2.close();
        }
        if (this.consumerSession1 != null) {
            this.consumerSession1.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }

    protected void assertConsumerEvent(int count, boolean started) throws InterruptedException {
        ProducerEvent event = this.waitForProducerEvent();
        ProducerListenerTest.assertEquals((String)"Producer count", (int)count, (int)event.getProducerCount());
        ProducerListenerTest.assertEquals((String)"started", (boolean)started, (boolean)event.isStarted());
    }

    protected Session createProducer() throws JMSException {
        String consumerText = "Consumer: " + ++this.consumerCounter;
        LOG.info((Object)("Creating consumer: " + consumerText + " on destination: " + this.destination));
        Session answer = this.connection.createSession(false, 1);
        MessageProducer producer = answer.createProducer(this.destination);
        return answer;
    }

    protected ProducerEvent waitForProducerEvent() throws InterruptedException {
        ProducerEvent answer = this.eventQueue.poll(100000L, TimeUnit.MILLISECONDS);
        ProducerListenerTest.assertTrue((String)"Should have received a consumer event!", (answer != null ? 1 : 0) != 0);
        return answer;
    }
}

