/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.fest.util.Arrays;
import org.fest.util.FilesException;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Files {
    public static List<String> fileNamesIn(String dirName, boolean recurse) {
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(Strings.concat(Strings.quote(dirName), " is not a directory or does not exist"));
        }
        return Files.fileNamesIn(dir, recurse);
    }

    private static List<String> fileNamesIn(File dir, boolean recurse) {
        ArrayList<String> scriptNames = new ArrayList<String>();
        File[] existingFiles = dir.listFiles();
        if (Arrays.isEmpty(existingFiles)) {
            return scriptNames;
        }
        for (File existingFile : existingFiles) {
            if (existingFile.isDirectory()) {
                if (!recurse) continue;
                scriptNames.addAll(Files.fileNamesIn(existingFile, recurse));
                continue;
            }
            String filename = existingFile.getAbsolutePath();
            if (scriptNames.contains(filename)) continue;
            scriptNames.add(filename);
        }
        return scriptNames;
    }

    public static File temporaryFolder() {
        File temp = new File(Files.temporaryFolderPath());
        if (!temp.isDirectory()) {
            throw new FilesException("Unable to find temporary folder");
        }
        return temp;
    }

    public static String temporaryFolderPath() {
        return Strings.append(File.separator).to(System.getProperty("java.io.tmpdir"));
    }

    public static File newTemporaryFile() {
        String tempFileName = Strings.concat(String.valueOf(System.currentTimeMillis()), ".txt");
        return Files.newFile(Strings.concat(Files.temporaryFolderPath(), tempFileName));
    }

    public static File newTemporaryFolder() {
        String tempFileName = String.valueOf(System.currentTimeMillis());
        return Files.newFolder(Strings.concat(Files.temporaryFolderPath(), tempFileName));
    }

    public static File newFile(String path) {
        File file = new File(path);
        if (file.isDirectory() && !Arrays.isEmpty(file.list())) {
            throw Files.cannotCreateNewFile(path, "a non-empty directory was found with the same path");
        }
        try {
            if (!file.createNewFile()) {
                throw Files.cannotCreateNewFile(path, "a file was found with the same path");
            }
        }
        catch (IOException e) {
            throw Files.cannotCreateNewFile(path, e);
        }
        return file;
    }

    public static File newFolder(String path) {
        File file = new File(path);
        if (file.isDirectory() && !Arrays.isEmpty(file.list())) {
            throw Files.cannotCreateNewFile(path, "a non-empty directory was found with the same path");
        }
        try {
            if (!file.mkdir()) {
                throw Files.cannotCreateNewFile(path, "a file was found with the same path");
            }
        }
        catch (Exception e) {
            throw Files.cannotCreateNewFile(path, e);
        }
        return file;
    }

    private static FilesException cannotCreateNewFile(String path, String reason) {
        throw Files.cannotCreateNewFile(path, reason, null);
    }

    private static FilesException cannotCreateNewFile(String path, Exception cause) {
        throw Files.cannotCreateNewFile(path, null, cause);
    }

    private static FilesException cannotCreateNewFile(String path, String reason, Exception cause) {
        String message = Strings.concat("Unable to create the new file ", Strings.quote(path));
        if (!Strings.isEmpty(reason)) {
            message = Strings.concat(message, ": ", reason);
        }
        if (cause != null) {
            throw new FilesException(message, cause);
        }
        throw new FilesException(message);
    }

    public static void flushAndClose(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void flushAndClose(OutputStream out) {
        if (out == null) {
            return;
        }
        try {
            out.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Files() {
    }
}

