/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Collections {
    public static <T> List<T> list(T ... elements) {
        if (elements == null) {
            return null;
        }
        return new ArrayList<T>(Arrays.asList(elements));
    }

    public static <T> Collection<T> duplicatesFrom(Collection<T> c) {
        HashSet<T> duplicates = new HashSet<T>();
        if (Collections.isEmpty(c)) {
            return duplicates;
        }
        HashSet<T> onlyOne = new HashSet<T>();
        for (T e : c) {
            if (onlyOne.contains(e)) {
                duplicates.add(e);
                continue;
            }
            onlyOne.add(e);
        }
        return duplicates;
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    private Collections() {
    }
}

