/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.MultiChartUtilities;
import org.jfree.ui.ExtensionFileFilter;

public class MultiChartPanel
extends ChartPanel {
    private List panels;

    public MultiChartPanel(JFreeChart chart, List panels) {
        super(chart, 680, 420, 300, 200, 800, 600, false, true, true, true, true, true);
        this.panels = panels;
    }

    public MultiChartPanel(JFreeChart chart, boolean useBuffer, List panels) {
        super(chart, 680, 420, 300, 200, 800, 600, useBuffer, true, true, true, true, true);
        this.panels = panels;
    }

    public MultiChartPanel(JFreeChart chart, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips, List panels) {
        super(chart, 680, 420, 300, 200, 800, 600, false, properties, save, print, zoom, tooltips);
        this.panels = panels;
    }

    public MultiChartPanel(JFreeChart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips, List panels) {
        super(chart, width, height, minimumDrawWidth, minimumDrawHeight, maximumDrawWidth, maximumDrawHeight, useBuffer, properties, save, print, zoom, tooltips);
        this.panels = panels;
    }

    public MultiChartPanel(List panels, ChartPanel chartpanel) {
        super(chartpanel.getChart());
        this.panels = panels;
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (this.panels == null || this.panels.size() == 0 || this.panels.size() == 1) {
            return super.print(g, pf, pageIndex);
        }
        if (pageIndex != 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        double x = pf.getImageableX();
        double y = pf.getImageableY();
        double w = pf.getImageableWidth();
        double h = pf.getImageableHeight();
        int saveColumns = 2;
        int saveRows = this.panels.size() == saveColumns && pf.getOrientation() == 1 ? 2 : new BigDecimal((double)this.panels.size()).divide(new BigDecimal((double)saveColumns), 0).intValue();
        Iterator i = this.panels.iterator();
        while (i.hasNext()) {
            for (int j = 0; j < saveColumns; ++j) {
                if (!i.hasNext()) continue;
                ((MultiChartPanel)i.next()).getChart().draw(g2, new Rectangle2D.Double(x, y, w / (double)saveColumns, h / (double)saveRows), this.getAnchor(), null);
                x += w / (double)saveColumns;
            }
            x = pf.getImageableX();
            y += h / (double)saveRows;
        }
        return 0;
    }

    public void doSaveAs() throws IOException {
        if (this.panels == null || this.panels.size() == 0 || this.panels.size() == 1) {
            super.doSaveAs();
        } else {
            JFileChooser fileChooser = new JFileChooser();
            ExtensionFileFilter filter = new ExtensionFileFilter(localizationResources.getString("PNG_Image_Files"), ".png");
            fileChooser.addChoosableFileFilter((FileFilter)filter);
            int option = fileChooser.showSaveDialog(this);
            if (option == 0) {
                String filename = fileChooser.getSelectedFile().getPath();
                if (this.isEnforceFileExtensions() && !filename.endsWith(".png")) {
                    filename = filename + ".png";
                }
                ArrayList<JFreeChart> charts = new ArrayList<JFreeChart>();
                Iterator i = this.panels.iterator();
                while (i.hasNext()) {
                    MultiChartPanel panel = (MultiChartPanel)i.next();
                    JFreeChart chart = panel.getChart();
                    charts.add(chart);
                }
                MultiChartUtilities.saveChartsAsPNG(new File(filename), charts, this.getWidth(), this.getHeight());
            }
        }
    }
}

