/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardHCToolTipGenerator;
import org.jfree.chart.labels.StandardSOMToolTipGenerator;
import org.jfree.chart.plot.HCPlot;
import org.jfree.chart.plot.SOMPlot;
import org.jfree.data.hc.HCDataset;
import org.jfree.data.som.SOMDataset;

public class BioChartFactory {
    public static JFreeChart createHCChart(String title, HCDataset dataset, boolean tooltips, boolean urls) {
        HCPlot plot = new HCPlot(dataset);
        if (tooltips) {
            plot.setToolTipGenerator(new StandardHCToolTipGenerator());
        }
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, false);
        chart.setAntiAlias(false);
        return chart;
    }

    public static JFreeChart createSOMChart(String title, SOMDataset dataset, boolean tooltips, boolean urls) {
        SOMPlot plot = new SOMPlot(dataset);
        if (tooltips) {
            plot.setToolTipGenerator(new StandardSOMToolTipGenerator());
        }
        return new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, false);
    }
}

