/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class UrlTransferUtil {
    private static final Logger logger = Logger.getLogger(UrlTransferUtil.class);
    private static final int CHUNK_SIZE = 2048;

    public static InputStream downloadStream(URL url) throws JMSException, IOException {
        return url.openStream();
    }

    public static URL uploadStream(URL url, InputStream fis, boolean useChunked) throws JMSException, IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("PUT");
        connection.setDoOutput(true);
        logger.debug("uploading with parameters: useChunked " + useChunked + ", CHUNK_SIZE " + 2048);
        if (useChunked) {
            connection.setChunkedStreamingMode(2048);
        }
        OutputStream os = connection.getOutputStream();
        byte[] buf = new byte[2048];
        int c = fis.read(buf);
        while (c != -1) {
            os.write(buf, 0, c);
            os.flush();
            c = fis.read(buf);
        }
        os.close();
        fis.close();
        if (!UrlTransferUtil.isSuccessfulCode(connection.getResponseCode())) {
            throw new IOException("PUT was not successful: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
        return url;
    }

    private static boolean isSuccessfulCode(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }
}

