/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.fs;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.databeans.ContentChangedEvent;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataChangeEvent;
import fi.csc.microarray.databeans.DataChangeListener;
import fi.csc.microarray.databeans.DataItemCreatedEvent;
import fi.csc.microarray.databeans.DataItemRemovedEvent;
import fi.csc.microarray.databeans.LinksChangedEvent;
import fi.csc.microarray.databeans.fs.FSDataManager;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class FSDataEventTest
implements DataChangeListener {
    DataChangeEvent lastEvent = null;
    boolean gotTwice = false;

    @BeforeTest
    public void init() throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
    }

    @Test
    public void testEvents() throws IOException, MicroarrayException {
        FSDataManager manager = new FSDataManager();
        manager.addDataChangeListener(this);
        manager.setEventsEnabled(true);
        DataBean bean1 = manager.createDataBean("My bean.txt");
        this.assertNoEvent();
        DataBean bean2 = manager.createDataBean("My other bean.txt");
        this.assertNoEvent();
        bean1.addLink(DataBean.Link.DERIVATION, bean2);
        this.assertNoEvent();
        manager.getRootFolder().addChild(bean1);
        this.assertDataCreatedEvent();
        manager.getRootFolder().addChild(bean2);
        this.assertDataCreatedEvent();
        bean1.addLink(DataBean.Link.ANNOTATION, bean2);
        this.assertLinksChangedEvent();
        bean1.setName("My nice bean.txt");
        this.assertContentChangedEvent();
        manager.getRootFolder().removeChild(bean2);
        this.assertDataRemovedEvent();
    }

    private void assertDataRemovedEvent() {
        Assert.assertFalse(this.gotTwice);
        Assert.assertNotNull(this.lastEvent);
        Assert.assertTrue(this.lastEvent instanceof DataItemRemovedEvent, "wrong event type: " + this.lastEvent.getClass().getSimpleName());
        this.lastEvent = null;
    }

    private void assertContentChangedEvent() {
        Assert.assertFalse(this.gotTwice);
        Assert.assertNotNull(this.lastEvent);
        Assert.assertTrue(this.lastEvent instanceof ContentChangedEvent, "wrong event type: " + this.lastEvent.getClass().getSimpleName());
        this.lastEvent = null;
    }

    private void assertLinksChangedEvent() {
        Assert.assertFalse(this.gotTwice);
        Assert.assertNotNull(this.lastEvent);
        Assert.assertTrue(this.lastEvent instanceof LinksChangedEvent, "wrong event type: " + this.lastEvent.getClass().getSimpleName());
        this.lastEvent = null;
    }

    private void assertDataCreatedEvent() {
        Assert.assertFalse(this.gotTwice);
        Assert.assertNotNull(this.lastEvent);
        Assert.assertTrue(this.lastEvent instanceof DataItemCreatedEvent, "wrong event type: " + this.lastEvent.getClass().getSimpleName());
        this.lastEvent = null;
    }

    private void assertNoEvent() {
        Assert.assertNull(this.lastEvent);
    }

    public void dataChanged(DataChangeEvent event) {
        if (this.lastEvent != null) {
            this.gotTwice = true;
        } else {
            this.lastEvent = event;
        }
    }
}

