/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataBeanSelector;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.fs.FSDataManager;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.io.IOException;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class LinkTest {
    private DataManager manager;

    @BeforeSuite(alwaysRun=true)
    public void init() throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
        this.manager = new FSDataManager();
    }

    @Test(groups={"smoke"})
    public void testLinks() throws MicroarrayException {
        DataBean bean1 = this.manager.createDataBean("test1");
        DataBean bean2 = this.manager.createDataBean("test2");
        DataBean bean3 = this.manager.createDataBean("test3");
        bean1.addLink(DataBean.Link.ANNOTATION, bean3);
        bean1.addLink(DataBean.Link.DERIVATION, bean2);
        bean1.addLink(DataBean.Link.DERIVATION, bean3);
        bean2.addLink(DataBean.Link.DERIVATION, bean3);
        Assert.assertEquals(bean1.getLinkTargets(DataBean.Link.DERIVATION).size(), 2);
        Assert.assertEquals(bean1.getLinkSources(DataBean.Link.DERIVATION).size(), 0);
        Assert.assertEquals(bean2.getLinkTargets(DataBean.Link.DERIVATION).size(), 1);
        Assert.assertEquals(bean2.getLinkSources(DataBean.Link.DERIVATION).size(), 1);
        Assert.assertEquals(bean3.getLinkTargets(DataBean.Link.DERIVATION).size(), 0);
        Assert.assertEquals(bean3.getLinkSources(DataBean.Link.DERIVATION).size(), 2);
        bean1.removeLink(DataBean.Link.DERIVATION, bean3);
        Assert.assertEquals(bean1.getLinkTargets(DataBean.Link.DERIVATION).size(), 1);
        Assert.assertEquals(bean1.getLinkSources(DataBean.Link.DERIVATION).size(), 0);
        Assert.assertEquals(bean2.getLinkTargets(DataBean.Link.DERIVATION).size(), 1);
        Assert.assertEquals(bean2.getLinkSources(DataBean.Link.DERIVATION).size(), 1);
        Assert.assertEquals(bean3.getLinkTargets(DataBean.Link.DERIVATION).size(), 0);
        Assert.assertEquals(bean3.getLinkSources(DataBean.Link.DERIVATION).size(), 1);
        Assert.assertEquals(bean1.getLinkTargets(DataBean.Link.ANNOTATION).size(), 1);
        Assert.assertEquals(bean1.getLinkSources(DataBean.Link.ANNOTATION).size(), 0);
        Assert.assertEquals(bean2.getLinkTargets(DataBean.Link.ANNOTATION).size(), 0);
        Assert.assertEquals(bean2.getLinkSources(DataBean.Link.ANNOTATION).size(), 0);
        Assert.assertEquals(bean3.getLinkTargets(DataBean.Link.ANNOTATION).size(), 0);
        Assert.assertEquals(bean3.getLinkSources(DataBean.Link.ANNOTATION).size(), 1);
    }

    @Test(groups={"smoke"})
    public void testTraversal() throws MicroarrayException {
        DataBean bean1 = this.manager.createDataBean("test1");
        final DataBean bean2 = this.manager.createDataBean("test2");
        DataBean bean3 = this.manager.createDataBean("test3");
        bean1.addLink(DataBean.Link.DERIVATION, bean2);
        bean1.addLink(DataBean.Link.DERIVATION, bean3);
        bean2.addLink(DataBean.Link.DERIVATION, bean3);
        Assert.assertTrue(bean1.traverseLinks(DataBean.Link.derivationalTypes(), DataBean.Traversal.DIRECT).size() == 3);
        Assert.assertTrue(bean1.traverseLinks(DataBean.Link.derivationalTypes(), DataBean.Traversal.REVERSED).size() == 1);
        Assert.assertTrue(bean1.traverseLinks(DataBean.Link.derivationalTypes(), DataBean.Traversal.BIDIRECTIONAL).size() == 3);
        Assert.assertTrue(bean2.traverseLinks(DataBean.Link.derivationalTypes(), DataBean.Traversal.DIRECT).size() == 2);
        Assert.assertTrue(bean2.traverseLinks(DataBean.Link.derivationalTypes(), DataBean.Traversal.REVERSED).contains(bean1));
        Assert.assertTrue(bean2.traverseLinks(DataBean.Link.derivationalTypes(), DataBean.Traversal.BIDIRECTIONAL).size() == 3);
        List<DataBean> selected = bean2.traverseLinks(DataBean.Link.derivationalTypes(), DataBean.Traversal.BIDIRECTIONAL, new DataBeanSelector(){

            public boolean shouldSelect(DataBean bean) {
                return bean == bean2;
            }

            public boolean shouldTraverse(DataBean bean) {
                return true;
            }
        });
        Assert.assertTrue(selected.size() == 1);
        Assert.assertTrue(selected.contains(bean2));
    }
}

