/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.visualisation.MicroarrayTable;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.databeans.ContentChangedEvent;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataChangeEvent;
import fi.csc.microarray.databeans.DataChangeListener;
import fi.csc.microarray.databeans.biobeans.BioBean;
import fi.csc.microarray.databeans.features.table.TableBeanEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.table.ColumnHeaderRenderer;

public class PhenodataEditor
extends Visualisation
implements DataChangeListener {
    private JPanel paramPanel;
    private JTextField columnNameField;
    private JComboBox columnsCombo;
    private static final Logger logger = Logger.getLogger(PhenodataEditor.class);
    private DataBean data;
    private PhenodataTable table;
    private TableBeanEditor tableEditor;
    private PhenodataTableModel tableModel;

    public PhenodataEditor(VisualisationFrame frame) {
        super(frame);
    }

    private void setColumnsComboContent() {
        this.columnsCombo.removeAllItems();
        for (String columnName : this.tableEditor.getEditable().getColumnNames()) {
            if (!BioBean.isEditablePhenodataColumn(columnName)) continue;
            this.columnsCombo.addItem(columnName);
        }
    }

    public JPanel getParameterPanel() {
        logger.debug("in PhenodataEditor.getParameterPanel()");
        if (this.paramPanel == null) {
            logger.debug("in PhenodataEditor.getParameterPanel() paramPanel is null");
            this.paramPanel = new JPanel();
            this.paramPanel.setLayout(new GridBagLayout());
            this.paramPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
            this.columnNameField = new JTextField("new_column");
            this.columnsCombo = new JComboBox();
            JButton addButton = new JButton("Add");
            addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (PhenodataEditor.this.columnNameField.getText() == null || PhenodataEditor.this.columnNameField.getText().equals("") || PhenodataEditor.this.tableEditor.getEditable().containsColumn(PhenodataEditor.this.columnNameField.getText())) {
                        JOptionPane.showMessageDialog(((SwingClientApplication)PhenodataEditor.this.application).getMainFrame(), "Name of the column is empty or exists already.");
                        return;
                    }
                    try {
                        PhenodataEditor.this.tableModel.addColumn(PhenodataEditor.this.columnNameField.getText());
                    }
                    catch (Exception e1) {
                        PhenodataEditor.this.application.reportException(e1);
                    }
                    PhenodataEditor.this.table.createDefaultColumnsFromModel();
                    PhenodataEditor.this.updatePhenodataTableHeaders();
                    PhenodataEditor.this.setColumnsComboContent();
                }
            });
            JButton removeButton = new JButton("Remove");
            removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        PhenodataEditor.this.tableModel.removeColumn((String)PhenodataEditor.this.columnsCombo.getSelectedItem());
                    }
                    catch (Exception e1) {
                        PhenodataEditor.this.application.reportException(e1);
                    }
                    PhenodataEditor.this.table.createDefaultColumnsFromModel();
                    PhenodataEditor.this.updatePhenodataTableHeaders();
                    PhenodataEditor.this.setColumnsComboContent();
                }
            });
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.gridx = 0;
            c.insets.set(5, 10, 5, 10);
            c.anchor = 18;
            c.weightx = 1.0;
            c.fill = 2;
            this.paramPanel.add((Component)new JLabel("Add a new column: "), c);
            ++c.gridy;
            this.paramPanel.add((Component)this.columnNameField, c);
            ++c.gridy;
            this.paramPanel.add((Component)addButton, c);
            ++c.gridy;
            this.paramPanel.add((Component)new JLabel("Remove column: "), c);
            ++c.gridy;
            this.paramPanel.add((Component)this.columnsCombo, c);
            ++c.gridy;
            this.paramPanel.add((Component)removeButton, c);
            c.fill = 1;
            c.weighty = 1.0;
            this.paramPanel.add((Component)new JPanel(), c);
            logger.debug("in PhenodataEditor.getParameterPanel() components created and added");
        }
        return this.paramPanel;
    }

    public JComponent getVisualisation(DataBean data) throws Exception {
        this.data = data;
        this.tableEditor = new TableBeanEditor(data);
        this.tableModel = new PhenodataTableModel(this.tableEditor);
        this.table = new PhenodataTable(data);
        this.table.setUneditableBackground(VisualConstants.PHENODATA_TABLE_UNEDITABLE_CELL_BACKGROUND);
        this.table.setModel(this.tableModel);
        this.table.getColumn(0).setPreferredWidth(100);
        this.updatePhenodataTableHeaders();
        this.application.getDataManager().addDataChangeListener(this);
        this.table.setSelectionMode(1);
        this.table.setColumnControlVisible(true);
        JScrollPane tableScroller = new JScrollPane(this.table);
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PhenodataPopupMenu popup = new PhenodataPopupMenu(PhenodataEditor.this.table);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        return tableScroller;
    }

    private void updatePhenodataTableHeaders() {
        for (TableColumn columnObject : this.table.getColumns()) {
            TableColumn tableColumn;
            if (!(columnObject instanceof TableColumn) || !BioBean.isGroupPhenodataColumn((tableColumn = columnObject).getHeaderValue().toString())) continue;
            ColumnHeaderRenderer header = ColumnHeaderRenderer.createColumnHeaderRenderer();
            if (!this.data.queryFeatures("/phenodata/is-complete").exists()) {
                header.setIcon(VisualConstants.PHENODATA_ICON);
                logger.debug("Header updated. Warning icon enabled.");
            } else {
                header.setIcon(null);
                logger.debug("Header updated. Warning icon disabled.");
            }
            header.repaint();
            this.table.getTableHeader().repaint();
            tableColumn.setHeaderRenderer(header);
        }
    }

    public void dataChanged(DataChangeEvent evt) {
        logger.debug("received " + evt.getClass().getSimpleName());
        if (evt instanceof ContentChangedEvent) {
            this.updatePhenodataTableHeaders();
            logger.debug("phenodata headers updated");
        }
    }

    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        return bean.queryFeatures("/phenodata").exists();
    }

    public void removeVisualisation() {
        this.application.removePropertyChangeListener(this.table);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PhenodataTableModel
    implements TableModel {
        private final TableBeanEditor tableEditor;
        private LinkedList<TableModelListener> listeners = new LinkedList();

        private PhenodataTableModel(TableBeanEditor tableEditor) {
            this.tableEditor = tableEditor;
        }

        @Override
        public int getRowCount() {
            return this.tableEditor.getEditable().getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.tableEditor.getEditable().getColumnCount();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return BioBean.isEditablePhenodataColumn(this.tableEditor.getEditable().getColumnName(columnIndex));
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String title = this.tableEditor.getEditable().getColumnName(columnIndex);
            return this.tableEditor.getEditable().getValue(title, rowIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            try {
                String title = this.tableEditor.getEditable().getColumnName(columnIndex);
                logger.debug("set column " + title + " at row " + rowIndex + " to value " + aValue);
                this.tableEditor.getEditable().setValue(title, rowIndex, (String)aValue);
                this.tableEditor.write();
                for (TableModelListener listener : this.listeners) {
                    listener.tableChanged(new TableModelEvent(this));
                }
            }
            catch (Exception e) {
                PhenodataEditor.this.application.reportException(e);
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        public void addColumn(String title) throws Exception {
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < this.tableEditor.getEditable().getRowCount(); ++i) {
                values.add("");
            }
            this.tableEditor.getEditable().addColumn(title, values);
            this.tableEditor.write();
        }

        public void removeColumn(String title) throws Exception {
            this.tableEditor.getEditable().removeColumn((String)PhenodataEditor.this.columnsCombo.getSelectedItem());
            this.tableEditor.write();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.tableEditor.getEditable().getColumnName(columnIndex);
        }
    }

    public class PhenodataPopupMenu
    extends JPopupMenu
    implements ActionListener {
        private MicroarrayTable table;
        private JMenuItem copyMenuItem;
        private JMenuItem pasteMenuItem;

        public PhenodataPopupMenu(MicroarrayTable table) {
            this.table = table;
            this.copyMenuItem = new JMenuItem("Copy");
            this.pasteMenuItem = new JMenuItem("Paste");
            this.copyMenuItem.addActionListener(this);
            this.pasteMenuItem.addActionListener(this);
            this.add(this.copyMenuItem);
            this.add(this.pasteMenuItem);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.copyMenuItem) {
                this.table.copy();
            }
            if (e.getSource() == this.pasteMenuItem) {
                this.table.paste();
            }
        }
    }

    private class PhenodataTable
    extends MicroarrayTable {
        private static final int NO_SCROLL_WIDTH = 400;
        private static final int IDENTIFIER_COLUMN_WIDTH = 100;
        private int lastX;
        private int lastY;
        private Color uneditableBg;

        public PhenodataTable(DataBean data) {
            super(data);
            this.lastX = -1;
            this.lastY = -1;
            this.uneditableBg = this.getBackground();
            this.setHorizontalScrollEnabled(this.getWidth() < 400);
            this.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                }

                public void keyTyped(KeyEvent e) {
                    if (PhenodataTable.this.getCellEditor() != null) {
                        int y = PhenodataTable.this.getEditingRow();
                        int x = PhenodataTable.this.getEditingColumn();
                        if (y != PhenodataTable.this.lastY || x != PhenodataTable.this.lastX) {
                            PhenodataTable.this.getCellEditor().stopCellEditing();
                            PhenodataTable.this.lastY = y;
                            PhenodataTable.this.lastX = x;
                            PhenodataTable.this.setValueAt("", y, x);
                            boolean success = PhenodataTable.this.editCellAt(y, x);
                            if (success) {
                                PhenodataTable.this.changeSelection(y, x, false, false);
                            }
                        }
                        PhenodataTable.this.getCellEditor().addCellEditorListener(new CellEditorListener(){

                            public void editingCanceled(ChangeEvent e) {
                                PhenodataTable.this.lastX = (PhenodataTable.this.lastY = -1);
                            }

                            public void editingStopped(ChangeEvent e) {
                                PhenodataTable.this.lastX = (PhenodataTable.this.lastY = -1);
                            }
                        });
                    }
                }
            });
        }

        public void setModel(TableModel model) {
            super.setModel(model);
        }

        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component cell = super.prepareRenderer(renderer, row, column);
            if (this.isColumnSelected(column) && this.isRowSelected(row)) {
                cell.setBackground(this.getSelectionBackground());
                cell.setForeground(this.getSelectionForeground());
            } else {
                if (!BioBean.isEditablePhenodataColumn(this.getColumnName(column))) {
                    cell.setBackground(this.getUneditableBackground());
                } else {
                    cell.setBackground(this.getBackground());
                }
                cell.setForeground(this.getForeground());
            }
            return cell;
        }

        public Color getUneditableBackground() {
            return this.uneditableBg;
        }

        public void setUneditableBackground(Color c) {
            this.uneditableBg = c;
        }
    }
}

