/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.selection.RowSelectionManager;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.util.ThreadUtils;
import fi.csc.microarray.wizard.ResultBlocker;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualisationUtilities {
    private static final ClientApplication application = Session.getSession().getApplication();

    public static DataBean filterBySelection(List<DataBean> datas) {
        try {
            int largestDataIndex = 0;
            int largestDataColCount = -1;
            for (int i = 0; i < datas.size(); ++i) {
                int colCount = datas.get(i).queryFeatures("/column/*").asTable().getColumnCount();
                if (colCount <= largestDataColCount) continue;
                largestDataColCount = colCount;
                largestDataIndex = i;
            }
            List<String> lines = application.getSelectionManager().getRowSelectionManager(datas.get(largestDataIndex)).getSelectedLines();
            return RowSelectionManager.createDataset(lines, datas.toArray(new DataBean[datas.size()]));
        }
        catch (Exception exp) {
            application.reportException(new MicroarrayException("Unable to create user filtered dataset", exp));
            return null;
        }
    }

    public static void annotateBySelection(List<DataBean> datas) {
        try {
            final DataBean filterBySelection = VisualisationUtilities.filterBySelection(datas);
            Thread thread = ThreadUtils.getBackgroundThread(new Runnable(){

                public void run() {
                    try {
                        Operation normOp = new Operation(application.locateOperationDefinition("Annotation", "Agilent, Affymetrix or Illumina genelist"), new DataBean[]{filterBySelection});
                        ResultBlocker normBlocker = new ResultBlocker(2);
                        normOp.setResultListener(normBlocker);
                        application.executeOperation(normOp);
                    }
                    catch (MicroarrayException e) {
                        application.reportException(e);
                    }
                }
            });
            thread.start();
        }
        catch (Exception exp) {
            application.reportException(new MicroarrayException("Unable to collect identifiers for annotation", exp));
        }
    }
}

