/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChipVisualisation
extends Visualisation {
    public ChipVisualisation(VisualisationFrame frame) {
        super(frame);
    }

    @Override
    public Visualisation.Variable[] getVariablesFor(DataBean dataBean) {
        LinkedList<Visualisation.Variable> vars = new LinkedList<Visualisation.Variable>();
        try {
            this.extractChips(dataBean, vars);
        }
        catch (MicroarrayException e) {
            this.application.reportException(new MicroarrayException("no chips to visualise"));
        }
        return vars.toArray(new Visualisation.Variable[0]);
    }

    private void extractChips(DataBean dataBean, LinkedList<Visualisation.Variable> vars) throws MicroarrayException {
        String exprHeader = "/column/";
        String chipHeader = "chip.";
        Table columns = dataBean.queryFeatures("/column/*").asTable();
        for (String columnName : columns.getColumnNames()) {
            if (!columnName.startsWith(chipHeader)) continue;
            String chipName = columnName.substring(chipHeader.length());
            String expression = exprHeader + columnName;
            vars.add(new Visualisation.Variable(chipName, expression));
        }
    }

    @Override
    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        boolean isTabular = VisualisationMethod.SPREADSHEET.getHeadlessVisualiser().canVisualise(bean);
        return isTabular && this.hasRows(bean) && bean.queryFeatures("/column/chip.*").exists();
    }

    protected boolean hasRows(DataBean dataBean) throws MicroarrayException {
        return dataBean.queryFeatures("/rowcount/max/1").asFloat().floatValue() >= 1.0f;
    }
}

