/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.TableAnnotationProvider;
import fi.csc.microarray.client.visualisation.VisualisationUtilities;
import fi.csc.microarray.client.visualisation.methods.Scatterplot;
import fi.csc.microarray.client.visualisation.methods.threed.DataPoint;
import fi.csc.microarray.databeans.DataBean;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotateListPanel
extends JPanel {
    private JList selectedList;
    private DefaultListModel selectedListModel;
    private JButton annotateButton;
    private JButton filterButton;
    private List<DataBean> datas = new ArrayList<DataBean>();
    private ClientApplication application = Session.getSession().getApplication();
    private JLabel countLabel;

    public AnnotateListPanel() {
        this.setLayout(new BorderLayout());
        this.selectedListModel = new DefaultListModel();
        this.selectedList = new JList(this.selectedListModel);
        this.selectedList.setSelectionBackground(this.selectedList.getBackground());
        this.selectedList.setSelectionForeground(this.selectedList.getForeground());
        this.countLabel = new JLabel();
        this.annotateButton = new JButton("Annotate");
        this.annotateButton.setToolTipText("Create dataset and annotate with Bioconductor");
        this.annotateButton.setEnabled(false);
        this.annotateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VisualisationUtilities.annotateBySelection(AnnotateListPanel.this.datas);
            }
        });
        this.filterButton = new JButton("Create dataset");
        this.filterButton.setToolTipText("Create new dataset from selected rows");
        this.filterButton.setEnabled(false);
        this.filterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VisualisationUtilities.filterBySelection(AnnotateListPanel.this.datas);
            }
        });
        this.add((Component)this.countLabel, "North");
        this.add((Component)new JScrollPane(this.selectedList), "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)this.annotateButton, "North");
        buttonPanel.add((Component)this.filterButton, "South");
        this.add((Component)buttonPanel, "South");
    }

    public void setSelectedListContentMultipleDatas(List<String> content, Map<DataBean, Set<Integer>> indexes, Object source, boolean dispatchEvent) {
        this.setData(indexes.keySet());
        this.selectedListModel.removeAllElements();
        this.countLabel.setText(content.size() + " Points selected");
        this.annotateButton.setEnabled(content.size() > 0);
        this.filterButton.setEnabled(content.size() > 0);
        for (String row : content) {
            this.selectedListModel.addElement(row.toString());
        }
        if (dispatchEvent) {
            for (DataBean data : indexes.keySet()) {
                this.application.getSelectionManager().getRowSelectionManager(data).setSelected(indexes.get(data), source);
            }
        }
    }

    public void setSelectedListContent(Collection<DataPoint> content, Object source, boolean dispatchEvent, DataBean data) {
        this.setData(data);
        this.selectedListModel.removeAllElements();
        this.countLabel.setText(content.size() + " Points selected");
        this.annotateButton.setEnabled(content.size() > 0);
        this.filterButton.setEnabled(content.size() > 0);
        int[] indexes = new int[content.size()];
        int i = 0;
        for (DataPoint row : content) {
            this.selectedListModel.addElement(row.toString());
            indexes[i++] = row.getIndex();
        }
        if (dispatchEvent) {
            this.application.getSelectionManager().getRowSelectionManager(data).setSelected(indexes, source);
        }
    }

    public void setSelectedListContentAsDataItems(Collection<Scatterplot.DataItem2D> content, Object source, boolean dispatchEvent, DataBean data) {
        TableAnnotationProvider annotationProvider;
        this.setData(data);
        try {
            annotationProvider = new TableAnnotationProvider(data);
        }
        catch (MicroarrayException me) {
            throw new RuntimeException(me);
        }
        this.selectedListModel.removeAllElements();
        this.countLabel.setText(content.size() + " Points selected");
        this.annotateButton.setEnabled(content.size() > 0);
        this.filterButton.setEnabled(content.size() > 0);
        int[] indexes = new int[content.size()];
        int i = 0;
        for (Scatterplot.DataItem2D row : content) {
            this.selectedListModel.addElement(annotationProvider.getAnnotatedRowname(row.getName()));
            indexes[i++] = row.getIndex();
        }
        if (dispatchEvent) {
            this.application.getSelectionManager().getRowSelectionManager(data).setSelected(indexes, source);
        }
    }

    private void setData(DataBean data) {
        this.datas.clear();
        this.datas.add(data);
    }

    private void setData(Set<DataBean> set) {
        this.datas.clear();
        for (DataBean data : set) {
            this.datas.add(data);
        }
    }
}

