/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataview;

import fi.csc.microarray.client.dataview.AnimatorScrollable;
import fi.csc.microarray.client.dataview.GraphPanel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class ScrollAnimator
implements ActionListener {
    private Point from;
    private Point viewTarget = new Point();
    AnimatorScrollable scrollable;
    private int frame = 1;
    private Timer timer;
    private static boolean isBusy = false;
    private static ScrollAnimator latestAnimator;
    public static final int FRAME_COUNT = 10;
    public static final int SCROLL_MARGIN = 10;
    private static final Logger logger;

    public ScrollAnimator(GraphPanel graphPanel, Rectangle to) {
        this((Point)graphPanel.getGraph().fromScreen(graphPanel.getScroller().getViewport().getViewPosition()), to, graphPanel.getGraph().fromScreenCoordinates(graphPanel.getScroller().getViewport().getSize()), graphPanel);
    }

    public ScrollAnimator(Point from, Rectangle to, Dimension viewSize, AnimatorScrollable scrollable) {
        logger.debug("Animator started");
        if (latestAnimator != null) {
            latestAnimator.kill();
        }
        latestAnimator = this;
        this.scrollable = scrollable;
        this.from = from;
        Rectangle area = new Rectangle(from, viewSize);
        if (area.contains(to)) {
            logger.debug("Showing allready");
            return;
        }
        this.viewTarget.x = from.getX() < to.getX() ? (int)(to.getX() + to.getWidth() - viewSize.getWidth() + 10.0) : (int)(to.getX() - 10.0);
        this.viewTarget.y = from.getY() < to.getY() ? (int)(to.getY() + to.getHeight() - viewSize.getHeight() + 10.0) : (int)(to.getY() - 10.0);
        this.timer = new Timer(50, this);
        this.timer.start();
    }

    public void actionPerformed(ActionEvent e) {
        if (!isBusy) {
            isBusy = true;
            if (this.frame <= 10) {
                Point point = new Point();
                double factor = this.getFactor(this.frame);
                point.x = (int)(this.viewTarget.getX() - (this.viewTarget.getX() - this.from.getX()) * factor);
                point.y = (int)(this.viewTarget.getY() - (this.viewTarget.getY() - this.from.getY()) * factor);
                this.scrollable.setViewPosition(point);
            } else {
                this.scrollable.setViewPosition(this.viewTarget);
                this.timer.stop();
                latestAnimator = null;
            }
            isBusy = false;
        }
        ++this.frame;
    }

    private void kill() {
        if (this.timer != null) {
            this.timer.stop();
        }
        latestAnimator = null;
        logger.debug("ScrollAnimator killed");
    }

    private double getFactor(double frame) {
        return 1.0 / frame - 0.1;
    }

    static {
        logger = Logger.getLogger(ScrollAnimator.class);
    }
}

