/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport.tools;

import com.jgoodies.uif_lite.panel.SimpleInternalFrame;
import fi.csc.microarray.client.dataimport.ColumnType;
import fi.csc.microarray.client.dataimport.ColumnTypeManager;
import fi.csc.microarray.client.dataimport.ColumnTypePattern;
import fi.csc.microarray.client.dataimport.Delimiter;
import fi.csc.microarray.client.dataimport.ImportScreen;
import fi.csc.microarray.client.dataimport.events.ChipCountChangeEvent;
import fi.csc.microarray.client.dataimport.events.ChipNumberChangedEvent;
import fi.csc.microarray.client.dataimport.events.ColumnTitlesChangedEvent;
import fi.csc.microarray.client.dataimport.events.ColumnTypeChangeListener;
import fi.csc.microarray.client.dataimport.events.ColumnTypeChangedEvent;
import fi.csc.microarray.client.dataimport.events.ConversionModelChangeListener;
import fi.csc.microarray.client.dataimport.events.DecimalSeparatorChangedEvent;
import fi.csc.microarray.client.dataimport.events.DelimiterChangedEvent;
import fi.csc.microarray.client.dataimport.events.FooterChangedEvent;
import fi.csc.microarray.client.dataimport.events.HeaderChangedEvent;
import fi.csc.microarray.client.dataimport.events.InputFileChangedEvent;
import fi.csc.microarray.client.dataimport.events.TitleRowChangedEvent;
import fi.csc.microarray.client.dataimport.tools.ChipCountPanel;
import fi.csc.microarray.client.dataimport.tools.DataTrimmingPanel;
import fi.csc.microarray.client.dataimport.tools.FlagValuePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;

public class ToolsInternalFrame
extends SimpleInternalFrame
implements ActionListener,
CaretListener,
ColumnTypeChangeListener,
ConversionModelChangeListener {
    private static final Logger logger = Logger.getLogger(ToolsInternalFrame.class);
    private JXTaskPaneContainer firstStepOptionPanel;
    private JXTaskPaneContainer secondStepOptionPanel;
    private List<JRadioButton> delimRadioButtons;
    private JRadioButton customDelimRadioButton;
    private JTextField customDelimField;
    private JRadioButton dotAsDecimalSeparatorRadioButton;
    private JRadioButton commaAsDecimalSeparatorRadioButton;
    private ImportScreen screen;
    private ChipCountPanel chipCountPanel;
    private FlagValuePanel flagValuePanel;
    private JButton fillTheRestButton;
    private JButton useCustomDelimButton;
    private JButton undoGuessButton;

    public ToolsInternalFrame(ImportScreen screen) {
        super("Tools");
        this.screen = screen;
    }

    public void initializeFirstStep() {
        this.firstStepOptionPanel = new JXTaskPaneContainer();
        this.firstStepOptionPanel.add(this.createDelimSelectorPanel());
        this.firstStepOptionPanel.add(this.createDecimalSeparatorPanel());
        JScrollPane scroll = new JScrollPane(this.firstStepOptionPanel);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        this.setContent(scroll);
    }

    public void initializeSecondStep() {
        this.secondStepOptionPanel = new JXTaskPaneContainer();
        this.secondStepOptionPanel.add(this.getChipCountPanel());
        this.secondStepOptionPanel.add(this.createGuessTheRestPanel());
        this.secondStepOptionPanel.add(this.getFlagValuePanel());
        this.secondStepOptionPanel.add(this.createDataTrimmingPanel());
        JScrollPane scroll = new JScrollPane(this.secondStepOptionPanel);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        this.setContent(scroll);
    }

    private JPanel createDelimSelectorPanel() {
        int i;
        JXTaskPane delimPanel = new JXTaskPane();
        delimPanel.setLayout(new GridBagLayout());
        this.delimRadioButtons = new ArrayList<JRadioButton>();
        HashMap<String, JRadioButton> delimRadioButtonsByDelims = new HashMap<String, JRadioButton>();
        ButtonGroup delimGroup = new ButtonGroup();
        String[] selectorLabels = new String[Delimiter.values().length];
        String[] delimiters = new String[Delimiter.values().length];
        for (i = 0; i < Delimiter.values().length; ++i) {
            selectorLabels[i] = Delimiter.values()[i].getName();
            delimiters[i] = Delimiter.values()[i].toString();
        }
        for (i = 0; i < selectorLabels.length; ++i) {
            JRadioButton selector = new JRadioButton(selectorLabels[i]);
            selector.setActionCommand(delimiters[i]);
            selector.addActionListener(this);
            selector.setOpaque(false);
            delimGroup.add(selector);
            this.delimRadioButtons.add(selector);
            delimRadioButtonsByDelims.put(delimiters[i], selector);
        }
        this.customDelimRadioButton = new JRadioButton("Other:");
        this.customDelimRadioButton.addActionListener(this);
        this.customDelimRadioButton.setOpaque(false);
        delimGroup.add(this.customDelimRadioButton);
        this.delimRadioButtons.add(this.customDelimRadioButton);
        this.delimRadioButtons.get(0).setSelected(true);
        this.customDelimField = new JTextField(3);
        this.customDelimField.addCaretListener(this);
        this.customDelimField.setMargin(new Insets(2, 2, 2, 2));
        this.useCustomDelimButton = new JButton("Use");
        this.useCustomDelimButton.addActionListener(this);
        this.useCustomDelimButton.setEnabled(false);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        for (int i2 = 0; i2 < this.delimRadioButtons.size() - 1; ++i2) {
            delimPanel.add((Component)this.delimRadioButtons.get(i2), c);
            ++c.gridy;
        }
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        delimPanel.add((Component)this.customDelimRadioButton, c);
        c.gridx = 1;
        delimPanel.add((Component)this.customDelimField, c);
        ++c.gridx;
        delimPanel.add((Component)this.useCustomDelimButton, c);
        delimPanel.setTitle("Column Delimiter");
        return delimPanel;
    }

    private JPanel createDecimalSeparatorPanel() {
        JXTaskPane decimalSeparatorPanel = new JXTaskPane();
        decimalSeparatorPanel.setLayout(new GridBagLayout());
        ButtonGroup separatorGroup = new ButtonGroup();
        this.dotAsDecimalSeparatorRadioButton = new JRadioButton("Dot .");
        this.dotAsDecimalSeparatorRadioButton.setActionCommand(".");
        this.dotAsDecimalSeparatorRadioButton.addActionListener(this);
        this.dotAsDecimalSeparatorRadioButton.setOpaque(false);
        separatorGroup.add(this.dotAsDecimalSeparatorRadioButton);
        this.commaAsDecimalSeparatorRadioButton = new JRadioButton("Comma ,");
        this.commaAsDecimalSeparatorRadioButton.setActionCommand(",");
        this.commaAsDecimalSeparatorRadioButton.addActionListener(this);
        this.commaAsDecimalSeparatorRadioButton.setOpaque(false);
        separatorGroup.add(this.commaAsDecimalSeparatorRadioButton);
        this.dotAsDecimalSeparatorRadioButton.setSelected(true);
        this.screen.getConversionModel().setDecimalSeparator('.');
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.fill = 2;
        decimalSeparatorPanel.add((Component)this.dotAsDecimalSeparatorRadioButton, c);
        ++c.gridy;
        decimalSeparatorPanel.add((Component)this.commaAsDecimalSeparatorRadioButton, c);
        decimalSeparatorPanel.setTitle("Decimal Separator");
        return decimalSeparatorPanel;
    }

    private void setDelim(String delim) {
        block5: {
            this.screen.getConversionModel().setDelim(Delimiter.stringToDelim(delim));
            if (this.screen.getConversionModel().getDecimalSeparator() == this.screen.getConversionModel().getDelim().toString().charAt(0) && this.screen.getConversionModel().getDelim().toString().length() == 1) {
                JOptionPane.showMessageDialog(null, new JLabel("<html>You can't use the same character<br>as both the column delimiter and the<br>decimal separator!</html>"), "Error", 0);
                this.customDelimField.setForeground(Color.RED);
                this.useCustomDelimButton.setEnabled(false);
            } else {
                this.updateDelimeterPanel();
                try {
                    Pattern.compile(delim);
                    this.customDelimField.setForeground(Color.BLACK);
                    if (Delimiter.isCustom(delim)) {
                        this.useCustomDelimButton.setEnabled(true);
                    }
                }
                catch (PatternSyntaxException pse) {
                    this.customDelimField.setForeground(Color.RED);
                    if (!Delimiter.isCustom(delim)) break block5;
                    this.useCustomDelimButton.setEnabled(false);
                }
            }
        }
    }

    public ChipCountPanel getChipCountPanel() {
        if (this.chipCountPanel == null) {
            this.chipCountPanel = new ChipCountPanel(this.screen);
            this.chipCountPanel.setTitle("Chip counts");
            this.chipCountPanel.setToolTipText("Shows the count of selected columns of each type");
        }
        return this.chipCountPanel;
    }

    public FlagValuePanel getFlagValuePanel() {
        if (this.flagValuePanel == null) {
            this.flagValuePanel = new FlagValuePanel(this.screen);
            this.flagValuePanel.setTitle("Flag Modification");
            this.flagValuePanel.setEnabled(false);
            this.flagValuePanel.setToolTipText("Changes the values of flag column to P/M/A format");
        }
        return this.flagValuePanel;
    }

    private DataTrimmingPanel createDataTrimmingPanel() {
        DataTrimmingPanel dataTrimmingPanel = new DataTrimmingPanel(this.screen);
        this.screen.getConversionModel().addConversionChangeListener(dataTrimmingPanel);
        return dataTrimmingPanel;
    }

    private Component createGuessTheRestPanel() {
        JXTaskPane guessTheRestPanel = new JXTaskPane();
        guessTheRestPanel.setLayout(new BorderLayout());
        this.fillTheRestButton = new JButton("Complete the rest");
        guessTheRestPanel.add((Component)this.fillTheRestButton, "West");
        this.fillTheRestButton.addActionListener(this);
        guessTheRestPanel.setTitle("Complete with pattern");
        this.undoGuessButton = new JButton("Undo");
        this.undoGuessButton.addActionListener(this);
        this.undoGuessButton.setEnabled(false);
        guessTheRestPanel.add((Component)this.undoGuessButton, "East");
        return guessTheRestPanel;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JRadioButton) {
            JRadioButton button = (JRadioButton)source;
            if (this.delimRadioButtons.contains(button)) {
                if (button != this.customDelimRadioButton) {
                    this.setDelim(button.getActionCommand());
                    this.screen.updateTable(false);
                } else {
                    String customDelim = this.customDelimField.getText();
                    if (customDelim != null && customDelim.length() > 0) {
                        this.setDelim(customDelim);
                    }
                }
            } else if (button == this.dotAsDecimalSeparatorRadioButton || button == this.commaAsDecimalSeparatorRadioButton) {
                this.screen.getConversionModel().setDecimalSeparator(button.getActionCommand().charAt(0));
            }
        }
        if (source == this.fillTheRestButton) {
            ColumnTypePattern pattern = ColumnTypePattern.createColumnTypePatternFromAllColumns(this.screen.getColumnTypeManager().getColumns());
            this.screen.getColumnTypeManager().selectColumnsFromPattern(pattern, true, this.screen.getConversionModel().getCleanColumnTitles());
            this.undoGuessButton.setEnabled(true);
            this.screen.getTableFrame().getTable().repaint();
        }
        if (source == this.undoGuessButton) {
            this.screen.getColumnTypeManager().undoPatternSelection();
            this.undoGuessButton.setEnabled(false);
        }
        if (source == this.useCustomDelimButton) {
            this.screen.updateTable(false);
            this.useCustomDelimButton.setEnabled(false);
        }
    }

    public void caretUpdate(CaretEvent e) {
        Object source = e.getSource();
        if (source == this.customDelimField && this.customDelimRadioButton.isSelected()) {
            String customDelim = this.customDelimField.getText();
            if (customDelim != null && customDelim.length() > 0) {
                this.setDelim(customDelim);
            } else {
                this.customDelimField.setForeground(Color.BLACK);
            }
        }
    }

    public void updateDelimeterPanel() {
        char desimalSepatator = this.screen.getConversionModel().getDecimalSeparator();
        Delimiter delim = this.screen.getConversionModel().getDelim();
        if (desimalSepatator == '.') {
            this.dotAsDecimalSeparatorRadioButton.setSelected(true);
            this.commaAsDecimalSeparatorRadioButton.setSelected(false);
        } else {
            this.dotAsDecimalSeparatorRadioButton.setSelected(false);
            this.commaAsDecimalSeparatorRadioButton.setSelected(true);
        }
        this.commaAsDecimalSeparatorRadioButton.setEnabled(delim != Delimiter.COMMA);
        for (JRadioButton button : this.delimRadioButtons) {
            button.setSelected(button.getActionCommand().equals(delim.toString()));
        }
    }

    public void columnTypeChanged(ColumnTypeChangedEvent event) {
        logger.debug("columnTypeChanged");
        this.getChipCountPanel().updateAllKeyColumnCounters();
        if (event.getSource() instanceof ColumnTypeManager) {
            ColumnTypeManager typeManager = (ColumnTypeManager)event.getSource();
            if (typeManager.getCountOfType(ColumnType.FLAG_LABEL) > 0) {
                logger.debug("Flag columns found");
                this.flagValuePanel.setEnabled(true);
                this.flagValuePanel.updateFlagTrimmer();
            } else {
                logger.debug("Flag columns not found");
                this.flagValuePanel.setEnabled(false);
                this.flagValuePanel.updateFlagTrimmer();
            }
        }
    }

    public void chipNumberChanged(ChipNumberChangedEvent event) {
        this.getChipCountPanel().updateAllKeyColumnCounters();
    }

    public void chipCountChanged(ChipCountChangeEvent event) {
    }

    public void decimalSeparatorChanged(DecimalSeparatorChangedEvent e) {
    }

    public void delimiterChanged(DelimiterChangedEvent e) {
        this.setDelim(e.getNewValue().toString());
    }

    public void footerChanged(FooterChangedEvent e) {
    }

    public void headerChanged(HeaderChangedEvent e) {
    }

    public void titleRowChanged(TitleRowChangedEvent e) {
    }

    public void columnTitlesChanged(ColumnTitlesChangedEvent e) {
    }

    public void inputFileChanged(InputFileChangedEvent e) {
    }
}

