/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport.tools;

import fi.csc.microarray.client.dataimport.ImportScreen;
import fi.csc.microarray.client.dataimport.events.ColumnTitlesChangedEvent;
import fi.csc.microarray.client.dataimport.events.ConversionModelChangeListener;
import fi.csc.microarray.client.dataimport.events.DecimalSeparatorChangedEvent;
import fi.csc.microarray.client.dataimport.events.DelimiterChangedEvent;
import fi.csc.microarray.client.dataimport.events.FooterChangedEvent;
import fi.csc.microarray.client.dataimport.events.HeaderChangedEvent;
import fi.csc.microarray.client.dataimport.events.InputFileChangedEvent;
import fi.csc.microarray.client.dataimport.events.TitleRowChangedEvent;
import fi.csc.microarray.client.dataimport.table.ImportPreviewTable;
import fi.csc.microarray.client.dataimport.trimmer.NormalStringReplace;
import fi.csc.microarray.client.dataimport.trimmer.ReqularExpressionStringReplace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXTaskPane;

public class DataTrimmingPanel
extends JXTaskPane
implements ActionListener,
ListSelectionListener,
ConversionModelChangeListener {
    private static final String ALL_COLUMNS = "All";
    private JLabel columnLabel;
    private JLabel lookForLabel;
    private JLabel replaceWithLabel;
    private JTextField lookForField;
    private JTextField replaceWithField;
    private JCheckBox useRegexpsCheckBox;
    private JButton replaceButton;
    private JButton undoReplaceButton;
    private JComboBox columnCombobox;
    private ImportScreen screen;
    private ImportPreviewTable table;

    public DataTrimmingPanel(ImportScreen screen) {
        this.setLayout(new GridBagLayout());
        this.screen = screen;
        this.table = screen.getTableFrame().getTable();
        this.columnCombobox = new JComboBox();
        this.updateComboboxItems();
        this.columnLabel = new JLabel("Column:");
        this.lookForLabel = new JLabel("Look For:");
        this.replaceWithLabel = new JLabel("Replace With:");
        this.lookForField = new JTextField();
        this.lookForField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                if (DataTrimmingPanel.this.lookForField.getText().length() == 0) {
                    DataTrimmingPanel.this.replaceButton.setEnabled(false);
                } else {
                    DataTrimmingPanel.this.replaceButton.setEnabled(true);
                }
            }
        });
        this.replaceWithField = new JTextField();
        this.useRegexpsCheckBox = new JCheckBox("Use Regular Expressions");
        this.useRegexpsCheckBox.setPreferredSize(new Dimension(165, 18));
        this.useRegexpsCheckBox.setSelected(false);
        this.useRegexpsCheckBox.setOpaque(false);
        this.useRegexpsCheckBox.addActionListener(this);
        this.replaceButton = new JButton("Replace");
        this.replaceButton.addActionListener(this);
        this.replaceButton.setEnabled(false);
        this.undoReplaceButton = new JButton("Undo");
        this.undoReplaceButton.addActionListener(this);
        this.undoReplaceButton.setEnabled(false);
        GridBagConstraints c = new GridBagConstraints();
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 2;
        c.anchor = 18;
        c.fill = 2;
        this.add((Component)this.columnLabel, c);
        ++c.gridy;
        this.add((Component)this.columnCombobox, c);
        ++c.gridy;
        this.add((Component)this.lookForLabel, c);
        ++c.gridy;
        this.add((Component)this.lookForField, c);
        ++c.gridy;
        this.add((Component)this.replaceWithLabel, c);
        ++c.gridy;
        this.add((Component)this.replaceWithField, c);
        ++c.gridy;
        this.add((Component)this.useRegexpsCheckBox, c);
        c.gridwidth = 1;
        ++c.gridy;
        this.add((Component)this.replaceButton, c);
        ++c.gridx;
        this.add((Component)this.undoReplaceButton, c);
        this.setTitle("Data Modification");
    }

    private void updateComboboxItems() {
        String[] columnTitles = this.screen.getConversionModel().getColumnTitles();
        String[] columnTitlesNotTheFirst = new String[columnTitles.length];
        for (int i = 0; i < columnTitlesNotTheFirst.length - 1; ++i) {
            columnTitlesNotTheFirst[i] = columnTitles[i + 1];
        }
        columnTitlesNotTheFirst[columnTitles.length - 1] = ALL_COLUMNS;
        this.columnCombobox.setModel(new DefaultComboBoxModel<String>(columnTitlesNotTheFirst));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.replaceButton) {
            boolean allSelected = false;
            int columnIndex = -1;
            if (this.columnCombobox.getSelectedItem().toString().equals(ALL_COLUMNS)) {
                allSelected = true;
            } else {
                columnIndex = this.screen.getTableFrame().getTable().getColumnModel().getColumnIndex(this.columnCombobox.getSelectedItem().toString());
                allSelected = false;
            }
            if (this.useRegexpsCheckBox.isSelected()) {
                if (allSelected) {
                    this.screen.getDataTrimmer().pushOperation(new ReqularExpressionStringReplace(this.lookForField.getText(), this.replaceWithField.getText(), Integer.MAX_VALUE));
                } else {
                    this.screen.getDataTrimmer().pushOperation(new ReqularExpressionStringReplace(this.lookForField.getText(), this.replaceWithField.getText(), columnIndex));
                }
                this.table.repaint();
            } else if (allSelected) {
                this.screen.getDataTrimmer().pushOperation(new NormalStringReplace(this.lookForField.getText(), this.replaceWithField.getText(), false, Integer.MAX_VALUE));
            } else {
                this.screen.getDataTrimmer().pushOperation(new NormalStringReplace(this.lookForField.getText(), this.replaceWithField.getText(), false, columnIndex));
            }
            this.undoReplaceButton.setEnabled(true);
            this.table.repaint();
        } else if (e.getSource() == this.undoReplaceButton) {
            this.screen.getDataTrimmer().popOperation();
            if (this.screen.getDataTrimmer().getOperationCount() == 0) {
                this.undoReplaceButton.setEnabled(false);
            } else {
                this.undoReplaceButton.setEnabled(true);
            }
            this.table.repaint();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this.setEnabled(true);
    }

    public void decimalSeparatorChanged(DecimalSeparatorChangedEvent e) {
    }

    public void delimiterChanged(DelimiterChangedEvent e) {
    }

    public void footerChanged(FooterChangedEvent e) {
    }

    public void headerChanged(HeaderChangedEvent e) {
    }

    public void titleRowChanged(TitleRowChangedEvent e) {
        this.updateComboboxItems();
    }

    public void columnTitlesChanged(ColumnTitlesChangedEvent e) {
        this.updateComboboxItems();
    }

    public void inputFileChanged(InputFileChangedEvent e) {
    }
}

