/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.auth;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.auth.AuthenticationProvider;
import fi.csc.microarray.auth.JaasAuthenticationProvider;
import fi.csc.microarray.auth.SimpleFileLoginModule;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LoginTest {
    @Test
    public void expirationTest() throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
        String validUsername = "valid";
        String expiredUsername = "expired";
        String password = "password";
        File testPasswdFile = File.createTempFile("chipster-passwd-test", null);
        GregorianCalendar tomorrow = new GregorianCalendar();
        tomorrow.set(5, tomorrow.get(5) + 1);
        GregorianCalendar yesterday = new GregorianCalendar();
        yesterday.set(5, yesterday.get(5) - 1);
        PrintWriter pWriter = new PrintWriter(new BufferedWriter(new FileWriter(testPasswdFile)));
        pWriter.println(validUsername + ":password:" + SimpleFileLoginModule.EXPIRATION_DATE_FORMAT.format(tomorrow.getTime()));
        pWriter.println(expiredUsername + ":password:" + SimpleFileLoginModule.EXPIRATION_DATE_FORMAT.format(yesterday.getTime()));
        pWriter.close();
        File testJaasConfigFile = this.createTestJaasConfig(testPasswdFile);
        AuthenticationProvider authProvider = this.createAuthProvider(testJaasConfigFile);
        Assert.assertTrue(authProvider.authenticate(validUsername, password.toCharArray()));
        Assert.assertFalse(authProvider.authenticate(expiredUsername, password.toCharArray()));
    }

    public void manualTest() throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
        File usersFileToTest = new File("users");
        String username = "chipster";
        String password = "chipster";
        File testJaasConfigFile = this.createTestJaasConfig(usersFileToTest);
        AuthenticationProvider authProvider = this.createAuthProvider(testJaasConfigFile);
        Assert.assertTrue(authProvider.authenticate(username, password.toCharArray()));
    }

    private AuthenticationProvider createAuthProvider(File testJaasConfigFile) throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
        JaasAuthenticationProvider authProvider = new JaasAuthenticationProvider();
        System.setProperty("java.security.auth.login.config", testJaasConfigFile.getPath());
        return authProvider;
    }

    private File createTestJaasConfig(File testPasswdFile) throws IOException {
        File testJaasConfigFile = File.createTempFile("chipster-jaas-config-test", null);
        PrintWriter jWriter = new PrintWriter(new BufferedWriter(new FileWriter(testJaasConfigFile)));
        jWriter.println("Chipster {");
        jWriter.print("fi.csc.microarray.auth.SimpleFileLoginModule sufficient passwdFile=\"");
        jWriter.print(testPasswdFile.getPath());
        jWriter.println("\";");
        jWriter.println("};");
        jWriter.close();
        return testJaasConfigFile;
    }

    public void stressLoginTest() throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        int usernameMaxLength = 5;
        int passwordMaxLength = 5;
        int userCount = 200;
        int bruteCount = 100000;
        HashMap<String, String> users = new HashMap<String, String>();
        File testPasswdFile = File.createTempFile("chipster-passwd-test", null);
        PrintWriter pWriter = new PrintWriter(new BufferedWriter(new FileWriter(testPasswdFile)));
        for (int i = 0; i < userCount; ++i) {
            String username = this.getShortRandomString(usernameMaxLength);
            if (users.get(username) != null) continue;
            String password = this.getShortRandomString(passwordMaxLength);
            users.put(username, password);
            pWriter.println(username + ':' + password + this.getDescriptionColumn());
        }
        pWriter.close();
        File testJaasConfigFile = this.createTestJaasConfig(testPasswdFile);
        AuthenticationProvider authProvider = this.createAuthProvider(testJaasConfigFile);
        int successCount = 0;
        int failCount = 0;
        for (int i = 0; i < bruteCount; ++i) {
            String realPassword;
            String brutePassword;
            String bruteUsername = this.getShortRandomString(usernameMaxLength);
            if (authProvider.authenticate(bruteUsername, (brutePassword = this.getShortRandomString(passwordMaxLength)).toCharArray())) {
                realPassword = (String)users.get(bruteUsername);
                Assert.assertNotNull(realPassword);
                Assert.assertEquals(realPassword, brutePassword);
                ++successCount;
                continue;
            }
            realPassword = (String)users.get(bruteUsername);
            if (realPassword != null) {
                Assert.assertNotSame(realPassword, brutePassword);
            }
            ++failCount;
        }
        System.out.println("successful: " + successCount + ", failed: " + failCount);
    }

    @Test
    public void randomTest() {
        for (int i = 0; i < 100; ++i) {
            Assert.assertTrue(this.getShortRandomString(3).length() <= 3);
        }
    }

    private String getShortRandomString(int maxLength) {
        Random r = new Random();
        String longString = "";
        String result = "";
        boolean valid = false;
        while (!valid) {
            int length;
            longString = this.randomString();
            result = longString.substring(2, (length = r.nextInt(10000) % maxLength) + 1 + 2);
            if (result.indexOf(58) != -1) continue;
            valid = true;
        }
        return result;
    }

    private String randomString() {
        Random r = new Random();
        String token = Long.toString(Math.abs(r.nextLong()), 36);
        return token;
    }

    private String getDescriptionColumn() {
        String result = "";
        Random r = new Random();
        int choice = r.nextInt(2345) % 3;
        switch (choice) {
            case 0: {
                result = "";
                break;
            }
            case 1: {
                result = ":";
                break;
            }
            case 2: {
                result = ":" + this.randomString();
            }
        }
        return result;
    }

    public static void main(String[] args) throws IOException, ConfigurationLoader.OldConfigurationFormatException {
        new LoginTest().manualTest();
    }
}

