/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.analyser.AnalysisDescription;
import fi.csc.microarray.analyser.AnalysisJob;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.analyser.RetryException;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.util.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import org.apache.log4j.Logger;
import org.mortbay.util.IO;

public abstract class OnDiskAnalysisJobBase
extends AnalysisJob {
    private static final Logger logger = Logger.getLogger(OnDiskAnalysisJobBase.class);
    public static final int TIMEOUT = Integer.parseInt(MicroarrayConfiguration.getValue("analyser", "timeout_sec")) * 1000;
    protected File jobWorkDir;

    public void construct(JobMessage inputMessage, AnalysisDescription analysis, ResultCallback resultHandler) {
        super.construct(inputMessage, analysis, resultHandler);
        this.jobWorkDir = new File(resultHandler.getWorkDir(), this.getId());
    }

    protected void preExecute() throws Exception {
        this.cancelCheck();
        super.preExecute();
        this.updateStateDetail("transferring input data", true);
        if (!this.jobWorkDir.mkdir()) {
            throw new IOException("Could not create work dir: " + this.jobWorkDir.toString());
        }
        logger.debug("Starting to write input files.");
        for (String fileName : this.inputMessage.payloadNames()) {
            this.cancelCheck();
            logger.debug("Getting input file: " + fileName);
            URL inputURL = this.inputMessage.getPayloadURL(fileName);
            int maxWaitTime = 5120;
            int waitTime = 10;
            HttpURLConnection connection = (HttpURLConnection)inputURL.openConnection();
            int responseCode = connection.getResponseCode();
            while (responseCode != 200 && waitTime <= maxWaitTime) {
                logger.info("Waiting for payload to become available.");
                waitTime *= 2;
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted while waiting for payload to become available.");
                }
                responseCode = connection.getResponseCode();
            }
            if (responseCode != 200) {
                throw new RetryException();
            }
            File outputFile = new File(this.jobWorkDir, fileName);
            BufferedInputStream input = new BufferedInputStream(this.inputMessage.getPayload(fileName));
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(outputFile));
            IO.copy(input, output);
            ((InputStream)input).close();
            ((OutputStream)output).flush();
            ((OutputStream)output).close();
            logger.debug("Input file created: " + outputFile.getName() + " " + outputFile.length());
        }
        logger.debug("input files written");
    }

    protected void postExecute() throws Exception {
        this.updateStateDetail("transferring output data", true);
        this.cancelCheck();
        List<String> outputFileNames = this.analysis.getOutputFiles();
        logger.debug("reading outputs of " + this.analysis.getFullName() + ", total of " + outputFileNames.size() + " outputfiles");
        for (String fileName : outputFileNames) {
            this.cancelCheck();
            File outputFile = new File(this.jobWorkDir, fileName);
            this.outputMessage.addPayload(fileName, new BufferedInputStream(new FileInputStream(outputFile)));
            logger.debug("Added output file " + fileName);
        }
        super.postExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() {
        try {
            if (this.resultHandler.shouldSweepWorkDir()) {
                Files.delTree(this.jobWorkDir);
            }
        }
        catch (Exception e) {
            logger.error("Error in cleanUp.", e);
        }
        finally {
            super.cleanUp();
        }
    }
}

