/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.ClientTestHelper;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.tasks.TaskEventListener;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.testng.annotations.Test;

public class ClientAnalysisTest
implements ClientTestHelper.TestImplementation {
    private HashMap<String, TestEnvironment> testCases = new HashMap();
    private ClientApplication app;

    public ClientAnalysisTest() {
        this.testCases.put("Normalisation / Affymetrix", TestEnvironment.KIDNEY4_NORMALIZED);
    }

    public void implementGUITest(ClientTestHelper.ShutdownCallback shutdownCallback) throws Exception {
        this.app = Session.getSession().getApplication();
        this.app.loadSnapshot(new File("examples/workspaces/kidney4-normalized"));
    }

    @Test
    public void runAnalysis() throws IOException, InterruptedException, ConfigurationLoader.OldConfigurationFormatException {
        MicroarrayConfiguration.loadConfiguration();
        new ClientTestHelper().runTest(new ClientAnalysisTest());
    }

    class TaskWaiter
    implements TaskEventListener {
        private Operation operation;

        public TaskWaiter(Operation operation) {
            this.operation = operation;
        }

        public void onStateChange(Task task, Task.State oldState, Task.State newState) {
            if (newState.isFinished()) {
                try {
                    System.out.println("Task finished: " + newState.toString());
                    ClientAnalysisTest.this.app.onFinishedTask(task, this.operation);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TestEnvironment {
        KIDNEY4_NORMALIZED("kidney4-normalized", new String[]{"normalized.tsv"});

        private String sessionFileName;
        private String[] selectedDataItemNames;

        private TestEnvironment(String sessionFileName, String[] selectedDataItemNames) {
            this.sessionFileName = sessionFileName;
            this.selectedDataItemNames = selectedDataItemNames;
        }

        public String getSessionFileName() {
            return this.sessionFileName;
        }

        public String[] getSelectedDataItemNames() {
            return this.selectedDataItemNames;
        }
    }
}

