/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.proxy;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.activemq.Service;
import org.apache.activemq.proxy.ProxyConnection;
import org.apache.activemq.transport.CompositeTransport;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportAcceptListener;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.util.ServiceStopper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProxyConnector
implements Service {
    private static final Log LOG = LogFactory.getLog(ProxyConnector.class);
    private TransportServer server;
    private URI bind;
    private URI remote;
    private URI localUri;
    private String name;
    private CopyOnWriteArrayList<ProxyConnection> connections = new CopyOnWriteArrayList();

    public void start() throws Exception {
        this.getServer().setAcceptListener(new TransportAcceptListener(){

            public void onAccept(Transport localTransport) {
                try {
                    Transport remoteTransport = ProxyConnector.this.createRemoteTransport();
                    ProxyConnection connection = new ProxyConnection(localTransport, remoteTransport);
                    ProxyConnector.this.connections.add(connection);
                    connection.start();
                }
                catch (Exception e) {
                    this.onAcceptError(e);
                }
            }

            public void onAcceptError(Exception error) {
                LOG.error("Could not accept connection: " + error, error);
            }
        });
        this.getServer().start();
        LOG.info("Proxy Connector " + this.getName() + " Started");
    }

    public void stop() throws Exception {
        ServiceStopper ss = new ServiceStopper();
        if (this.server != null) {
            ss.stop(this.server);
        }
        Iterator<ProxyConnection> iter = this.connections.iterator();
        while (iter.hasNext()) {
            LOG.info("Connector stopped: Stopping proxy.");
            ss.stop(iter.next());
        }
        ss.throwFirstException();
        LOG.info("Proxy Connector " + this.getName() + " Stopped");
    }

    public URI getLocalUri() {
        return this.localUri;
    }

    public void setLocalUri(URI localURI) {
        this.localUri = localURI;
    }

    public URI getBind() {
        return this.bind;
    }

    public void setBind(URI bind) {
        this.bind = bind;
    }

    public URI getRemote() {
        return this.remote;
    }

    public void setRemote(URI remote) {
        this.remote = remote;
    }

    public TransportServer getServer() throws IOException, URISyntaxException {
        if (this.server == null) {
            this.server = this.createServer();
        }
        return this.server;
    }

    public void setServer(TransportServer server) {
        this.server = server;
    }

    protected TransportServer createServer() throws IOException, URISyntaxException {
        if (this.bind == null) {
            throw new IllegalArgumentException("You must specify either a server or the bind property");
        }
        return TransportFactory.bind(null, this.bind);
    }

    private Transport createRemoteTransport() throws Exception {
        Transport transport = TransportFactory.compositeConnect(this.remote);
        CompositeTransport ct = transport.narrow(CompositeTransport.class);
        if (ct != null && this.localUri != null) {
            ct.add(new URI[]{this.localUri});
        }
        transport = new TransportFilter(transport){

            public void stop() throws Exception {
                LOG.info("Stopping proxy.");
                super.stop();
                ProxyConnector.this.connections.remove(this);
            }
        };
        return transport;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.server != null ? this.server.getConnectURI().toString() : "proxy";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

