/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.ServiceStopper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapNetworkConnector
extends NetworkConnector {
    private static final Log LOG = LogFactory.getLog(LdapNetworkConnector.class);
    private static final String REQUIRED_OBJECT_CLASS_FILTER = "(&(objectClass=ipHost)(objectClass=ipService))";
    private URI ldapURI;
    private String ldapBase;
    private String ldapUser;
    private String ldapPassword;
    private int ldapSearchScope = 0;
    private String ldapSearchFilter = "(&(objectClass=ipHost)(objectClass=ipService))";
    private DirContext ldapContext;
    private List<NetworkConnector> connectors = new CopyOnWriteArrayList<NetworkConnector>();

    public void setUri(URI uri) {
        this.ldapURI = uri;
    }

    public void setBase(String base) {
        this.ldapBase = base;
    }

    public void setUser(String user) {
        this.ldapUser = user;
    }

    @Override
    public void setPassword(String password) {
        this.ldapPassword = password;
    }

    public void setSearchScope(String searchScope) throws Exception {
        if (searchScope.equals("OBJECT_SCOPE")) {
            this.ldapSearchScope = 0;
        } else if (searchScope.equals("ONELEVEL_SCOPE")) {
            this.ldapSearchScope = 1;
        } else if (searchScope.equals("SUBTREE_SCOPE")) {
            this.ldapSearchScope = 2;
        } else {
            throw new Exception("ERR: unknown LDAP search scope specified: " + searchScope);
        }
    }

    public void setSearchFilter(String searchFilter) {
        this.ldapSearchFilter = "(&(&(objectClass=ipHost)(objectClass=ipService))(" + searchFilter + "))";
    }

    @Override
    protected void handleStart() throws Exception {
        this.initLdapContext();
        for (URI uri : this.getLdapUris()) {
            NetworkConnector connector = this.getBrokerService().addNetworkConnector(uri);
            connector.start();
            this.connectors.add(connector);
        }
        super.handleStart();
    }

    @Override
    protected void handleStop(ServiceStopper stopper) throws Exception {
        for (NetworkConnector connector : this.connectors) {
            this.getBrokerService().removeNetworkConnector(connector);
            connector.stop();
        }
        this.ldapContext.close();
        super.handleStop(stopper);
    }

    @Override
    public String getName() {
        return this.toString();
    }

    protected void initLdapContext() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapURI.toString());
        env.put("java.naming.security.principal", this.ldapUser);
        env.put("java.naming.security.credentials", this.ldapPassword);
        this.ldapContext = new InitialDirContext(env);
    }

    protected List<URI> getLdapUris() throws Exception {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(this.ldapSearchScope);
        NamingEnumeration<SearchResult> results = this.ldapContext.search(this.ldapBase, this.ldapSearchFilter, controls);
        ArrayList<URI> uriList = new ArrayList<URI>();
        while (results.hasMore()) {
            Attributes attributes = results.next().getAttributes();
            String address = (String)attributes.get("iphostnumber").get();
            String port = (String)attributes.get("ipserviceport").get();
            String protocol = (String)attributes.get("ipserviceprotocol").get();
            URI uri = new URI("static:(" + protocol + "://" + address + ":" + port + ")");
            LOG.info("Discovered URI " + uri);
            uriList.add(uri);
        }
        return uriList;
    }
}

