/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.security.SecureSocketFactory;
import org.h2.util.MathUtils;

public class NetUtils {
    private static InetAddress bindAddress;
    static /* synthetic */ Class class$org$h2$util$NetUtils;

    private NetUtils() {
    }

    public static Socket createLoopbackSocket(int n, boolean bl) throws IOException {
        InetAddress inetAddress = NetUtils.getBindAddress();
        if (inetAddress == null) {
            inetAddress = InetAddress.getLocalHost();
        }
        return NetUtils.createSocket(inetAddress.getHostAddress(), n, bl);
    }

    public static Socket createSocket(String string, int n, boolean bl) throws IOException {
        int n2 = n;
        int n3 = string.startsWith("[") ? string.indexOf(93) : 0;
        int n4 = string.indexOf(58, n3);
        if (n4 >= 0) {
            n2 = MathUtils.decodeInt(string.substring(n4 + 1));
            string = string.substring(0, n4);
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        return NetUtils.createSocket(inetAddress, n2, bl);
    }

    public static Socket createSocket(InetAddress inetAddress, int n, boolean bl) throws IOException {
        if (bl) {
            return SecureSocketFactory.createSocket(inetAddress, n);
        }
        return new Socket(inetAddress, n);
    }

    public static ServerSocket createServerSocket(int n, boolean bl) throws SQLException {
        try {
            return NetUtils.createServerSocketTry(n, bl);
        }
        catch (SQLException sQLException) {
            return NetUtils.createServerSocketTry(n, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress getBindAddress() throws UnknownHostException {
        String string = SysProperties.BIND_ADDRESS;
        if (string == null || string.length() == 0) {
            return null;
        }
        Class clazz = class$org$h2$util$NetUtils == null ? (class$org$h2$util$NetUtils = NetUtils.class$("org.h2.util.NetUtils")) : class$org$h2$util$NetUtils;
        synchronized (clazz) {
            if (bindAddress == null) {
                bindAddress = InetAddress.getByName(string);
            }
        }
        return bindAddress;
    }

    private static ServerSocket createServerSocketTry(int n, boolean bl) throws SQLException {
        try {
            InetAddress inetAddress = NetUtils.getBindAddress();
            if (bl) {
                return SecureSocketFactory.createServerSocket(n, inetAddress);
            }
            if (inetAddress == null) {
                return new ServerSocket(n);
            }
            return new ServerSocket(n, 0, inetAddress);
        }
        catch (BindException bindException) {
            throw Message.getSQLException(90061, new String[]{"" + n, bindException.toString()}, bindException);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, "port: " + n + " ssl: " + bl);
        }
    }

    public static boolean isLoopbackAddress(Socket socket) {
        boolean bl = true;
        bl = socket.getInetAddress().isLoopbackAddress();
        return bl;
    }

    public static ServerSocket closeSilently(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getLocalAddress() {
        InetAddress inetAddress = null;
        try {
            inetAddress = NetUtils.getBindAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return inetAddress == null ? "localhost" : inetAddress.getHostAddress();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

