/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect;

import org.fest.reflect.ReflectionError;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Field<T> {
    private final Object target;
    private final java.lang.reflect.Field field;
    private final boolean accessible;

    Field(String fieldName, Object target) {
        this.target = target;
        if (target == null) {
            throw new IllegalArgumentException("Target should not be null");
        }
        Class<?> type = target.getClass();
        this.field = this.lookupInClassHierarchy(fieldName, type);
        this.accessible = this.field.isAccessible();
    }

    private java.lang.reflect.Field lookupInClassHierarchy(String fieldName, Class<?> targetType) {
        java.lang.reflect.Field field = null;
        for (Class<?> type = targetType; type != null && (field = Field.field(fieldName, type)) == null; type = type.getSuperclass()) {
        }
        if (field == null) {
            throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to find field ", Strings.quote((String)fieldName), " in class ", targetType.getName()}));
        }
        return field;
    }

    private static java.lang.reflect.Field field(String fieldName, Class<?> targetType) {
        try {
            return targetType.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void assertIsInstanceOf(Class<T> expected, String fieldName) {
        this.field.setAccessible(true);
        Class<?> fieldType = this.field.getType();
        if (!expected.isAssignableFrom(fieldType)) {
            throw new ReflectionError(Strings.concat((Object[])new Object[]{"The field ", Strings.quote((String)fieldName), " should be of type <", expected.getName(), "> but was <", fieldType.getName(), ">"}));
        }
        this.field.setAccessible(this.accessible);
    }

    public void set(T value) {
        try {
            this.field.setAccessible(true);
            this.field.set(this.target, value);
        }
        catch (Exception e) {
            throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to update the value in field ", Strings.quote((String)this.field.getName())}), e);
        }
        finally {
            this.field.setAccessible(this.accessible);
        }
    }

    public T get() {
        try {
            this.field.setAccessible(true);
            Object object = this.field.get(this.target);
            return (T)object;
        }
        catch (Exception e) {
            throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to obtain the value in field " + Strings.quote((String)this.field.getName())}), e);
        }
        finally {
            this.field.setAccessible(this.accessible);
        }
    }

    public java.lang.reflect.Field info() {
        return this.field;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldType<T> {
        private final Class<T> type;
        private final FieldName fieldName;

        FieldType(Class<T> type, FieldName fieldName) {
            this.type = type;
            this.fieldName = fieldName;
        }

        public Field<T> in(Object target) {
            Field field = new Field(this.fieldName.name, target);
            field.assertIsInstanceOf(this.type, this.fieldName.name);
            return field;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldName {
        private final String name;

        FieldName(String name) {
            this.name = name;
        }

        public <T> FieldType<T> ofType(Class<T> type) {
            return new FieldType<T>(type, this);
        }
    }
}

