/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.i18n.Strings;
import abbot.tester.ActionFailedException;
import abbot.tester.ComponentLocation;
import abbot.tester.ComponentTester;
import abbot.tester.ListLocation;
import abbot.tester.LocationUnavailableException;
import abbot.util.Properties;
import abbot.util.WeakAWTEventListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.List;
import java.awt.Point;
import java.awt.event.AWTEventListener;
import java.awt.event.ItemEvent;

public class ListTester
extends ComponentTester {
    private int LIST_DELAY = Properties.getProperty("abbot.tester.list_delay", 30000, 0, 60000);

    public void actionSelectIndex(Component c, int index) {
        this.actionSelectRow(c, new ListLocation(index));
    }

    public void actionSelectRow(Component c, ListLocation location) {
        List list = (List)c;
        try {
            int index = location.getIndex(list);
            if (index < 0 || index >= list.getItemCount()) {
                String msg = Strings.get("tester.JList.invalid_index", new Object[]{new Integer(index)});
                throw new ActionFailedException(msg);
            }
            if (list.getSelectedIndex() != index) {
                this.setSelected(list, index, true);
            }
        }
        catch (LocationUnavailableException e) {
            this.actionClick(c, location);
        }
    }

    protected void setSelected(List list, int index, boolean selected) {
        Listener listener = new Listener(index, selected);
        new WeakAWTEventListener(listener, 512L);
        list.select(index);
        ItemEvent ie = new ItemEvent(list, 701, list.getSelectedItem(), selected ? 1 : 2);
        this.postEvent(list, ie);
        long now = System.currentTimeMillis();
        while (listener.selected != selected) {
            if (System.currentTimeMillis() - now > (long)this.LIST_DELAY) {
                throw new ActionFailedException("List didn't fire for index " + index + " selection");
            }
            this.sleep();
        }
        this.waitForIdle();
    }

    public ComponentLocation parseLocation(String encoded) {
        return new ListLocation().parse(encoded);
    }

    public ComponentLocation getLocation(Component c, Point p) {
        throw new RuntimeException("List locations must be manually generated");
    }

    private class Listener
    implements AWTEventListener {
        public volatile boolean selected;
        private int targetIndex = -1;

        public Listener(int index, boolean state) {
            this.targetIndex = index;
            this.selected = !state;
        }

        public void eventDispatched(AWTEvent e) {
            if (e.getID() == 701 && e.getSource() instanceof List && ((List)e.getSource()).getSelectedIndex() == this.targetIndex) {
                this.selected = ((ItemEvent)e).getStateChange() == 1;
            }
        }
    }
}

