/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.WaitTimedOutError;
import abbot.i18n.Strings;
import abbot.script.ArgumentParser;
import abbot.script.Condition;
import abbot.tester.ActionFailedException;
import abbot.tester.ComponentLocation;
import abbot.tester.JComponentTester;
import abbot.tester.JTreeLocation;
import abbot.tester.LocationUnavailableException;
import abbot.util.AWT;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;

public class JTreeTester
extends JComponentTester {
    static /* synthetic */ Class class$javax$swing$tree$TreePath;
    static /* synthetic */ Class class$javax$swing$plaf$basic$BasicTreeUI;

    public static boolean isLocationInExpandControl(JTree tree, int x, int y) {
        int row = tree.getRowForLocation(x, y);
        if (row == -1 && (row = tree.getClosestRowForLocation(x, y)) != -1) {
            Rectangle rect = tree.getRowBounds(row);
            if (row == tree.getRowCount() - 1 && y >= rect.y + rect.height) {
                return false;
            }
            TreePath path = tree.getPathForRow(row);
            if (path == null || tree.getModel().isLeaf(path.getLastPathComponent())) {
                return false;
            }
            if (tree.getUI() instanceof BasicTreeUI) {
                try {
                    Method method = (class$javax$swing$plaf$basic$BasicTreeUI == null ? (class$javax$swing$plaf$basic$BasicTreeUI = JTreeTester.class$("javax.swing.plaf.basic.BasicTreeUI")) : class$javax$swing$plaf$basic$BasicTreeUI).getDeclaredMethod("isLocationInExpandControl", class$javax$swing$tree$TreePath == null ? (class$javax$swing$tree$TreePath = JTreeTester.class$("javax.swing.tree.TreePath")) : class$javax$swing$tree$TreePath, Integer.TYPE, Integer.TYPE);
                    method.setAccessible(true);
                    Object b = method.invoke((Object)tree.getUI(), path, new Integer(x), new Integer(y));
                    return b.equals(Boolean.TRUE);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            String msg = "Can't determine location of tree expansion control for " + tree.getUI();
            throw new RuntimeException(msg);
        }
        return false;
    }

    public static String valueToString(JTree tree, TreePath path) {
        return JTreeTester.valueToString(tree, path, true);
    }

    private static String valueToString(JTree tree, TreePath path, boolean includeIndex) {
        TreePath parentPath;
        Object value = path.getLastPathComponent();
        int row = tree.getRowForPath(path);
        Component cr = tree.getCellRenderer().getTreeCellRendererComponent(tree, value, false, tree.isExpanded(row), tree.getModel().isLeaf(value), row, false);
        String string = null;
        if (cr instanceof JLabel) {
            String label = ((JLabel)cr).getText();
            if (label != null) {
                label = label.trim();
            }
            if (!"".equals(label) && !ArgumentParser.isDefaultToString(label)) {
                string = label;
            }
        }
        if (string == null && ArgumentParser.isDefaultToString(string = tree.convertValueToText(value, false, tree.isExpanded(row), tree.getModel().isLeaf(value), row, false))) {
            string = null;
        }
        if (string == null) {
            String s = ArgumentParser.toString(value);
            String string2 = string = s == "<default-tostring>" ? null : s;
        }
        if (includeIndex && (parentPath = path.getParentPath()) != null) {
            Object parent = parentPath.getLastPathComponent();
            int idx = tree.getModel().getIndexOfChild(parent, value);
            int count = 0;
            for (int i = 0; i < idx; ++i) {
                Object child = tree.getModel().getChild(parent, i);
                TreePath childPath = parentPath.pathByAddingChild(child);
                String text = JTreeTester.valueToString(tree, childPath, false);
                if (!string.equals(text)) continue;
                ++count;
            }
            if (count > 0) {
                string = string + "[" + count + "]";
            }
        }
        return string;
    }

    public static TreePath pathToStringPath(JTree tree, TreePath path) {
        if (path == null) {
            return null;
        }
        String string = JTreeTester.valueToString(tree, path);
        if (string != null) {
            if (path.getPathCount() > 1) {
                TreePath parent = JTreeTester.pathToStringPath(tree, path.getParentPath());
                if (parent == null) {
                    return null;
                }
                return parent.pathByAddingChild(string);
            }
            return new TreePath(string);
        }
        return null;
    }

    public void actionClick(Component c, ComponentLocation loc) {
        TreePath path;
        if (loc instanceof JTreeLocation && (path = ((JTreeLocation)loc).getPath((JTree)c)) != null) {
            this.makeVisible(c, path);
        }
        super.actionClick(c, loc);
    }

    public void actionSelectRow(Component c, ComponentLocation loc) {
        JTree tree = (JTree)c;
        if (loc instanceof JTreeLocation) {
            TreePath path = ((JTreeLocation)loc).getPath((JTree)c);
            if (path == null) {
                String msg = Strings.get("tester.JTree.path_not_found", new Object[]{loc});
                throw new LocationUnavailableException(msg);
            }
            this.makeVisible(c, path);
        }
        Point where = loc.getPoint(c);
        int row = tree.getRowForLocation(where.x, where.y);
        if (tree.getLeadSelectionRow() != row || tree.getSelectionCount() != 1) {
            Rectangle rect = tree.getRowBounds(row);
            this.actionClick((Component)tree, rect.x + 1, rect.y + rect.height / 2);
        }
    }

    public void actionSelectRow(Component tree, int row) {
        this.actionSelectRow(tree, new JTreeLocation(row));
    }

    public void actionClickRow(Component tree, int row) {
        this.actionClick(tree, new JTreeLocation(row));
    }

    public void actionClickRow(Component tree, int row, String modifiers) {
        this.actionClick(tree, new JTreeLocation(row), AWT.getModifiers(modifiers));
    }

    public void actionClickRow(Component c, int row, String modifiers, int count) {
        this.actionClick(c, (ComponentLocation)new JTreeLocation(row), AWT.getModifiers(modifiers), count);
    }

    protected boolean makeVisible(Component c, TreePath path) {
        return this.makeVisible(c, path, false);
    }

    private boolean makeVisible(Component c, final TreePath path, boolean expandWhenFound) {
        final JTree tree = (JTree)c;
        boolean changed = false;
        if (path.getPathCount() > 1 && (changed = this.makeVisible(c, path.getParentPath(), true))) {
            this.waitForIdle();
        }
        final TreePath realPath = JTreeLocation.findMatchingPath(tree, path);
        if (expandWhenFound) {
            if (!tree.isExpanded(realPath)) {
                this.invokeAndWait(new Runnable(){

                    public void run() {
                        tree.expandPath(realPath);
                    }
                });
            }
            final Object o = realPath.getLastPathComponent();
            try {
                this.wait(new Condition(){

                    public boolean test() {
                        return tree.getModel().getChildCount(o) != 0;
                    }

                    public String toString() {
                        return Strings.get("tester.Component.show_wait", new Object[]{path.toString()});
                    }
                }, (long)componentDelay);
                changed = true;
            }
            catch (WaitTimedOutError e) {
                throw new LocationUnavailableException(e.getMessage());
            }
        }
        return changed;
    }

    public void actionMakeVisible(Component c, TreePath path) {
        this.makeVisible(c, path);
    }

    public void actionSelectPath(Component c, TreePath path) {
        this.actionSelectRow(c, new JTreeLocation(path));
    }

    public void actionToggleRow(Component c, int row) {
        this.actionToggleRow(c, new JTreeLocation(row));
    }

    public void actionToggleRow(Component c, ComponentLocation loc) {
        JTree tree = (JTree)c;
        if (tree.getToggleClickCount() != 0) {
            this.actionClick((Component)tree, loc, 16, tree.getToggleClickCount());
        } else {
            if (!(tree.getUI() instanceof BasicTreeUI)) {
                throw new ActionFailedException("Can't toggle row for " + tree.getUI());
            }
            try {
                Method method = (class$javax$swing$plaf$basic$BasicTreeUI == null ? (class$javax$swing$plaf$basic$BasicTreeUI = JTreeTester.class$("javax.swing.plaf.basic.BasicTreeUI")) : class$javax$swing$plaf$basic$BasicTreeUI).getDeclaredMethod("toggleExpandState", class$javax$swing$tree$TreePath == null ? (class$javax$swing$tree$TreePath = JTreeTester.class$("javax.swing.tree.TreePath")) : class$javax$swing$tree$TreePath);
                method.setAccessible(true);
                Point where = loc.getPoint(tree);
                method.invoke((Object)tree.getUI(), tree.getPathForLocation(where.x, where.y));
            }
            catch (Exception e) {
                throw new ActionFailedException(e.toString());
            }
        }
    }

    public boolean assertPathExists(Component tree, TreePath path) {
        try {
            this.makeVisible(tree, path);
            return true;
        }
        catch (LocationUnavailableException e) {
            return false;
        }
    }

    public ComponentLocation parseLocation(String encoded) {
        return new JTreeLocation().parse(encoded);
    }

    public ComponentLocation getLocation(Component c, Point p) {
        JTree tree = (JTree)c;
        if (tree.getRowCount() == 0) {
            return new JTreeLocation(p);
        }
        Rectangle rect = tree.getRowBounds(tree.getRowCount() - 1);
        int maxY = rect.y + rect.height;
        if (p.y > maxY) {
            return new JTreeLocation(p);
        }
        TreePath path = tree.getClosestPathForLocation(p.x, p.y);
        TreePath stringPath = JTreeTester.pathToStringPath(tree, path);
        if (stringPath != null) {
            if (!tree.isRootVisible()) {
                Object[] objs = stringPath.getPath();
                Object[] subs = new Object[objs.length - 1];
                System.arraycopy(objs, 1, subs, 0, subs.length);
                stringPath = new TreePath(subs);
            }
            return new JTreeLocation(stringPath);
        }
        int row = tree.getClosestRowForLocation(p.x, p.y);
        if (row != -1) {
            return new JTreeLocation(row);
        }
        return new JTreeLocation(p);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

