/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.Log;
import abbot.i18n.Strings;
import abbot.tester.ComponentLocation;
import abbot.tester.LocationUnavailableException;
import abbot.util.ExtendedComparator;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;

public class JTabbedPaneLocation
extends ComponentLocation {
    private String tabName = null;
    private int index = -1;

    public JTabbedPaneLocation() {
    }

    public JTabbedPaneLocation(String tabName) {
        this.tabName = tabName;
    }

    public JTabbedPaneLocation(int index) {
        if (index < 0) {
            String msg = Strings.get("tester.JTabbedPane.invalid_index", new Object[]{new Integer(index)});
            throw new LocationUnavailableException(msg);
        }
        this.index = index;
    }

    public JTabbedPaneLocation(Point p) {
        super(p);
    }

    protected String badFormat(String encoded) {
        return Strings.get("location.tab.bad_format", new Object[]{encoded});
    }

    private Point indexToPoint(JTabbedPane tabs, int index) {
        if (index < 0 || index >= tabs.getTabCount()) {
            String msg = Strings.get("tester.JTabbedPane.invalid_index", new Object[]{new Integer(index)});
            throw new LocationUnavailableException(msg);
        }
        Log.debug("converting index " + index);
        TabbedPaneUI ui = tabs.getUI();
        Rectangle rect = ui.getTabBounds(tabs, index);
        if (rect == null || rect.x < 0) {
            throw new TabNotVisibleException(index);
        }
        return new Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
    }

    private int tabNameToIndex(JTabbedPane tabs, String name) {
        for (int i = 0; i < tabs.getTabCount(); ++i) {
            String value = tabs.getTitleAt(i);
            if (!ExtendedComparator.stringsMatch(name, value)) continue;
            return i;
        }
        return -1;
    }

    public Point getPoint(Component c) {
        JTabbedPane tabs = (JTabbedPane)c;
        int idx = this.index;
        if (this.tabName != null && (idx = this.tabNameToIndex(tabs, this.tabName)) == -1) {
            String msg = Strings.get("tester.JTabbedPane.invalid_name", new Object[]{this.tabName});
            throw new LocationUnavailableException(msg);
        }
        if (idx != -1) {
            return this.indexToPoint(tabs, idx);
        }
        return super.getPoint(tabs);
    }

    public Rectangle getBounds(Component c) {
        JTabbedPane tabs = (JTabbedPane)c;
        TabbedPaneUI ui = tabs.getUI();
        Point p = this.getPoint(tabs);
        int idx = ui.tabForCoordinate(tabs, p.x, p.y);
        if (idx != -1) {
            Rectangle bounds = ui.getTabBounds(tabs, idx);
            if (bounds == null) {
                throw new TabNotVisibleException(idx);
            }
            return bounds;
        }
        return super.getBounds(c);
    }

    public boolean equals(Object o) {
        if (o instanceof JTabbedPaneLocation) {
            JTabbedPaneLocation loc = (JTabbedPaneLocation)o;
            if (this.tabName != null) {
                return this.tabName.equals(loc.tabName);
            }
            if (this.index != -1) {
                return this.index == loc.index;
            }
        }
        return super.equals(o);
    }

    public String toString() {
        if (this.tabName != null) {
            return this.encodeValue(this.tabName);
        }
        if (this.index != -1) {
            return this.encodeIndex(this.index);
        }
        return super.toString();
    }

    public ComponentLocation parse(String encoded) {
        if (this.isValue(encoded = encoded.trim())) {
            this.tabName = this.parseValue(encoded);
            return this;
        }
        if (this.isIndex(encoded)) {
            this.index = this.parseIndex(encoded);
            return this;
        }
        return super.parse(encoded);
    }

    class TabNotVisibleException
    extends LocationUnavailableException {
        public int index;

        public TabNotVisibleException(int index) {
            super("Tab " + index + " not visible");
            this.index = index;
        }
    }
}

