/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.Log;
import abbot.i18n.Strings;
import abbot.script.ArgumentParser;
import abbot.tester.ActionFailedException;
import abbot.tester.ComponentLocation;
import abbot.tester.JComponentTester;
import abbot.tester.JListLocation;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;

public class JListTester
extends JComponentTester {
    public static String valueToString(JList list, int index) {
        Object value = list.getModel().getElementAt(index);
        Component cr = list.getCellRenderer().getListCellRendererComponent(list, value, index, false, false);
        String string = null;
        if (cr instanceof JLabel) {
            string = ((JLabel)cr).getText();
            if (string != null) {
                string = string.trim();
            }
            if (!"".equals(string) && !ArgumentParser.isDefaultToString(string)) {
                return string;
            }
        }
        return (string = ArgumentParser.toString(value)) == "<default-tostring>" ? null : string;
    }

    public Object getElementAt(JList list, int index) {
        return list.getModel().getElementAt(index);
    }

    public int getSize(JList list) {
        return list.getModel().getSize();
    }

    public String[] getContents(JList list) {
        ListModel model = list.getModel();
        String[] values = new String[model.getSize()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = model.getElementAt(i).toString();
        }
        return values;
    }

    public void actionSelectIndex(Component c, int index) {
        this.actionSelectRow(c, new JListLocation(index));
    }

    public void actionSelectItem(Component c, String item) {
        this.actionSelectRow(c, new JListLocation(item));
    }

    public void actionSelectValue(Component c, String value) {
        this.actionSelectRow(c, new JListLocation(value));
    }

    public void actionSelectRow(Component c, JListLocation location) {
        JList list = (JList)c;
        int index = location.getIndex(list);
        if (index < 0 || index >= list.getModel().getSize()) {
            String msg = Strings.get("tester.JList.invalid_index", new Object[]{new Integer(index)});
            throw new ActionFailedException(msg);
        }
        if (list.getSelectedIndex() != index) {
            Log.debug("Click on index=" + index);
            super.actionClick(c, location);
        }
    }

    public ComponentLocation parseLocation(String encoded) {
        return new JListLocation().parse(encoded);
    }

    public ComponentLocation getLocation(Component c, Point p) {
        JList list = (JList)c;
        int index = list.locationToIndex(p);
        String value = JListTester.valueToString(list, index);
        if (value != null) {
            return new JListLocation(value);
        }
        if (index != -1) {
            return new JListLocation(index);
        }
        return new JListLocation(p);
    }
}

