/*
 * Decompiled with CFR 0.152.
 */
package abbot.i18n;

import abbot.Log;
import abbot.editor.widgets.TextFormat;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Strings {
    public static final String TOOLTIP_SUFFIX = ".tip";
    public static final String DIALOG_SUFFIX = ".dlg";
    private static final String PREFIX = (class$abbot$i18n$Strings == null ? (class$abbot$i18n$Strings = Strings.class$("abbot.i18n.Strings")) : class$abbot$i18n$Strings).getPackage().getName() + ".";
    private static final String CORE_BUNDLE = "abbot";
    private static List bundles = new ArrayList();
    static /* synthetic */ Class class$abbot$i18n$Strings;

    public static ResourceBundle addBundle(String name) throws MissingResourceException {
        return Strings.addBundle(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle addBundle(String name, ClassLoader cl) throws MissingResourceException {
        ResourceBundle b;
        boolean wrap;
        boolean bl = wrap = cl != null;
        if (cl == null) {
            cl = (class$abbot$i18n$Strings == null ? (class$abbot$i18n$Strings = Strings.class$("abbot.i18n.Strings")) : class$abbot$i18n$Strings).getClassLoader();
        }
        Locale locale = Locale.getDefault();
        try {
            b = ResourceBundle.getBundle(name, locale, cl);
            Log.debug("Added resource bundle " + name);
        }
        catch (MissingResourceException e) {
            try {
                b = ResourceBundle.getBundle(PREFIX + name, locale, cl);
                Log.debug("Added resource bundle " + PREFIX + name);
            }
            catch (MissingResourceException e2) {
                throw e;
            }
        }
        List list = bundles;
        synchronized (list) {
            bundles.add(0, wrap ? new WeakReference<ResourceBundle>(b) : b);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBundle(ResourceBundle b) {
        List list = bundles;
        synchronized (list) {
            bundles.add(0, b);
        }
    }

    private Strings() {
    }

    public static String get(String key) {
        return Strings.get(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String key, boolean optional) {
        String defaultValue = "#" + key + "#";
        String value = null;
        List list = bundles;
        synchronized (list) {
            ListIterator iter = bundles.listIterator(bundles.size());
            while (iter.hasPrevious()) {
                Object bundle = iter.previous();
                if (bundle instanceof WeakReference && (bundle = ((WeakReference)bundle).get()) == null) {
                    iter.remove();
                    continue;
                }
                try {
                    value = ((ResourceBundle)bundle).getString(key);
                }
                catch (MissingResourceException mre) {}
            }
        }
        if (value == null) {
            if (!optional) {
                Log.log("Missing resource '" + key + "'");
                value = defaultValue;
            }
        } else if (key.endsWith(TOOLTIP_SUFFIX)) {
            value = TextFormat.tooltip(value);
        } else if (key.endsWith(DIALOG_SUFFIX)) {
            value = TextFormat.dialog(value);
        }
        return value;
    }

    public static String get(String key, Object[] args) {
        return new MessageFormat(Strings.get(key)).format(args);
    }

    public static String get(String key, Object arg) {
        return Strings.get(key, new Object[]{arg});
    }

    public static String get(String key, Object arg1, Object arg2) {
        return Strings.get(key, new Object[]{arg1, arg2});
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Strings.addBundle(CORE_BUNDLE);
        }
        catch (MissingResourceException e) {
            String msg = "No resource bundle found in abbot";
            if (System.getProperty("java.class.path").indexOf("junit") != -1) {
                Log.warn(msg);
            }
            throw new Error(msg);
        }
    }
}

