/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.recorder;

import abbot.Log;
import abbot.editor.recorder.JComponentRecorder;
import abbot.script.Action;
import abbot.script.Assert;
import abbot.script.ComponentReference;
import abbot.script.Resolver;
import abbot.script.Step;
import abbot.util.AWT;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JInternalFrame;

public class JInternalFrameRecorder
extends JComponentRecorder {
    private JInternalFrame frame;
    private String type;
    private static final String UNKNOWN = "unknown";
    private static final String SHOW = "show";
    private static final String HIDE = "hide";
    private static final String CLOSE = "close";
    private static final String ICONIFY = "iconify";
    private static final String DEICONIFY = "deiconify";
    private static final String MOVE = "move";
    private static final String RESIZE = "resize";
    public static final int SE_INTERNAL_FRAME = 21;
    public static final int SE_DECORATION = 22;
    static /* synthetic */ Class class$abbot$tester$ComponentTester;
    static /* synthetic */ Class class$javax$swing$JInternalFrame;

    public JInternalFrameRecorder(Resolver resolver) {
        super(resolver);
    }

    protected void init(int rtype) {
        super.init(rtype);
        this.frame = null;
        this.type = UNKNOWN;
    }

    public boolean accept(AWTEvent event) {
        int id = event.getID();
        Log.debug("Source is " + event.getSource());
        if (event.getSource() instanceof JInternalFrame) {
            if (id == 102 || id == 103 || id == 100 || id == 101 || id == 25550 || id == 25552 || id == 25553) {
                this.init(21);
                return true;
            }
        } else if (AWT.isInternalFrameDecoration((Component)event.getSource())) {
            this.init(22);
            return true;
        }
        return false;
    }

    public boolean parse(AWTEvent event) {
        boolean consumed = true;
        switch (this.getRecordingType()) {
            case 21: {
                consumed = this.parseInternalFrameAction(event);
                break;
            }
            case 22: {
                this.setFinished(true);
                break;
            }
            default: {
                consumed = super.parse(event);
            }
        }
        return consumed;
    }

    protected boolean parseInternalFrameAction(AWTEvent event) {
        this.frame = (JInternalFrame)event.getSource();
        switch (event.getID()) {
            case 102: {
                this.type = SHOW;
                break;
            }
            case 103: {
                this.type = HIDE;
                break;
            }
            case 101: {
                this.type = RESIZE;
                break;
            }
            case 100: {
                this.type = MOVE;
                break;
            }
            case 25550: {
                this.type = CLOSE;
                break;
            }
            case 25552: {
                this.type = ICONIFY;
                break;
            }
            case 25553: {
                this.type = DEICONIFY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized event: " + event);
            }
        }
        this.setFinished(true);
        return true;
    }

    protected Step createStep() {
        Step step;
        switch (this.getRecordingType()) {
            case 21: {
                step = this.createInternalFrameAction(this.frame, this.type);
                break;
            }
            case 22: {
                step = null;
                break;
            }
            default: {
                step = super.createStep();
            }
        }
        return step;
    }

    protected Step createInternalFrameAction(JInternalFrame target, String type) {
        ComponentReference ref = this.getResolver().addComponent(target);
        if (type == SHOW || type == HIDE) {
            Assert step = new Assert(this.getResolver(), null, (class$abbot$tester$ComponentTester == null ? (class$abbot$tester$ComponentTester = JInternalFrameRecorder.class$("abbot.tester.ComponentTester")) : class$abbot$tester$ComponentTester).getName(), "assertComponentShowing", new String[]{ref.getID()}, "true", type == HIDE);
            step.setWait(true);
            return step;
        }
        if (type == MOVE) {
            Point loc = target.getLocation();
            return new Action(this.getResolver(), null, "actionMove", new String[]{ref.getID(), String.valueOf(loc.x), String.valueOf(loc.y)}, class$javax$swing$JInternalFrame == null ? (class$javax$swing$JInternalFrame = JInternalFrameRecorder.class$("javax.swing.JInternalFrame")) : class$javax$swing$JInternalFrame);
        }
        if (type == RESIZE) {
            Dimension size = target.getSize();
            return new Action(this.getResolver(), null, "actionResize", new String[]{ref.getID(), String.valueOf(size.width), String.valueOf(size.height)}, class$javax$swing$JInternalFrame == null ? (class$javax$swing$JInternalFrame = JInternalFrameRecorder.class$("javax.swing.JInternalFrame")) : class$javax$swing$JInternalFrame);
        }
        String action = type == CLOSE ? "actionClose" : (type == ICONIFY ? "actionIconify" : "actionDeiconify");
        return new Action(this.getResolver(), null, action, new String[]{ref.getID()}, class$javax$swing$JInternalFrame == null ? (class$javax$swing$JInternalFrame = JInternalFrameRecorder.class$("javax.swing.JInternalFrame")) : class$javax$swing$JInternalFrame);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

