/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.recorder;

import abbot.BugReport;
import abbot.Log;
import abbot.editor.recorder.SemanticRecorder;
import abbot.i18n.Strings;
import abbot.script.Action;
import abbot.script.Assert;
import abbot.script.ComponentReference;
import abbot.script.Resolver;
import abbot.script.Step;
import abbot.tester.AWTConstants;
import abbot.tester.ComponentLocation;
import abbot.tester.ComponentTester;
import abbot.tester.Robot;
import abbot.util.AWT;
import java.awt.AWTEvent;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.WeakHashMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class ComponentRecorder
extends SemanticRecorder {
    private static final String[] TYPES = new String[]{"any", "window", "menu", "click", "key", "drag", "drop", "text", "input method"};
    private static HashMap specialMap;
    private Window window = null;
    private boolean isClose = false;
    private char keychar = (char)65535;
    private int modifiers;
    private Component target;
    private Component forwardedTarget;
    private int x;
    private int y;
    private boolean released;
    private int clickCount;
    private Component invoker;
    private int menux;
    private int menuy;
    private MenuItem awtMenuTarget;
    private Component menuTarget;
    private boolean isPopup;
    private boolean hasAWTPopup;
    private MenuListener menuListener;
    private boolean menuCanceled;
    private Component dragSource;
    private int dragx;
    private int dragy;
    private Component dropTarget;
    private int dropx;
    private int dropy;
    private ArrayList imKeyCodes = new ArrayList();
    private StringBuffer imText = new StringBuffer();
    private static WeakHashMap closeEventWindows;
    private static WeakHashMap openEventWindows;
    static /* synthetic */ Class class$abbot$editor$recorder$ComponentRecorder;
    static /* synthetic */ Class class$abbot$tester$ComponentTester;

    public ComponentRecorder(Resolver resolver) {
        super(resolver);
    }

    protected boolean isOpen(AWTEvent event) {
        int id = event.getID();
        return id == 200 && !openEventWindows.containsKey(event.getSource()) || id == 102;
    }

    protected boolean isClose(AWTEvent event) {
        int id = event.getID();
        return id == 202 && !closeEventWindows.containsKey(event.getSource()) || id == 103;
    }

    public boolean accept(AWTEvent event) {
        boolean accepted;
        int rtype = -1;
        if (this.isWindowEvent(event)) {
            rtype = 1;
        } else if (this.isMenuEvent(event)) {
            rtype = 2;
        } else if (this.isKeyTyped(event)) {
            rtype = 4;
        } else if (this.isClick(event)) {
            rtype = 3;
        } else if (this.isDragDrop(event)) {
            rtype = 6;
        } else if (this.isInputMethod(event)) {
            rtype = 8;
        } else if (Log.isClassDebugEnabled(class$abbot$editor$recorder$ComponentRecorder == null ? (class$abbot$editor$recorder$ComponentRecorder = ComponentRecorder.class$("abbot.editor.recorder.ComponentRecorder")) : class$abbot$editor$recorder$ComponentRecorder)) {
            Log.debug("Ignoring " + Robot.toString(event));
        }
        this.init(rtype);
        boolean bl = accepted = rtype != -1;
        if (accepted && Log.isClassDebugEnabled(class$abbot$editor$recorder$ComponentRecorder == null ? (class$abbot$editor$recorder$ComponentRecorder = ComponentRecorder.class$("abbot.editor.recorder.ComponentRecorder")) : class$abbot$editor$recorder$ComponentRecorder)) {
            Log.debug("Accepted " + ComponentTester.toString(event));
        }
        return accepted;
    }

    protected boolean isWindowEvent(AWTEvent event) {
        return event.getSource() instanceof Window && !AWT.isHeavyweightPopup((Window)event.getSource()) && !this.isToolTip(event.getSource()) && (this.isClose(event) || this.isOpen(event));
    }

    protected boolean isToolTip(Object source) {
        if (source instanceof JWindow && !(source instanceof JFrame)) {
            Container pane = ((JWindow)source).getContentPane();
            while (pane.getComponentCount() == 1) {
                Component child = pane.getComponent(0);
                if (child instanceof JToolTip) {
                    return true;
                }
                if (!(child instanceof Container)) break;
                pane = (Container)child;
            }
        }
        return false;
    }

    protected boolean isMenuEvent(AWTEvent event) {
        if (event.getID() == 1001 && event.getSource() instanceof MenuItem) {
            return true;
        }
        if (event.getID() == 501) {
            MouseEvent me = (MouseEvent)event;
            return me.isPopupTrigger() || (me.getModifiers() & AWTConstants.POPUP_MASK) != 0 || me.getSource() instanceof JMenu;
        }
        return false;
    }

    protected boolean isKeyTyped(AWTEvent event) {
        return event.getID() == 400;
    }

    protected boolean isClick(AWTEvent event) {
        if (event.getID() == 501) {
            MouseEvent me = (MouseEvent)event;
            return (me.getModifiers() & 0x10) != 0;
        }
        return false;
    }

    protected boolean isDragDrop(AWTEvent event) {
        return event.getID() == 506;
    }

    protected boolean canDrag() {
        return true;
    }

    protected boolean canMultipleClick() {
        return true;
    }

    private boolean isInputMethod(AWTEvent event) {
        return event.getID() == 402 && ((KeyEvent)event).getKeyCode() == 244 || event.getID() == 1100;
    }

    protected boolean parseClick(AWTEvent event) {
        boolean consumed = true;
        int id = event.getID();
        if (id == 501) {
            Log.debug("Parsing mouse down");
            MouseEvent me = (MouseEvent)event;
            if (this.clickCount == 0) {
                this.target = me.getComponent();
                this.x = me.getX();
                this.y = me.getY();
                this.modifiers = me.getModifiers();
                this.clickCount = 1;
                this.getResolver().addComponent(this.target);
            } else if (this.target == me.getComponent()) {
                this.clickCount = me.getClickCount();
            } else if (!this.released) {
                this.forwardedTarget = me.getComponent();
            }
            this.released = false;
        } else if (id == 502) {
            Log.debug("Parsing mouse up");
            this.released = true;
            if (!this.canMultipleClick()) {
                this.setFinished(true);
            }
        } else if (id == 500) {
            if (!this.canMultipleClick()) {
                this.setFinished(true);
            }
        } else if (id == 505) {
            Log.debug("exit event, released=" + this.released);
            if (event.getSource() != this.target || this.released) {
                consumed = false;
                this.setFinished(true);
            } else if (!this.released && this.clickCount == 1) {
                this.setRecordingType(5);
                consumed = this.dragStarted(this.target, this.x, this.y, this.modifiers, (MouseEvent)event);
            }
        } else if (id == 504) {
            if ((event.getSource() != this.target || this.released) && event.getSource() != this.forwardedTarget) {
                consumed = false;
                this.setFinished(true);
            }
        } else if (id == 506 && this.canDrag()) {
            Log.debug("Changing click to drag start");
            MouseEvent me = (MouseEvent)event;
            Point where = SwingUtilities.convertPoint(me.getComponent(), me.getX(), me.getY(), this.target);
            int threshold = Integer.getInteger("abbot.capture.drag_threshold", 5);
            if (Math.abs(where.x - this.x) >= threshold || Math.abs(where.y - this.y) >= threshold) {
                this.setRecordingType(5);
                consumed = this.dragStarted(this.target, this.x, this.y, this.modifiers, me);
            } else {
                Log.debug("Drag too small: " + me + " (from " + this.dragSource + " (" + this.x + ", " + this.y + "))");
            }
        } else if (!(id >= 100 && id <= 103 || event instanceof ContainerEvent || event instanceof FocusEvent || id == 1400 && (((HierarchyEvent)event).getChangeFlags() & 4L) == 0L || !this.released)) {
            consumed = false;
            this.setFinished(true);
        }
        return consumed;
    }

    protected boolean parseWindowEvent(AWTEvent event) {
        boolean consumed = true;
        this.isClose = this.isClose(event);
        if (this.isClose) {
            closeEventWindows.put(event.getSource(), Boolean.TRUE);
            openEventWindows.remove(event.getSource());
        } else {
            openEventWindows.put(event.getSource(), Boolean.TRUE);
            closeEventWindows.remove(event.getSource());
        }
        Log.log("close=" + this.isClose + " (" + Robot.toString(event) + ")");
        this.window = (Window)event.getSource();
        this.setFinished(true);
        return consumed;
    }

    protected boolean parseKeyEvent(AWTEvent e) {
        int id = e.getID();
        boolean consumed = true;
        if (id == 400) {
            KeyEvent typed = (KeyEvent)e;
            this.target = typed.getComponent();
            this.keychar = typed.getKeyChar();
            this.modifiers = typed.getModifiers();
            if ((this.modifiers & 8) == 8) {
                Log.debug("Waiting for potential focus accelerator on '" + this.keychar + "'");
            } else {
                if ((this.modifiers & 2) == 2 || (this.modifiers & 8) == 8) {
                    Log.debug("Ignoring modifiers: " + this.modifiers);
                    this.setRecordingType(-1);
                }
                this.setFinished(true);
            }
        } else if (id != 1005) {
            if (id == 1004) {
                Object o = e.getSource();
                char ch = '\uffff';
                if (o instanceof JTextComponent) {
                    ch = ((JTextComponent)o).getFocusAccelerator();
                    Log.debug("focus accelerator is '" + ch + "'");
                }
                if (Character.toUpperCase(ch) == Character.toUpperCase(this.keychar)) {
                    this.setRecordingType(-1);
                    this.setFinished(true);
                } else {
                    this.setFinished(true);
                    consumed = false;
                }
            } else {
                this.setRecordingType(-1);
                this.setFinished(true);
                consumed = false;
            }
        }
        return consumed;
    }

    protected boolean parseMenuSelection(AWTEvent event) {
        int id = event.getID();
        boolean consumed = true;
        if (id == 1001 || id == 701) {
            this.awtMenuTarget = (MenuItem)event.getSource();
            this.invoker = AWT.getInvoker(this.awtMenuTarget);
            if (this.invoker != null) {
                this.isPopup = true;
            }
            Log.debug("AWT menu selection, invoker=" + Robot.toString(this.invoker));
            this.modifiers = event instanceof ActionEvent ? ((ActionEvent)event).getModifiers() : Robot.getState().getModifiers();
            this.setFinished(true);
        } else if (id == 501) {
            MouseEvent me = (MouseEvent)event;
            if (this.invoker == null) {
                this.invoker = me.getComponent();
                this.menux = me.getX();
                this.menuy = me.getY();
                this.modifiers = me.getModifiers();
                this.isPopup = me.isPopupTrigger();
                if (this.isPopup || (this.modifiers & AWTConstants.POPUP_MASK) != 0) {
                    this.hasAWTPopup = this.addMenuListener(this.invoker);
                }
                if (this.invoker instanceof JMenuItem && !(this.invoker instanceof JMenu)) {
                    this.menuTarget = this.invoker;
                    this.invoker = null;
                    this.menuy = -1;
                    this.menux = -1;
                    this.modifiers = 0;
                    this.isPopup = true;
                }
            } else if (!(event.getSource() instanceof JMenu)) {
                if (event.getSource() instanceof JMenuItem) {
                    this.menuTarget = (Component)event.getSource();
                } else {
                    this.menuCanceled = true;
                    this.setStatus("Popup menu selection canceled");
                }
            }
            Log.log("Menu mouse press");
        } else if (id == 502) {
            MouseEvent me = (MouseEvent)event;
            if (this.menuCanceled) {
                this.setRecordingType(-1);
                this.setFinished(true);
            } else if (this.menuTarget == null) {
                if (!this.isPopup) {
                    this.isPopup = me.isPopupTrigger();
                }
            } else if (this.menuTarget != null) {
                this.setFinished(true);
            }
            Log.log("Menu mouse release");
        } else if (id == 500 && this.isPopup) {
            if (!this.hasAWTPopup && AWT.findActivePopupMenu() == null) {
                this.setRecordingType(3);
                this.target = this.invoker;
                this.x = this.menux;
                this.y = this.menuy;
                this.setFinished(true);
            }
        } else {
            Log.debug("Ignoring " + ComponentTester.toString(event));
        }
        return consumed;
    }

    protected boolean parseDrop(AWTEvent event) {
        int id = event.getID();
        switch (id) {
            case 504: 
            case 506: {
                this.updateDropTarget((MouseEvent)event);
                break;
            }
            case 502: {
                this.updateDropTarget((MouseEvent)event);
                this.setFinished(true);
                break;
            }
            case 503: {
                this.setFinished(true);
                break;
            }
            case 505: {
                break;
            }
            default: {
                if (!Log.isClassDebugEnabled(class$abbot$editor$recorder$ComponentRecorder == null ? (class$abbot$editor$recorder$ComponentRecorder = ComponentRecorder.class$("abbot.editor.recorder.ComponentRecorder")) : class$abbot$editor$recorder$ComponentRecorder)) break;
                Log.debug("Ignoring " + ComponentTester.toString(event));
            }
        }
        return true;
    }

    private void updateDropTarget(MouseEvent me) {
        this.dropTarget = SwingUtilities.getDeepestComponentAt(me.getComponent(), me.getX(), me.getY());
        Point where = SwingUtilities.convertPoint(me.getComponent(), me.getX(), me.getY(), this.dropTarget);
        this.dropx = where.x;
        this.dropy = where.y;
    }

    protected boolean parseInputMethod(AWTEvent event) {
        boolean consumed = true;
        int id = event.getID();
        if (id == 402) {
            KeyEvent ke = (KeyEvent)event;
            int code = ke.getKeyCode();
            switch (code) {
                case 244: {
                    break;
                }
                case 243: {
                    Log.log("Captured " + this.imText);
                    this.setFinished(true);
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 157: 
                case 65406: {
                    Log.debug("Modifier indicates end of InputMethod");
                    consumed = true;
                    this.setFinished(true);
                    break;
                }
                default: {
                    this.imKeyCodes.add(new Integer(code));
                    break;
                }
            }
        } else if (event instanceof InputMethodEvent) {
            InputMethodEvent ime = (InputMethodEvent)event;
            if (id == 1100) {
                if (ime.getCommittedCharacterCount() > 0) {
                    AttributedCharacterIterator iter = ime.getText();
                    StringBuffer sb = new StringBuffer();
                    char ch = iter.first();
                    while (ch != '\uffff') {
                        sb.append(ch);
                        ch = iter.next();
                    }
                    this.target = (Component)ime.getSource();
                    this.imText.append(sb.toString());
                    Log.debug("Partial capture " + sb.toString());
                }
                this.setFinished(true);
            }
        } else {
            consumed = false;
            this.setFinished(true);
        }
        return consumed;
    }

    public boolean parse(AWTEvent event) {
        if (Log.isClassDebugEnabled(class$abbot$editor$recorder$ComponentRecorder == null ? (class$abbot$editor$recorder$ComponentRecorder = ComponentRecorder.class$("abbot.editor.recorder.ComponentRecorder")) : class$abbot$editor$recorder$ComponentRecorder)) {
            Log.debug("Parsing " + ComponentTester.toString(event) + " as " + TYPES[this.getRecordingType()]);
        }
        boolean consumed = true;
        switch (this.getRecordingType()) {
            case 1: {
                consumed = this.parseWindowEvent(event);
                break;
            }
            case 4: {
                consumed = this.parseKeyEvent(event);
                break;
            }
            case 3: {
                consumed = this.parseClick(event);
                break;
            }
            case 2: {
                consumed = this.parseMenuSelection(event);
                break;
            }
            case 6: {
                consumed = this.parseDrop(event);
                break;
            }
            case 8: {
                consumed = this.parseInputMethod(event);
                break;
            }
            default: {
                Log.warn("Unknown input type: " + this.getRecordingType());
            }
        }
        if (this.isFinished()) {
            try {
                Step step = this.createStep();
                this.setStep(step);
                Log.log("Semantic event recorded: " + step);
            }
            catch (Throwable thr) {
                String msg = Strings.get("editor.recording.error");
                BugReport br = new BugReport(msg, thr);
                Log.log("Semantic recorder error: " + br.toString());
                this.setStatus(Strings.get("editor.see_console"));
                this.setRecordingType(-1);
                throw br;
            }
        }
        return consumed;
    }

    protected boolean dragStarted(Component target, int x, int y, int modifiers, MouseEvent dragEvent) {
        this.dragSource = target;
        this.dragx = x;
        this.dragy = y;
        this.setFinished(true);
        return false;
    }

    protected Step createStep() {
        Step step = null;
        int type = this.getRecordingType();
        Log.debug("Creating step for semantic recorder, type: " + (type >= 0 && type < TYPES.length ? TYPES[this.getRecordingType()] : String.valueOf(type)));
        switch (type) {
            case 1: {
                step = this.createWindowEvent(this.window, this.isClose);
                break;
            }
            case 2: {
                if (this.awtMenuTarget != null) {
                    if (this.invoker == null) {
                        MenuContainer mc = this.awtMenuTarget.getParent();
                        while (mc instanceof MenuComponent && !(mc instanceof Component)) {
                            mc = ((MenuComponent)((Object)mc)).getParent();
                        }
                        if (mc == null) {
                            throw new Error("AWT MenuItem " + this.awtMenuTarget + " has no Component ancestor");
                        }
                        this.invoker = (Component)mc;
                    }
                    step = this.createAWTMenuSelection(this.invoker, this.awtMenuTarget, this.isPopup);
                    break;
                }
                if (this.isPopup) {
                    step = this.createPopupMenuSelection(this.invoker, this.menux, this.menuy, this.menuTarget);
                    break;
                }
                if (this.menuTarget == null) break;
                step = this.createMenuSelection(this.menuTarget);
                break;
            }
            case 4: {
                if (this.keychar != '\uffff') {
                    step = this.createKey(this.target, this.keychar, this.modifiers);
                    break;
                }
                step = null;
                break;
            }
            case 3: {
                step = this.createClick(this.target, this.x, this.y, this.modifiers, this.canMultipleClick() ? this.clickCount : 1);
                break;
            }
            case 5: {
                step = this.createDrag(this.dragSource, this.dragx, this.dragy);
                break;
            }
            case 6: {
                step = this.createDrop(this.dropTarget, this.dropx, this.dropy);
                break;
            }
            case 8: {
                if (this.imText.length() > 0) {
                    step = this.createInputMethod(this.target, this.imKeyCodes, this.imText.toString());
                    break;
                }
                Log.debug("Input method resulted in no text");
                step = null;
                break;
            }
            default: {
                step = null;
            }
        }
        return step;
    }

    protected Step createWindowEvent(Window window, boolean isClose) {
        ComponentReference ref = this.getResolver().addComponent(window);
        String method = "assertComponentShowing";
        Assert step = new Assert(this.getResolver(), null, (class$abbot$tester$ComponentTester == null ? (class$abbot$tester$ComponentTester = ComponentRecorder.class$("abbot.tester.ComponentTester")) : class$abbot$tester$ComponentTester).getName(), method, new String[]{ref.getID()}, "true", isClose);
        step.setWait(true);
        return step;
    }

    protected Step createMenuSelection(Component menuItem) {
        ComponentReference cr = this.getResolver().addComponent(menuItem);
        Action step = new Action(this.getResolver(), null, "actionSelectMenuItem", new String[]{cr.getID()});
        return step;
    }

    protected Step createAWTMenuSelection(Component parent, MenuItem menuItem, boolean isPopup) {
        ComponentReference ref = this.getResolver().addComponent(parent);
        String method = "actionSelectAWTMenuItem";
        if (isPopup) {
            method = "actionSelectAWTPopupMenuItem";
        }
        String path = AWT.getPath(menuItem);
        Action step = new Action(this.getResolver(), null, method, new String[]{ref.getID(), path});
        return step;
    }

    protected Step createPopupMenuSelection(Component invoker, int x, int y, Component menuItem) {
        Action step;
        if (invoker != null) {
            ComponentReference inv = this.getResolver().addComponent(invoker);
            JMenuItem mi = (JMenuItem)menuItem;
            String where = this.getLocationArgument(invoker, x, y);
            step = new Action(this.getResolver(), null, "actionSelectPopupMenuItem", new String[]{inv.getID(), where, mi.getText()}, invoker.getClass());
        } else {
            ComponentReference ref = this.getResolver().addComponent(menuItem);
            step = new Action(this.getResolver(), null, "actionSelectMenuItem", new String[]{ref.getID()});
        }
        return step;
    }

    protected Step createKey(Component comp, char keychar, int mods) {
        ComponentReference cr = this.getResolver().addComponent(comp);
        String code = (String)specialMap.get(String.valueOf(keychar));
        if (code != null) {
            String[] stringArray;
            if (mods != 0) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = cr.getID();
                stringArray2[1] = code;
                stringArray = stringArray2;
                stringArray2[2] = AWT.getKeyModifiers(mods);
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = cr.getID();
                stringArray = stringArray3;
                stringArray3[1] = code;
            }
            String[] args = stringArray;
            return new Action(this.getResolver(), null, "actionKeyStroke", args);
        }
        return new Action(this.getResolver(), null, "actionKeyString", new String[]{cr.getID(), String.valueOf(keychar)});
    }

    protected Step createDrop(Component comp, int x, int y) {
        Action step = null;
        if (comp != null) {
            ComponentReference cr = this.getResolver().addComponent(comp);
            String where = this.getLocationArgument(comp, x, y);
            step = new Action(this.getResolver(), null, "actionDrop", new String[]{cr.getID(), where}, comp.getClass());
        }
        return step;
    }

    protected Step createDrag(Component comp, int x, int y) {
        ComponentReference ref = this.getResolver().addComponent(comp);
        String where = this.getLocationArgument(comp, x, y);
        Action step = new Action(this.getResolver(), null, "actionDrag", new String[]{ref.getID(), where}, comp.getClass());
        return step;
    }

    protected Step createClick(Component target, int x, int y, int mods, int count) {
        Log.debug("creating click");
        ComponentReference cr = this.getResolver().addComponent(target);
        ArrayList<String> args = new ArrayList<String>();
        args.add(cr.getID());
        args.add(this.getLocationArgument(target, x, y));
        if (mods != 0 && mods != 16 || count > 1) {
            args.add(AWT.getMouseModifiers(mods));
            if (count > 1) {
                args.add(String.valueOf(count));
            }
        }
        return new Action(this.getResolver(), null, "actionClick", args.toArray(new String[args.size()]), target.getClass());
    }

    protected Step createInputMethod(Component comp, ArrayList codes, String text) {
        Log.debug("Text length is " + text.length());
        ComponentReference ref = this.getResolver().addComponent(comp);
        return new Action(this.getResolver(), null, "actionKeyString", new String[]{ref.getID(), text});
    }

    protected void init(int recordingType) {
        super.init(recordingType);
        this.target = null;
        this.forwardedTarget = null;
        this.released = false;
        this.clickCount = 0;
        this.keychar = (char)65535;
        this.invoker = null;
        this.awtMenuTarget = null;
        this.isPopup = false;
        this.hasAWTPopup = false;
        this.menuListener = null;
        this.menuTarget = null;
        this.menuCanceled = false;
        this.dropTarget = null;
        this.dragSource = null;
        this.window = null;
        this.isClose = false;
        this.imKeyCodes.clear();
        this.imText.delete(0, this.imText.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFinished(boolean state) {
        MenuListener listener = null;
        ComponentRecorder componentRecorder = this;
        synchronized (componentRecorder) {
            super.setFinished(state);
            listener = this.menuListener;
            this.menuListener = null;
        }
        if (listener != null) {
            listener.dispose();
        }
    }

    private boolean addMenuListener(Component invoker) {
        PopupMenu[] popups = AWT.getPopupMenus(invoker);
        if (popups.length > 0) {
            this.menuListener = new MenuListener(popups);
            return true;
        }
        return false;
    }

    protected String getLocationArgument(Component c, int x, int y) {
        return this.getLocation(c, x, y).toString();
    }

    protected ComponentLocation getLocation(Component c, int x, int y) {
        ComponentTester tester = ComponentTester.getTester(c);
        return tester.getLocation(c, new Point(x, y));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int[][] mappings = new int[][]{{9, 9}, {27, 27}, {8, 8}, {127, 127}, {10, 10}, {13, 10}};
        specialMap = new HashMap();
        for (int i = 0; i < mappings.length; ++i) {
            specialMap.put(String.valueOf((char)mappings[i][0]), AWT.getKeyCode(mappings[i][1]));
        }
        closeEventWindows = new WeakHashMap();
        openEventWindows = new WeakHashMap();
    }

    private class MenuListener
    implements ItemListener {
        private ArrayList items = new ArrayList();

        public MenuListener(PopupMenu[] popups) {
            for (int i = 0; i < popups.length; ++i) {
                this.addRecursive(popups[i]);
            }
        }

        private void addRecursive(Menu menu) {
            for (int i = 0; i < menu.getItemCount(); ++i) {
                MenuItem item = menu.getItem(i);
                if (item instanceof Menu) {
                    this.addRecursive((Menu)item);
                    continue;
                }
                if (!(item instanceof CheckboxMenuItem)) continue;
                ((CheckboxMenuItem)item).addItemListener(this);
                this.items.add(item);
            }
        }

        public void itemStateChanged(ItemEvent e) {
            this.dispose();
            ComponentRecorder.this.parse(e);
        }

        public void dispose() {
            while (this.items.size() > 0) {
                ((CheckboxMenuItem)this.items.get(0)).removeItemListener(this);
                this.items.remove(0);
            }
        }
    }
}

