/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.editors;

import abbot.editor.editors.LaunchEditor;
import abbot.i18n.Strings;
import abbot.script.Launch;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.sf.ant4eclipse.model.FileParserException;
import net.sf.ant4eclipse.model.launch.AbstractLaunchConfiguration;
import net.sf.ant4eclipse.model.launch.JavaApplicationLaunchConfiguration;
import net.sf.ant4eclipse.model.launch.LaunchFileParser;
import net.sf.ant4eclipse.model.project.Workspace;
import net.sf.ant4eclipse.tools.ResolvedPathEntry;
import net.sf.ant4eclipse.tools.resolver.RuntimeClasspathResolver;

public class ImportButton
extends JButton
implements ActionListener {
    private JFileChooser launchfilechooser;
    private JFileChooser workspacefilechooser;
    private LaunchFileFilter launchfilefilter;
    private WorkspaceFileFilter workspacefilefilter;
    private LaunchEditor editor;
    private Launch launch;

    public ImportButton(LaunchEditor launcheditor, Launch launchstep) {
        super(Strings.get("eclipse.import"));
        this.editor = launcheditor;
        this.launch = launchstep;
        this.launchfilechooser = new JFileChooser();
        this.workspacefilechooser = new JFileChooser();
        this.launchfilefilter = new LaunchFileFilter();
        this.launchfilechooser.setFileFilter(this.launchfilefilter);
        this.workspacefilechooser.setFileFilter(this.workspacefilefilter);
        this.workspacefilechooser.setFileSelectionMode(1);
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.importEclipse()) {
            this.editor.fireStepChanged();
        }
    }

    private File selectWorkspace(String projectname) {
        this.workspacefilefilter.setProjectName(projectname);
        File result = null;
        int option = this.workspacefilechooser.showOpenDialog(null);
        if (option == 0) {
            result = this.workspacefilechooser.getSelectedFile();
        }
        return result;
    }

    private File locateWorkspace(File file) {
        if (file == null) {
            return null;
        }
        File metadata = new File(file, ".metadata");
        if (metadata.isDirectory()) {
            return file;
        }
        return this.locateWorkspace(file.getParentFile());
    }

    private boolean importEclipse() {
        boolean result = false;
        JavaApplicationLaunchConfiguration launchconfig = this.selectLaunchConfiguration();
        if (launchconfig != null) {
            File workspacedir = this.locateWorkspace(launchconfig.getLaunchFile().getParentFile());
            if (workspacedir == null) {
                workspacedir = this.selectWorkspace(launchconfig.getProjectName());
            }
            if (workspacedir != null) {
                Workspace workspace = Workspace.getWorkspace((File)workspacedir);
                String cp = this.loadClasspath(workspace, launchconfig);
                File projectlocation = workspace.getChild(launchconfig.getProjectName());
                String progargs = launchconfig.getProgramArguments();
                if (progargs == null) {
                    progargs = "";
                }
                Object[] splitted = progargs.split(" ");
                StringBuffer argsbuffer = new StringBuffer();
                for (int i = 0; i < splitted.length; ++i) {
                    File file;
                    if (i > 0) {
                        argsbuffer.append(" ");
                    }
                    splitted[i] = (file = new File(projectlocation, splitted[i])).exists() ? "[" + file.getAbsolutePath() + "]" : "[" + splitted[i] + "]";
                    argsbuffer.append(splitted[i]);
                }
                this.launch.setArguments(argsbuffer.toString());
                this.launch.setClasspath(cp);
                this.launch.setTargetClassName(launchconfig.getMainType());
                this.editor.classpath.setValues(cp.split(File.pathSeparator));
                this.editor.target.setText(launchconfig.getMainType());
                this.editor.arguments.setValues(splitted);
                result = true;
            }
        }
        return result;
    }

    private String loadClasspath(Workspace workspace, JavaApplicationLaunchConfiguration launchconfig) {
        ResolvedPathEntry[] entries = null;
        try {
            entries = RuntimeClasspathResolver.resolveRuntimeClasspath((Workspace)workspace, (AbstractLaunchConfiguration)launchconfig, (boolean)false);
        }
        catch (FileParserException ex) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        boolean added = false;
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].isResolved()) continue;
            if (added) {
                buffer.append(File.pathSeparator);
            }
            buffer.append(entries[i].getResolvedEntryAsFile().getAbsolutePath());
            added = true;
        }
        return buffer.toString();
    }

    private JavaApplicationLaunchConfiguration selectLaunchConfiguration() {
        File location;
        JavaApplicationLaunchConfiguration result = null;
        int option = this.launchfilechooser.showOpenDialog(null);
        if (option == 0 && (location = this.launchfilechooser.getSelectedFile()).isFile()) {
            try {
                LaunchFileParser parser = new LaunchFileParser(location);
                AbstractLaunchConfiguration config = parser.getLaunchConfiguration();
                if (config instanceof JavaApplicationLaunchConfiguration) {
                    result = (JavaApplicationLaunchConfiguration)config;
                }
            }
            catch (FileParserException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    private static class WorkspaceFileFilter
    extends FileFilter {
        private String project = null;
        private String relative = null;

        public void setProjectName(String newproject) {
            this.project = newproject;
            this.relative = ".plugins/org.eclipse.core.resources/.projects/" + this.project;
        }

        public boolean accept(File file) {
            File child;
            if (file.isDirectory() && (child = new File(file, ".metadata")).isDirectory()) {
                File projectdir = new File(child, this.relative);
                return projectdir.isDirectory();
            }
            return false;
        }

        public String getDescription() {
            return "Eclipse Workspace";
        }
    }

    private static class LaunchFileFilter
    extends FileFilter {
        private LaunchFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            return name.endsWith(".launch");
        }

        public String getDescription() {
            return "Eclipse Launch Configuration (*.launch)";
        }
    }
}

