/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.editors;

import abbot.editor.editors.StepEditor;
import abbot.editor.widgets.ArrayEditor;
import abbot.i18n.Strings;
import abbot.script.Call;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class CallEditor
extends StepEditor {
    private Call call;
    protected JTextField target;
    protected JComboBox method;
    protected ArrayEditor arguments;
    private String[] names = new String[0];
    private boolean fieldChanging;

    public CallEditor(Call call) {
        super(call);
        this.call = call;
        this.target = this.addTextField(Strings.get("TargetClass"), call.getTargetClassName());
        this.target.setName("class");
        this.method = this.addComboBox(Strings.get("Method"), call.getMethodName(), this.getMethodNames());
        this.method.setName("method");
        this.arguments = this.addArrayEditor(Strings.get("Arguments"), call.getArguments());
        this.arguments.setName("args");
    }

    protected Call getCall() {
        return this.call;
    }

    protected String[] getMethodNames() {
        try {
            Class cls = this.call.getTargetClass();
            Object[] names = this.getMethodNames(this.getMethods(cls, 1));
            Arrays.sort(names);
            return names;
        }
        catch (ClassNotFoundException e) {
            return new String[0];
        }
    }

    protected Class getTargetClass() throws ClassNotFoundException {
        try {
            return this.call.getTargetClass();
        }
        catch (NoClassDefFoundError e) {
            throw new ClassNotFoundException(e.getMessage());
        }
    }

    protected Map getMethods(Class cls, int mask) {
        HashMap<String, Method> processed = new HashMap<String, Method>();
        while (cls != null) {
            Method[] methods = cls.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if ((methods[i].getModifiers() & mask) != mask) continue;
                processed.put(methods[i].getName(), methods[i]);
            }
            cls = cls.getSuperclass();
        }
        return processed;
    }

    protected String[] getMethodNames(Map methods) {
        return methods.keySet().toArray(new String[methods.size()]);
    }

    protected void validateTargetClass() {
        try {
            this.call.getTargetClass();
            this.target.setForeground(DEFAULT_FOREGROUND);
        }
        catch (ClassNotFoundException e) {
            this.target.setForeground(ERROR_FOREGROUND);
        }
        catch (NoClassDefFoundError e) {
            this.target.setForeground(ERROR_FOREGROUND);
        }
    }

    protected void validateMethod() {
        try {
            this.call.getMethod();
            this.method.setForeground(DEFAULT_FOREGROUND);
        }
        catch (IllegalArgumentException e) {
            this.method.setForeground(ERROR_FOREGROUND);
        }
        catch (NoSuchMethodException e) {
            this.method.setForeground(ERROR_FOREGROUND);
        }
        catch (ClassNotFoundException e) {
            this.method.setForeground(ERROR_FOREGROUND);
        }
        catch (NoClassDefFoundError e) {
            this.target.setForeground(ERROR_FOREGROUND);
        }
    }

    private void availableMethodsChanged() {
        this.fieldChanging = true;
        String[] newNames = this.getMethodNames();
        Object current = this.method.getSelectedItem();
        if (current == null) {
            current = this.call.getMethodName();
        }
        boolean changed = newNames.length != this.names.length;
        for (int i = 0; i < newNames.length && !changed; ++i) {
            changed = !newNames[i].equals(this.names[i]);
        }
        if (changed) {
            this.method.setModel(new DefaultComboBoxModel<String>(newNames));
            String name = this.call.getMethodName();
            if (!name.equals(current)) {
                this.method.setSelectedItem(name);
            }
            this.names = newNames;
        }
        this.fieldChanging = false;
    }

    protected void targetClassChanged() {
        this.fieldChanging = true;
        this.target.setText(this.call.getTargetClassName());
        this.fieldChanging = false;
        this.availableMethodsChanged();
        this.validateTargetClass();
        this.validateMethod();
    }

    protected void methodChanged() {
        if (!this.call.getMethodName().equals(this.method.getSelectedItem())) {
            this.method.setSelectedItem(this.call.getMethodName());
        }
        this.validateMethod();
    }

    protected void argumentsChanged() {
        this.arguments.setValues(this.call.getArguments());
        this.validateMethod();
    }

    public void actionPerformed(ActionEvent ev) {
        if (this.fieldChanging) {
            return;
        }
        Object src = ev.getSource();
        if (src == this.target) {
            String cname = this.target.getText().trim();
            if (!cname.equals(this.call.getTargetClassName())) {
                this.call.setTargetClassName(cname);
                this.availableMethodsChanged();
                this.validateTargetClass();
                this.validateMethod();
                this.fireStepChanged();
            }
        } else if (src == this.method) {
            String name = (String)this.method.getSelectedItem();
            if (!this.call.getMethodName().equals(name) && name != null) {
                this.call.setMethodName(name);
                this.validateMethod();
                this.fireStepChanged();
            }
        } else if (src == this.arguments) {
            Object[] values = this.arguments.getValues();
            String[] svalues = new String[values.length];
            System.arraycopy(values, 0, svalues, 0, values.length);
            this.call.setArguments(svalues);
            this.validateMethod();
            this.fireStepChanged();
        } else {
            super.actionPerformed(ev);
        }
    }
}

