/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.Log;
import abbot.script.InvalidScriptException;
import abbot.script.Resolver;
import abbot.script.Script;
import abbot.script.Sequence;
import abbot.script.Step;
import abbot.script.XMLifiable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jdom.Element;

class ScriptModel
extends AbstractTableModel {
    private HashSet openSequences = new HashSet();
    private HashMap parents = new HashMap();
    private Script script = null;
    private ArrayList rows = new ArrayList();
    static /* synthetic */ Class class$abbot$editor$ScriptModel$Entry;
    static /* synthetic */ Class class$java$lang$Object;

    public ScriptModel() {
        this(null);
    }

    public ScriptModel(Script script) {
        this.setScript(script);
    }

    private void layout(boolean scanParents) {
        if (scanParents) {
            this.mapParents(this.script);
        }
        this.rows.clear();
        if (this.script != null) {
            this.addSubRows(this.script, 0);
        }
        this.fireTableDataChanged();
    }

    public synchronized void removeStep(Step step) {
        this.getParent(step).removeStep(step);
        this.openSequences.remove(step);
        this.layout(true);
    }

    public synchronized void removeSteps(List steps) {
        Step step;
        Iterator iter = steps.iterator();
        while (iter.hasNext()) {
            step = (Step)iter.next();
            this.getParent(step);
        }
        iter = steps.iterator();
        while (iter.hasNext()) {
            step = (Step)iter.next();
            this.getParent(step).removeStep(step);
            this.openSequences.remove(step);
        }
        this.layout(true);
    }

    public synchronized void insertStep(Sequence parent, Step step, int index) {
        parent.addStep(index, step);
        this.layout(true);
    }

    public synchronized void insertSteps(Sequence parent, List steps, int index) {
        Iterator iter = steps.iterator();
        while (iter.hasNext()) {
            parent.addStep(index++, (Step)iter.next());
        }
        this.layout(true);
    }

    private Entry getEntry(int row) {
        if (row > this.rows.size() - 1 || row < 0) {
            throw new IllegalArgumentException("Row " + row + " out of bounds (" + this.rows.size() + " available)");
        }
        return (Entry)this.rows.get(row);
    }

    public synchronized int getRowOf(Step step) {
        if (step != this.script) {
            for (int i = 0; i < this.rows.size(); ++i) {
                Entry entry = this.getEntry(i);
                if (entry.step.equals(step)) {
                    return i;
                }
                Log.debug("Not in " + entry.step);
            }
            Log.debug("Step " + step + " not found in (maybe not visible)");
        }
        return -1;
    }

    public synchronized boolean isOpen(int row) {
        return this.openSequences.contains(this.getEntry((int)row).step);
    }

    public synchronized boolean isOpen(Step step) {
        return this.openSequences.contains(step);
    }

    public synchronized void toggle(int row) {
        Step step = this.getEntry((int)row).step;
        if (step instanceof Sequence) {
            if (this.openSequences.contains(step)) {
                this.openSequences.remove(step);
            } else {
                this.openSequences.add(step);
            }
            this.layout(false);
        }
    }

    public synchronized void setScript(Script script) {
        this.script = script;
        this.openSequences.clear();
        if (script != null) {
            this.openSequences.add(script);
        }
        this.layout(true);
    }

    public synchronized int getRowCount() {
        if (this.script == null) {
            return 0;
        }
        return this.rows.size();
    }

    public int getColumnCount() {
        return 1;
    }

    public synchronized Step getStepAt(int row) {
        return this.getEntry((int)row).step;
    }

    private void validate(int row, int col) {
        if (row < 0 || row > this.getRowCount() - 1) {
            throw new IllegalArgumentException("Invalid row " + row);
        }
        if (col != 0) {
            throw new IllegalArgumentException("Invalid column " + col);
        }
    }

    public synchronized Object getValueAt(int row, int col) {
        this.validate(row, col);
        return this.getStepAt(row);
    }

    public synchronized void setValueAt(Object value, int row, int col) {
        this.validate(row, col);
        if (col == 0) {
            Entry entry = this.getEntry(row);
            if (entry.step instanceof Script) {
                Script old = (Script)entry.step;
                Script step = new Script((String)value, this.script.getHierarchy());
                step.setRelativeTo(old.getRelativeTo());
                Sequence parent = entry.parent != null ? entry.parent : this.script;
                parent.setStep(parent.indexOf(old), step);
                this.layout(true);
            } else if (entry.step instanceof Sequence) {
                String desc = (String)value;
                if (!"".equals(desc) && !entry.step.getDescription().equals(desc)) {
                    entry.step.setDescription(desc);
                }
            } else {
                try {
                    Step step = Step.createStep((Resolver)this.script, (String)value);
                    Sequence parent = entry.parent != null ? entry.parent : this.script;
                    parent.setStep(parent.indexOf(entry.step), step);
                    this.layout(true);
                }
                catch (IllegalArgumentException e) {
                    Log.warn(e);
                }
                catch (InvalidScriptException e) {
                    Log.warn(e);
                }
                catch (IOException e) {
                    Log.warn(e);
                }
            }
        }
    }

    public String getColumnName(int col) {
        return "";
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return class$abbot$editor$ScriptModel$Entry == null ? (class$abbot$editor$ScriptModel$Entry = ScriptModel.class$("abbot.editor.ScriptModel$Entry")) : class$abbot$editor$ScriptModel$Entry;
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = ScriptModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public Script getScript() {
        return this.script;
    }

    public synchronized int getNestingDepthAt(int row) {
        return row < 0 || row >= this.getRowCount() ? 0 : this.getEntry((int)row).nestingDepth;
    }

    public synchronized Script getScriptOf(int row) {
        this.validate(row, 0);
        Entry entry = this.getEntry(row);
        Sequence parent = entry.parent;
        while (!(parent instanceof Script)) {
            parent = this.getParent(parent);
        }
        return (Script)parent;
    }

    public synchronized Sequence getParent(Step step) {
        Sequence seq = (Sequence)this.parents.get(step);
        if (seq == null) {
            throw new IllegalArgumentException("Step " + step + " not found in " + this.getScript());
        }
        return seq;
    }

    private void mapParents(Sequence seq) {
        if (seq == null) {
            return;
        }
        if (seq == this.getScript()) {
            this.parents.clear();
        }
        Iterator iter = seq.steps().iterator();
        while (iter.hasNext()) {
            Step step = (Step)iter.next();
            this.parents.put(step, seq);
            if (!(step instanceof Sequence)) continue;
            this.mapParents((Sequence)step);
        }
    }

    private void addSubRows(Sequence seq, int level) {
        if (this.openSequences.contains(seq)) {
            Iterator iter = seq.steps().iterator();
            while (iter.hasNext()) {
                Step step = (Step)iter.next();
                this.rows.add(new Entry(step, seq, level));
                if (!(step instanceof Sequence)) continue;
                this.addSubRows((Sequence)step, level + 1);
            }
        }
    }

    public synchronized void moveSteps(Sequence parent, List steps, int index) {
        Step step;
        Step indexStep = index < parent.size() ? parent.getStep(index) : null;
        Iterator iter = steps.iterator();
        while (iter.hasNext()) {
            step = (Step)iter.next();
            this.getParent(step).removeStep(step);
        }
        iter = steps.iterator();
        int n = index = indexStep != null ? parent.indexOf(indexStep) : parent.size();
        while (iter.hasNext()) {
            step = (Step)iter.next();
            parent.addStep(index++, step);
        }
        this.layout(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Entry
    implements XMLifiable {
        public Step step;
        public Sequence parent;
        public int nestingDepth;

        public Entry(Step step, Sequence parent, int nestingDepth) {
            this.step = step;
            this.parent = parent;
            this.nestingDepth = nestingDepth;
        }

        public String toString() {
            String str = this.step.toString();
            if (this.step instanceof Script && !this.step.getDescription().startsWith("Script")) {
                str = str + " - " + this.step.getDescription();
            }
            return str;
        }

        public String toEditableString() {
            return this.step.toEditableString();
        }

        public Element toXML() {
            return this.step.toXML();
        }
    }
}

