/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.Log;
import abbot.i18n.Strings;
import abbot.script.PropertyCall;
import abbot.tester.ComponentTester;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.table.DefaultTableModel;

class ComponentPropertyModel
extends DefaultTableModel {
    public static final int PROPERTY_NAME = 0;
    public static final int PROPERTY_VALUE = 1;
    public static final int ACCESSIBLE = 2;
    public static final int METHOD_OBJECT = 3;
    private static Set filteredMethods = new HashSet();
    private Map noAccess = new WeakHashMap();
    private Component currentComponent = null;
    private boolean filtered = false;
    static /* synthetic */ Class class$abbot$tester$ComponentTester;
    static /* synthetic */ Class class$java$awt$Component;

    public static void setFilteredPropertyMethods(String[] methods) {
        filteredMethods.addAll(Arrays.asList(methods));
    }

    public ComponentPropertyModel() {
        super(new Object[]{Strings.get("Name"), Strings.get("Value")}, 0);
    }

    public void clear() {
        this.setRowCount(0);
    }

    public void setComponent(Component comp) {
        this.setComponent(comp, true);
    }

    public void setComponent(Component comp, boolean filter) {
        Class<?> cls;
        Class<?> clazz = cls = comp != null ? comp.getClass() : null;
        if (this.currentComponent == comp && filter == this.filtered) {
            return;
        }
        this.clear();
        this.currentComponent = comp;
        this.filtered = filter;
        Method[] all = this.getPropertyMethods(cls, filter);
        Arrays.sort(all, new Comparator(){

            public int compare(Object o1, Object o2) {
                String n1 = ComponentPropertyModel.this.getPropertyName(((Method)o1).getName());
                String n2 = ComponentPropertyModel.this.getPropertyName(((Method)o2).getName());
                return n1.compareTo(n2);
            }
        });
        Object[] noArgs = new Object[]{};
        Object[] oneArg = new Object[]{comp};
        for (int i = 0; i < all.length; ++i) {
            Method method = all[i];
            Object value = "";
            try {
                Object target = comp;
                Object[] args = noArgs;
                if ((class$abbot$tester$ComponentTester == null ? ComponentPropertyModel.class$("abbot.tester.ComponentTester") : class$abbot$tester$ComponentTester).isAssignableFrom(method.getDeclaringClass())) {
                    target = ComponentTester.getTester(comp);
                    args = oneArg;
                }
                if ((method.getModifiers() & 1) == 0 || (method.getDeclaringClass().getModifiers() & 1) == 0) {
                    this.noAccess.put(method, Boolean.TRUE);
                    method.setAccessible(true);
                }
                value = method.invoke(target, args);
            }
            catch (IllegalArgumentException e) {
                value = "<illegal argument>";
                Log.debug(e);
            }
            catch (InvocationTargetException e) {
                value = "<target exception>";
                Log.debug(e);
            }
            catch (IllegalAccessException e) {
                value = "<not accessible>";
                Log.debug(e);
            }
            this.addRow(new Object[]{method, value});
        }
        this.fireTableDataChanged();
    }

    Method[] getPropertyMethods(Class cls, boolean filter) {
        if (cls == null) {
            return new Method[0];
        }
        HashMap<String, Method> processed = new HashMap<String, Method>();
        Method[] methods = cls.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!this.isGetterMethod(methods[i], false) || processed.containsKey(methods[i].getName()) || filter && filteredMethods.contains(methods[i].getName())) continue;
            processed.put(methods[i].getName(), methods[i]);
        }
        ComponentTester tester = ComponentTester.getTester(cls);
        methods = tester.getPropertyMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (processed.containsKey(methods[i].getName())) continue;
            processed.put(methods[i].getName(), methods[i]);
        }
        return processed.values().toArray(new Method[processed.size()]);
    }

    private boolean isGetterMethod(Method method, boolean isTester) {
        Class<?>[] types = method.getParameterTypes();
        int argc = types.length;
        return (isTester && argc == 1 && (class$java$awt$Component == null ? (class$java$awt$Component = ComponentPropertyModel.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(types[0]) || !isTester && argc == 0) && PropertyCall.isPropertyMethod(method);
    }

    private String getPropertyName(String methodName) {
        String propName = methodName;
        if (methodName.startsWith("get") || methodName.startsWith("has")) {
            propName = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            propName = methodName.substring(2);
        }
        return propName.substring(0, 1).toLowerCase() + propName.substring(1);
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            Method m = (Method)super.getValueAt(row, col);
            return this.getPropertyName(m.getName());
        }
        if (col == 3) {
            return (Method)super.getValueAt(row, 0);
        }
        if (col == 2) {
            Method m = (Method)this.getValueAt(row, 3);
            return this.noAccess.get(m) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getValueAt(row, col);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        filteredMethods.addAll(Arrays.asList("getAccessibleContext", "getAlignmentX", "getAlignmentY", "getColorModel", "getComponentListeners", "getComponentOrientation", "getDropTarget", "getFocusListeners", "getGraphics", "getGraphicsConfiguration", "getHierarchyBoundsListeners", "getHierarchyListeners", "getInputContext", "getInputMethodListeners", "getInputMethodRequests", "getKeyListeners", "getMouseListeners", "getMouseMotionListeners", "getMouseWheelListeners", "getParent", "getPeer", "getToolkit", "getTreeLock", "getComponents", "getContainerListeners", "getActionMap", "getAncestorListeners", "getAutoscrolls", "getBufferStrategy", "getDebugGraphicsOptions", "getInputMap", "getInputVerifier", "getPropertyChangeListeners", "getRegisteredKeyStrokes", "getRootPane", "getTopLevelAncestor", "getUIClassID", "getVerifyInputWhenFocusTarget", "getVetoableChangeListeners", "getVisibleRect", "isFocusCycleRoot", "isOpaque", "isOptimizedDrawingEnabled", "isPaintingTile", "isPreferredSizeSet", "isRequestFocusEnabled", "isValidateRoot", "getOwnedWindows", "getWindowFocusListeners", "getWindowListeners", "getWindowStateListeners", "getFrames"));
    }
}

