# ANALYSIS Visualisation/"Heatmap" (Draws a heatmap using Pearson correlation and average linkage.)
# INPUT GENE_EXPRS normalized.tsv OUTPUT heatmap.png
# PARAMETER coloring.scheme [Red-Green, Blue-Yellow, Black-White] DEFAULT Blue-Yellow (Coloring scheme for the SOM map)
# PARAMETER image.width INTEGER FROM 200 TO 3200 DEFAULT 600 (Width of the plotted network image)
# PARAMETER image.height INTEGER FROM 200 TO 3200 DEFAULT 600 (Height of the plotted network image)


# Heatmap
# JTT 3.10.2007

# Renaming variables
colpar<-coloring.scheme
w<-image.width
h<-image.height

# Loading the libraries
library(amap)

# Loads the normalized data
file<-c("normalized.tsv")
dat<-read.table(file, header=T, sep="\t", row.names=1)

# Separates expression values and flags
calls<-dat[,grep("flag", names(dat))]
dat2<-dat[,grep("chip", names(dat))]
colnames(dat2)<-gsub("chip.(.+)", "\\1", colnames(dat2)[grep("chip", colnames(dat2))])

# Does the clustering
clustg<-as.dendrogram(hcluster(x=dat2, method="pearson", link="average"))
clustc<-as.dendrogram(hcluster(x=t(dat2), method="pearson", link="average"))

# Generating the colors
if(colpar=="Red-Green") {
   heatcol<-colorRampPalette(c("Red", "Green"))(32)
}
if(colpar=="Blue-Yellow") {
   heatcol<-colorRampPalette(c("Blue", "Yellow"))(32)
}
if(colpar=="Black-White") {
   heatcol<-colorRampPalette(c("Black", "LightGrey"))(32)
}

# Plotting
bitmap(file="heatmap.png", width=w/72, height=h/72)
heatmap(x=as.matrix(dat2), Rowv=clustg, Colv=clustc, col=heatcol)
dev.off()
