/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.util.XmlUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneCruiserAPI {
    private final ClientApplication application = Session.getSession().getApplication();
    private static final String REQUEST_HEADER = "<?xml version=\"1.0\"?><soapenv:Envelope \n\txmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" \n\txmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" \n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n\t\n\t<soapenv:Body>\n\t\t<ns1:annotateProbes soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"\n\t\t\txmlns:ns1=\"http://server.gc.broad.mit.edu\">\n";
    private static final String REQUEST_FOOTER = "\t\t</ns1:annotateProbes>\n\t</soapenv:Body>\n</soapenv:Envelope>\n";
    private static final int CONNECTION_RETRIES = 2;
    private static final int CONNECTION_TIMEOUT = 5000;

    public String simpleAnnotate(String probeset) throws MicroarrayException {
        throw new UnsupportedOperationException();
    }

    public static String getRequest(Iterable<String> probes, String[] fields) {
        String s = "";
        s = s + REQUEST_HEADER;
        s = s + "<probes xsi:type=\"xsd:string[]\">\n";
        for (String probe : probes) {
            s = s + "<probe xsi:type=\"xsd:string\">" + probe + "</probe>\n";
        }
        s = s + "</probes>\n";
        s = s + "<queryFields xsi:type=\"xsd:string[]\">\n";
        for (String field : fields) {
            s = s + "<queryField xsi:type=\"xsd:string\">" + field + "</queryField>\n";
        }
        s = s + "</queryFields>\n";
        s = s + REQUEST_FOOTER;
        return s;
    }

    public String[][] annotate(List<String> probes) throws MicroarrayException {
        try {
            String[] queryFields = new String[]{"SwissProt Abrev. Gene Name", "SwissProt Accession", "RefSeq RefSeq Accession", "LocusLink Locus ID", "LocusLink Symbol", "LocusLink Description", "SwissProt Description", "Gene Ontology Term", "Gene Ontology GO ID"};
            URL url = new URL("http://www.broad.mit.edu/webservices/genecruiser/services/Annotation");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setReadTimeout(5000);
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.addRequestProperty("SOAPAction", "");
            this.application.setBusyMode(true);
            OutputStream outputStream = connection.getOutputStream();
            PrintWriter writer = new PrintWriter(outputStream);
            writer.print(GeneCruiserAPI.getRequest(probes, queryFields));
            writer.flush();
            outputStream.close();
            BufferedReader bufferedReader = null;
            for (int i = 0; i < 2; ++i) {
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    break;
                }
                catch (SocketTimeoutException e) {
                    if (i >= 1) {
                        throw e;
                    }
                    Thread.sleep(1000L);
                    continue;
                }
            }
            this.application.setBusyMode(false);
            Document document = XmlUtil.getInstance().parseReader(bufferedReader);
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            String[][] resultTable = new String[probes.size() + 1][queryFields.length + 1];
            resultTable[0][0] = "Probeset ID";
            for (int x = 0; x < queryFields.length; ++x) {
                resultTable[0][x + 1] = queryFields[x];
            }
            Element body = (Element)document.getDocumentElement().getElementsByTagName("soapenv:Body").item(0);
            NodeList results = body.getElementsByTagName("multiRef");
            for (int resultIndex = 0; resultIndex < results.getLength(); ++resultIndex) {
                String id;
                resultTable[resultIndex + 1][0] = id = ((Element)results.item(resultIndex)).getElementsByTagName("id").item(0).getTextContent();
                Element result = (Element)((Element)results.item(resultIndex)).getElementsByTagName("columns").item(0);
                LinkedList<Element> fields = GeneCruiserAPI.childElements(result, "columns");
                assert (fields.size() == queryFields.length);
                for (int i = 0; i < fields.size(); ++i) {
                    LinkedList<Element> values = GeneCruiserAPI.childElements(fields.get(i), "columns");
                    String s = "";
                    for (int i2 = 0; i2 < values.size(); ++i2) {
                        Element value = values.get(i2);
                        s = s + value.getTextContent().trim() + (i2 < values.size() - 1 ? ", " : "");
                    }
                    resultTable[resultIndex + 1][i + 1] = s;
                }
            }
            String[][] stringArray = this.postProcess(resultTable);
            return stringArray;
        }
        catch (IOException ioe) {
            if (ioe.getMessage().contains("Server returned HTTP response code: 500")) {
                throw new MicroarrayException("GeneCruiser remote service failed (HTTP code 500). This can happen when annotating too many probes per time. Please try using fewer probes.");
            }
            throw new MicroarrayException((Exception)ioe);
        }
        catch (Exception e) {
            throw new MicroarrayException(e);
        }
        finally {
            this.application.setBusyMode(false);
        }
    }

    private String[][] postProcess(String[][] returnValue) {
        for (int i = 0; i < returnValue[0].length; ++i) {
            returnValue[0][i] = returnValue[0][i].replace("SwissProt", "UniProt");
            returnValue[0][i] = returnValue[0][i].replace("Gene Ontology Term", "GO Term");
            returnValue[0][i] = returnValue[0][i].replace("Gene Ontology GO ID", "GO ID");
            returnValue[0][i] = returnValue[0][i].replace("RefSeq RefSeq", "RefSeq");
            returnValue[0][i] = returnValue[0][i].replace("Accession", "");
            returnValue[0][i] = returnValue[0][i].replace("Abrev.", "");
            returnValue[0][i] = returnValue[0][i].replace("Locus ID", "");
            returnValue[0][i] = returnValue[0][i].replace("LocusLink", "Entrez Gene");
        }
        for (int row = 1; row < returnValue.length; ++row) {
            for (int i = 0; i < returnValue[row].length; ++i) {
                if (returnValue[row][i].contains("Name=")) {
                    returnValue[row][i] = returnValue[row][i].replace("Name=", "");
                    returnValue[row][i] = returnValue[row][i].contains("Synonyms") ? returnValue[row][i].replace("; Synonyms=", " (synonyms: ") : returnValue[row][i].replace(";", "");
                    returnValue[row][i] = returnValue[row][i].replace(";", ")");
                }
                returnValue[row][i] = returnValue[row][i].replace("urn:lsid:ncbi.nlm.nih.gov.lsid.i3c.org:locuslink.locusid:", "");
                returnValue[row][i] = returnValue[row][i].replace("urn:lsid:ncbi.nlm.nih.gov.lsid.i3c.org:refseq.accession:", "");
                returnValue[row][i] = returnValue[row][i].replace("urn:lsid:geneontology.org.lsid.i3c.org:GO:GO:", "");
            }
        }
        return returnValue;
    }

    public static void main(String[] args) throws Exception {
        MicroarrayConfiguration.loadConfiguration();
        LinkedList<String> probesets = new LinkedList<String>();
        probesets.add("1428061_at");
        probesets.add("100084_at");
        probesets.add("AB002409_at");
        LinkedList<String> fields = new LinkedList<String>();
        fields.add("Gene Ontology Source");
        fields.add("LocusLink Locus ID");
        String[][] result = new GeneCruiserAPI().annotate(probesets);
        for (int x = 0; x < result.length; ++x) {
            for (int y = 0; y < result[x].length; ++y) {
                System.out.print(result[x][y] + " ");
            }
            System.out.println("");
        }
    }

    public static LinkedList<Element> childElements(Element element, String name) {
        LinkedList<Element> elements = new LinkedList<Element>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element) || !children.item(i).getNodeName().equals(name)) continue;
            elements.add((Element)children.item(i));
        }
        return elements;
    }
}

